/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.clientreport;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.DataCategory;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.AtomicClientReportStorage;
import io.sentry.clientreport.ClientReport;
import io.sentry.clientreport.ClientReportKey;
import io.sentry.clientreport.DiscardReason;
import io.sentry.clientreport.DiscardedEvent;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.IClientReportStorage;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class ClientReportRecorder
implements IClientReportRecorder {
    private final IClientReportStorage storage;
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public ClientReportRecorder(SentryOptions options) {
        void var1_1;
        this.options = var1_1;
        this.storage = new AtomicClientReportStorage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CloseKt attachReportToEnvelope$55c43c21(CloseKt envelope) {
        List<DiscardedEvent> list = this;
        Date date = AnimationSpecKt.getCurrentDateTime();
        list = ((ClientReportRecorder)((Object)list)).storage.resetCountsAndGet();
        ClientReport clientReport = list.isEmpty() ? null : new ClientReport(date, list);
        if (clientReport == null) {
            return envelope;
        }
        try {
            this.options.getLogger().log(SentryLevel.DEBUG, "Attaching client report to envelope.", new Object[0]);
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                items.add(item);
            }
            items.add(SentryEnvelopeItem.fromClientReport(this.options.getSerializer(), (ClientReport)((Object)list)));
            return new CloseKt(envelope.getHeader(), items);
        }
        catch (Throwable e) {
            void var1_1;
            void var3_4;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_4, "Unable to attach client report to envelope.", new Object[0]);
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEnvelope$280c6a9c(DiscardReason reason, CloseKt envelope) {
        if (envelope == null) {
            return;
        }
        try {
            for (SentryEnvelopeItem item : envelope.getItems()) {
                void var3_4;
                this.recordLostEnvelopeItem(reason, (SentryEnvelopeItem)var3_4);
            }
            return;
        }
        catch (Throwable e) {
            void var2_3;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var2_3, "Unable to record lost envelope.", new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEnvelopeItem(DiscardReason reason, SentryEnvelopeItem envelopeItem) {
        block6: {
            if (envelopeItem == null) {
                return;
            }
            try {
                void var1_1;
                SentryItemType itemType = envelopeItem.getHeader().getType();
                if (SentryItemType.ClientReport.equals(itemType)) {
                    try {
                        void var2_2;
                        ClientReport clientReport = var2_2.getClientReport(this.options.getSerializer());
                        this.restoreCountsFromClientReport((ClientReport)var1_1);
                    }
                    catch (Exception exception) {
                        this.options.getLogger().log(SentryLevel.ERROR, "Unable to restore counts from previous client report.", new Object[0]);
                    }
                    break block6;
                }
                this.recordLostEventInternal(var1_1.getReason(), ClientReportRecorder.categoryFromItemType(itemType).getCategory(), 1L);
                return;
            }
            catch (Throwable e) {
                void var3_4;
                this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var3_4, "Unable to record lost envelope item.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recordLostEvent(DiscardReason reason, DataCategory category) {
        try {
            void var2_3;
            this.recordLostEventInternal(reason.getReason(), var2_3.getCategory(), 1L);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)var1_2, "Unable to record lost event.", new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void recordLostEventInternal(String reason, String category, Long countToAdd) {
        void var3_3;
        void var1_1;
        void var2_2;
        ClientReportKey key = new ClientReportKey(reason, (String)var2_2);
        this.storage.addCount((ClientReportKey)var1_1, (Long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void restoreCountsFromClientReport(ClientReport clientReport) {
        Iterator<DiscardedEvent> iterator;
        if (clientReport == null) {
            return;
        }
        for (DiscardedEvent discardedEvent : ((ClientReport)((Object)iterator)).getDiscardedEvents()) {
            void var2_2;
            this.recordLostEventInternal(discardedEvent.getReason(), discardedEvent.getCategory(), var2_2.getQuantity());
        }
    }

    private static DataCategory categoryFromItemType(SentryItemType itemType) {
        SentryItemType sentryItemType;
        if (SentryItemType.Event.equals(itemType)) {
            return DataCategory.Error;
        }
        if (SentryItemType.Session.equals(itemType)) {
            return DataCategory.Session;
        }
        if (SentryItemType.Transaction.equals(itemType)) {
            return DataCategory.Transaction;
        }
        if (SentryItemType.UserFeedback.equals(itemType)) {
            return DataCategory.UserReport;
        }
        if (SentryItemType.Attachment.equals(sentryItemType)) {
            return DataCategory.Attachment;
        }
        return DataCategory.Default;
    }
}

