/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.clientreport;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryLevel;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class DiscardedEvent
implements JsonSerializable {
    private final String reason;
    private final String category;
    private final Long quantity;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public DiscardedEvent(String reason, String category, Long quantity) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.reason = var1_1;
        this.category = var2_2;
        this.quantity = var3_3;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String getCategory() {
        return this.category;
    }

    public final Long getQuantity() {
        return this.quantity;
    }

    public final String toString() {
        return "DiscardedEvent{reason='" + this.reason + '\'' + ", category='" + this.category + '\'' + ", quantity=" + this.quantity + '}';
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("reason").value(this.reason);
        writer.name("category").value(this.category);
        writer.name("quantity").value(this.quantity);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    public static final class Deserializer
    implements JsonDeserializer<DiscardedEvent> {
        /*
         * WARNING - void declaration
         */
        @Override
        private DiscardedEvent deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var1_1;
            String reason = null;
            String category = null;
            Long quanity = null;
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block10: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "reason": {
                        reason = reader.nextStringOrNull();
                        continue block10;
                    }
                    case "category": {
                        category = reader.nextStringOrNull();
                        continue block10;
                    }
                    case "quantity": {
                        quanity = reader.nextLongOrNull();
                        continue block10;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            var1_1.endObject();
            if (reason == null) {
                throw Deserializer.missingRequiredFieldException("reason", logger);
            }
            if (category == null) {
                throw Deserializer.missingRequiredFieldException("category", logger);
            }
            if (quanity == null) {
                void var2_2;
                throw Deserializer.missingRequiredFieldException("quantity", (ILogger)var2_2);
            }
            DiscardedEvent discardedEvent = new DiscardedEvent((String)var3_3, category, quanity);
            discardedEvent.setUnknown(unknown);
            return discardedEvent;
        }

        /*
         * WARNING - void declaration
         */
        private static Exception missingRequiredFieldException(String field, ILogger logger) {
            void var2_2;
            String string;
            void var1_1;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var1_1.log(SentryLevel.ERROR, string, exception);
            return var2_2;
        }
    }
}

