/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.hints;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.hints.DiskFlushNotification;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class BlockingFlushHint
implements DiskFlushNotification {
    private final CountDownLatch latch;
    private final long flushTimeoutMillis;
    private final ILogger logger;

    /*
     * WARNING - void declaration
     */
    public BlockingFlushHint(long flushTimeoutMillis, ILogger logger) {
        void var3_2;
        void var1_1;
        this.flushTimeoutMillis = var1_1;
        this.latch = new CountDownLatch(1);
        this.logger = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean waitFlush() {
        try {
            return this.latch.await(this.flushTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            void var1_1;
            Thread.currentThread().interrupt();
            this.logger.log(SentryLevel.ERROR, "Exception while awaiting for flush in BlockingFlushHint", (Throwable)var1_1);
            return false;
        }
    }

    @Override
    public final void markFlushed() {
        this.latch.countDown();
    }
}

