/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal.debugmeta;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.internal.debugmeta.IDebugMetaLoader;
import io.sentry.util.DebugMetaPropertiesApplier;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ResourcesDebugMetaLoader
implements IDebugMetaLoader {
    private final ILogger logger;
    private final ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    public ResourcesDebugMetaLoader(ILogger logger) {
        this((ILogger)var1_1, ResourcesDebugMetaLoader.class.getClassLoader());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ResourcesDebugMetaLoader(ILogger logger, ClassLoader classLoader) {
        void var2_2;
        void var1_1;
        this.logger = var1_1;
        this.classLoader = AnimationSpecKt.classLoaderOrDefault((ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Properties loadDebugMeta() {
        block10: {
            InputStream debugMetaStream = this.classLoader.getResourceAsStream(DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            if (debugMetaStream == null) {
                this.logger.log(SentryLevel.INFO, "%s file was not found.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            } else {
                void var3_6;
                BufferedInputStream is = new BufferedInputStream(debugMetaStream);
                try {
                    void var2_4;
                    Properties properties = new Properties();
                    properties.load(is);
                    var3_6 = var2_4;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.log(SentryLevel.ERROR, e, "Failed to load %s", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                        break block10;
                    }
                    catch (RuntimeException e) {
                        void var1_3;
                        this.logger.log(SentryLevel.ERROR, (Throwable)var1_3, "%s file is malformed.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                    }
                }
                ((InputStream)is).close();
                return var3_6;
            }
        }
        return null;
    }
}

