/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal.modules;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.internal.modules.ModulesLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ManifestModulesLoader
extends ModulesLoader {
    private final Pattern URL_LIB_PATTERN = Pattern.compile(".*/(.+)!/META-INF/MANIFEST.MF");
    private final Pattern NAME_AND_VERSION = Pattern.compile("(.*?)-(\\d+\\.\\d+.*).jar");
    private final ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    public ManifestModulesLoader(ILogger logger) {
        this(ManifestModulesLoader.class.getClassLoader(), (ILogger)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ManifestModulesLoader(ClassLoader classLoader, ILogger logger) {
        super((ILogger)var2_2);
        void var1_1;
        void var2_2;
        this.classLoader = AnimationSpecKt.classLoaderOrDefault((ClassLoader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Map<String, String> loadModules() {
        void var1_1;
        HashMap<String, String> modules = new HashMap<String, String>();
        Object object = this.detectModulesViaManifestFiles();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Module module = (Module)object.next();
            modules.put(module.name, ((Module)var3_3).version);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Module> detectModulesViaManifestFiles() {
        void var1_1;
        ArrayList<void> modules = new ArrayList<void>();
        try {
            Enumeration<URL> manifestUrls = this.classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifestUrls.hasMoreElements()) {
                void var3_4;
                Module module;
                Object originalName;
                Object manifestUrl;
                Object object = manifestUrl = manifestUrls.nextElement();
                manifestUrl = this;
                manifestUrl = ((ManifestModulesLoader)manifestUrl).URL_LIB_PATTERN.matcher((CharSequence)(object = ((URL)object).toString()));
                object = originalName = ((Matcher)manifestUrl).matches() && ((Matcher)manifestUrl).groupCount() == 1 ? ((Matcher)manifestUrl).group(1) : null;
                originalName = this;
                if (object != null && ((Matcher)(object = ((ManifestModulesLoader)originalName).NAME_AND_VERSION.matcher((CharSequence)object))).matches() && ((Matcher)object).groupCount() == 2) {
                    originalName = ((Matcher)object).group(1);
                    object = ((Matcher)object).group(2);
                    module = new Module((String)originalName, (String)object);
                } else {
                    Module module2;
                    module = module2 = null;
                }
                if (module == null) continue;
                modules.add(var3_4);
            }
        }
        catch (Throwable e) {
            void var2_3;
            this.logger.log(SentryLevel.ERROR, "Unable to detect modules via manifest files.", (Throwable)var2_3);
        }
        return var1_1;
    }

    static final class Module {
        private final String name;
        private final String version;

        /*
         * WARNING - void declaration
         */
        public Module(String name, String version) {
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.version = var2_2;
        }
    }
}

