/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.internal.modules;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.internal.modules.IModulesLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

public abstract class ModulesLoader
implements IModulesLoader {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final ILogger logger;
    private Map<String, String> cachedModules = null;

    /*
     * WARNING - void declaration
     */
    public ModulesLoader(ILogger logger) {
        void var1_1;
        this.logger = var1_1;
    }

    @Override
    public final Map<String, String> getOrLoadModules() {
        if (this.cachedModules != null) {
            return this.cachedModules;
        }
        this.cachedModules = this.loadModules();
        return this.cachedModules;
    }

    protected abstract Map<String, String> loadModules();

    /*
     * WARNING - void declaration
     */
    protected final Map<String, String> parseStream(InputStream stream) {
        void var2_4;
        TreeMap<String, void> modules = new TreeMap<String, void>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, UTF_8));){
            String module = reader.readLine();
            while (module != null) {
                String string;
                int sep = module.lastIndexOf(58);
                String group = module.substring(0, sep);
                String version = module.substring(sep + 1);
                modules.put(group, (void)string);
                string = reader.readLine();
            }
            this.logger.log(SentryLevel.DEBUG, "Extracted %d modules from resources.", modules.size());
        }
        catch (IOException e) {
            this.logger.log(SentryLevel.ERROR, "Error extracting modules.", e);
        }
        catch (RuntimeException e) {
            void var1_3;
            this.logger.log(SentryLevel.ERROR, (Throwable)var1_3, "%s file is malformed.", "sentry-external-modules.txt");
        }
        return var2_4;
    }
}

