/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class OperatingSystem
implements JsonSerializable {
    private String name;
    private String version;
    private String rawDescription;
    private String build;
    private String kernelVersion;
    private Boolean rooted;
    private Map<String, Object> unknown;

    public OperatingSystem() {
    }

    /*
     * WARNING - void declaration
     */
    OperatingSystem(OperatingSystem operatingSystem) {
        void var1_1;
        this.name = operatingSystem.name;
        this.version = operatingSystem.version;
        this.rawDescription = operatingSystem.rawDescription;
        this.build = operatingSystem.build;
        this.kernelVersion = operatingSystem.kernelVersion;
        this.rooted = operatingSystem.rooted;
        this.unknown = CollectionUtils.newConcurrentHashMap(var1_1.unknown);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)o;
        return AnimationSpecKt.equals((Object)this.name, (Object)that.name) && AnimationSpecKt.equals((Object)this.version, (Object)that.version) && AnimationSpecKt.equals((Object)this.rawDescription, (Object)that.rawDescription) && AnimationSpecKt.equals((Object)this.build, (Object)that.build) && AnimationSpecKt.equals((Object)this.kernelVersion, (Object)that.kernelVersion) && AnimationSpecKt.equals((Object)this.rooted, (Object)var1_1.rooted);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.version, this.rawDescription, this.build, this.kernelVersion, this.rooted};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        if (this.name != null) {
            writer.name("name").value(this.name);
        }
        if (this.version != null) {
            writer.name("version").value(this.version);
        }
        if (this.rawDescription != null) {
            writer.name("raw_description").value(this.rawDescription);
        }
        if (this.build != null) {
            writer.name("build").value(this.build);
        }
        if (this.kernelVersion != null) {
            writer.name("kernel_version").value(this.kernelVersion);
        }
        if (this.rooted != null) {
            writer.name("rooted").value(this.rooted);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(OperatingSystem x0, String x1) {
        void var1_1;
        x0.name = var1_1;
        return x0.name;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(OperatingSystem x0, String x1) {
        void var1_1;
        x0.version = var1_1;
        return x0.version;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$202(OperatingSystem x0, String x1) {
        void var1_1;
        x0.rawDescription = var1_1;
        return x0.rawDescription;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(OperatingSystem x0, String x1) {
        void var1_1;
        x0.build = var1_1;
        return x0.build;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(OperatingSystem x0, String x1) {
        void var1_1;
        x0.kernelVersion = var1_1;
        return x0.kernelVersion;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Boolean access$502(OperatingSystem x0, Boolean x1) {
        void var1_1;
        x0.rooted = var1_1;
        return x0.rooted;
    }

    public static final class Deserializer
    implements JsonDeserializer<OperatingSystem> {
        /*
         * WARNING - void declaration
         */
        public static OperatingSystem deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var2_2;
            JsonObjectReader jsonObjectReader;
            void var3_3;
            reader.beginObject();
            OperatingSystem operatingSystem = new OperatingSystem();
            ConcurrentHashMap<String, Object> unknown = null;
            block16: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "name": {
                        OperatingSystem.access$002(operatingSystem, reader.nextStringOrNull());
                        continue block16;
                    }
                    case "version": {
                        OperatingSystem.access$102(operatingSystem, reader.nextStringOrNull());
                        continue block16;
                    }
                    case "raw_description": {
                        OperatingSystem.access$202(operatingSystem, reader.nextStringOrNull());
                        continue block16;
                    }
                    case "build": {
                        OperatingSystem.access$302(operatingSystem, reader.nextStringOrNull());
                        continue block16;
                    }
                    case "kernel_version": {
                        OperatingSystem.access$402(operatingSystem, reader.nextStringOrNull());
                        continue block16;
                    }
                    case "rooted": {
                        OperatingSystem.access$502(operatingSystem, reader.nextBooleanOrNull());
                        continue block16;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            operatingSystem.setUnknown((Map<String, Object>)var3_3);
            jsonObjectReader.endObject();
            return var2_2;
        }
    }
}

