/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryPackage;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SdkVersion
implements JsonSerializable {
    private String name;
    private String version;
    private Set<SentryPackage> deserializedPackages;
    private Set<String> deserializedIntegrations;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SdkVersion(String name, String version) {
        void var2_2;
        void var1_1;
        this.name = (String)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"name is required.");
        this.version = (String)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"version is required.");
    }

    /*
     * WARNING - void declaration
     */
    public final void setVersion(String version) {
        void var1_1;
        this.version = (String)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"version is required.");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkVersion that = (SdkVersion)o;
        return this.name.equals(that.name) && this.version.equals(var1_1.version);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.version};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        Set<String> integrations;
        writer.beginObject();
        writer.name("name").value(this.name);
        writer.name("version").value(this.version);
        SdkVersion sdkVersion = this;
        Set<SentryPackage> packages = sdkVersion.deserializedPackages != null ? sdkVersion.deserializedPackages : SentryIntegrationPackageStorage.getInstance().getPackages();
        sdkVersion = this;
        Set<String> set = integrations = sdkVersion.deserializedIntegrations != null ? sdkVersion.deserializedIntegrations : SentryIntegrationPackageStorage.getInstance().getIntegrations();
        if (!packages.isEmpty()) {
            Iterator<String> iterator;
            writer.name("packages").value(logger, iterator);
        }
        if (!integrations.isEmpty()) {
            writer.name("integrations").value(logger, integrations);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$002(SdkVersion x0, Set x1) {
        void var1_1;
        x0.deserializedPackages = var1_1;
        return x0.deserializedPackages;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$102(SdkVersion x0, Set x1) {
        void var1_1;
        x0.deserializedIntegrations = var1_1;
        return x0.deserializedIntegrations;
    }

    public static final class Deserializer
    implements JsonDeserializer<SdkVersion> {
        /*
         * WARNING - void declaration
         */
        private static SdkVersion deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var3_3;
            void var2_2;
            IllegalStateException exception;
            String message;
            JsonObjectReader jsonObjectReader;
            String name = null;
            String version = null;
            ArrayList<SentryPackage> packages = new ArrayList<SentryPackage>();
            ArrayList integrations = new ArrayList();
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block12: while (reader.peek() == JsonToken.NAME) {
                List deserializedIntegrations;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "version": {
                        version = reader.nextString();
                        continue block12;
                    }
                    case "packages": {
                        List<SentryPackage> deserializedPackages = reader.nextList(logger, new SentryPackage.Deserializer());
                        if (deserializedPackages == null) continue block12;
                        packages.addAll(deserializedPackages);
                        continue block12;
                    }
                    case "integrations": {
                        deserializedIntegrations = (List)reader.nextObjectOrNull();
                        if (deserializedIntegrations == null) continue block12;
                        integrations.addAll(deserializedIntegrations);
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)((Object)deserializedIntegrations));
            }
            jsonObjectReader.endObject();
            if (name == null) {
                message = "Missing required field \"name\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (version == null) {
                void var1_1;
                message = "Missing required field \"version\"";
                exception = new IllegalStateException(message);
                var1_1.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            SdkVersion sdkVersion = new SdkVersion((String)var2_2, (String)var3_3);
            SdkVersion.access$002(sdkVersion, new CopyOnWriteArraySet(packages));
            SdkVersion.access$102(sdkVersion, new CopyOnWriteArraySet(integrations));
            sdkVersion.setUnknown(unknown);
            return sdkVersion;
        }
    }
}

