/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.util.StringUtils;
import java.io.IOException;
import java.util.UUID;

public final class SentryId
implements JsonSerializable {
    private final UUID uuid;
    public static final SentryId EMPTY_ID = new SentryId(new UUID(0L, 0L));

    public SentryId() {
        this((UUID)null);
    }

    /*
     * WARNING - void declaration
     */
    private SentryId(UUID uuid) {
        void var1_1;
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        this.uuid = var1_1;
    }

    public SentryId(String sentryIdString) {
        String string;
        string = StringUtils.normalizeUUID(string);
        if (string.length() == 32) {
            string = new StringBuilder(string).insert(8, "-").insert(13, "-").insert(18, "-").insert(23, "-").toString();
        }
        if (string.length() != 36) {
            throw new IllegalArgumentException("String representation of SentryId has either 32 (UUID no dashes) or 36 characters long (completed UUID). Received: " + string);
        }
        this.uuid = UUID.fromString(string);
    }

    public final String toString() {
        return StringUtils.normalizeUUID(this.uuid.toString()).replace("-", "");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryId sentryId = (SentryId)o;
        return this.uuid.compareTo(var1_1.uuid) == 0;
    }

    public final int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        writer.value(this.toString());
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryId> {
        public static SentryId deserialize$7961c0e3(JsonObjectReader reader) throws Exception {
            JsonObjectReader jsonObjectReader;
            return new SentryId(jsonObjectReader.nextString());
        }
    }
}

