/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import androidx.compose.animation.core.AnimationSpecKt;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.protocol.SentryId;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SentrySpan
implements JsonSerializable {
    private final Double startTimestamp;
    private final Double timestamp;
    private final SentryId traceId;
    private final SpanId spanId;
    private final SpanId parentSpanId;
    private final String op;
    private final String description;
    private final SpanStatus status;
    private final Map<String, String> tags;
    private final Map<String, Object> data;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public SentrySpan(Double startTimestamp, Double timestamp, SentryId traceId, SpanId spanId, SpanId parentSpanId, String op, String description, SpanStatus status, Map<String, String> tags, Map<String, Object> data) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.startTimestamp = var1_1;
        this.timestamp = var2_2;
        this.traceId = var3_3;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.op = op;
        this.description = description;
        this.status = status;
        this.tags = tags;
        this.data = data;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(JsonObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("start_timestamp").value(logger, SentrySpan.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer.name("timestamp").value(logger, SentrySpan.doubleToBigDecimal(this.timestamp));
        }
        writer.name("trace_id").value(logger, this.traceId);
        writer.name("span_id").value(logger, this.spanId);
        if (this.parentSpanId != null) {
            writer.name("parent_span_id").value(logger, this.parentSpanId);
        }
        writer.name("op").value(this.op);
        if (this.description != null) {
            writer.name("description").value(this.description);
        }
        if (this.status != null) {
            writer.name("status").value(logger, this.status);
        }
        if (!this.tags.isEmpty()) {
            writer.name("tags").value(logger, this.tags);
        }
        if (this.data != null) {
            writer.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    private static BigDecimal doubleToBigDecimal(Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    public static final class Deserializer
    implements JsonDeserializer<SentrySpan> {
        /*
         * WARNING - void declaration
         */
        @Override
        private SentrySpan deserialize(JsonObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            Double startTimestamp = null;
            Double timestamp = null;
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            HashMap<String, String> tags = null;
            Map data = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block28: while (reader.peek() == JsonToken.NAME) {
                Date date;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "start_timestamp": {
                        try {
                            startTimestamp = reader.nextDoubleOrNull();
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            startTimestamp = date != null ? Double.valueOf(AnimationSpecKt.dateToSeconds((Date)date)) : null;
                        }
                        continue block28;
                    }
                    case "timestamp": {
                        try {
                            timestamp = reader.nextDoubleOrNull();
                        }
                        catch (NumberFormatException numberFormatException) {
                            date = reader.nextDateOrNull(logger);
                            timestamp = date != null ? Double.valueOf(AnimationSpecKt.dateToSeconds((Date)date)) : null;
                        }
                        continue block28;
                    }
                    case "trace_id": {
                        new SentryId.Deserializer();
                        traceId = SentryId.Deserializer.deserialize$7961c0e3(reader);
                        continue block28;
                    }
                    case "span_id": {
                        new SpanId.Deserializer();
                        spanId = SpanId.Deserializer.deserialize$13205d43(reader);
                        continue block28;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block28;
                    }
                    case "op": {
                        op = reader.nextStringOrNull();
                        continue block28;
                    }
                    case "description": {
                        description = reader.nextStringOrNull();
                        continue block28;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block28;
                    }
                    case "tags": {
                        tags = (Map)reader.nextObjectOrNull();
                        continue block28;
                    }
                    case "data": {
                        data = (Map)reader.nextObjectOrNull();
                        continue block28;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)((Object)date));
            }
            if (startTimestamp == null) {
                throw Deserializer.missingRequiredFieldException("start_timestamp", logger);
            }
            if (traceId == null) {
                throw Deserializer.missingRequiredFieldException("trace_id", logger);
            }
            if (spanId == null) {
                throw Deserializer.missingRequiredFieldException("span_id", logger);
            }
            if (op == null) {
                void var2_2;
                throw Deserializer.missingRequiredFieldException("op", (ILogger)var2_2);
            }
            if (tags == null) {
                tags = new HashMap();
            }
            SentrySpan sentrySpan = new SentrySpan((Double)var3_3, timestamp, traceId, spanId, parentSpanId, op, description, status, tags, data);
            sentrySpan.setUnknown(unknown);
            var1_1.endObject();
            return sentrySpan;
        }

        /*
         * WARNING - void declaration
         */
        private static Exception missingRequiredFieldException(String field, ILogger logger) {
            void var2_2;
            String string;
            void var1_1;
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            var1_1.log(SentryLevel.ERROR, string, exception);
            return var2_2;
        }
    }
}

