/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.text.selection.TextSelectionMouseDetectorKt;
import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.Cached;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.HttpConnection;
import io.sentry.transport.ITransport;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.QueuedThreadPoolExecutor;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.TransportResult;
import io.sentry.util.HintUtils;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class AsyncHttpTransport
implements ITransport {
    private final QueuedThreadPoolExecutor executor;
    private final IEnvelopeCache envelopeCache;
    private final SentryOptions options;
    private final RateLimiter rateLimiter;
    private final ITransportGate transportGate;
    private final HttpConnection connection;

    /*
     * WARNING - void declaration
     */
    public AsyncHttpTransport(SentryOptions options, RateLimiter rateLimiter, ITransportGate transportGate, TextSelectionMouseDetectorKt requestDetails) {
        void var2_2;
        void var1_1;
        void var3_3;
        ILogger iLogger = options.getLogger();
        Object object = options.getEnvelopeDiskCache();
        int n = options.getMaxQueueSize();
        object = (arg_0, arg_1) -> AsyncHttpTransport.lambda$initExecutor$0((IEnvelopeCache)object, iLogger, arg_0, arg_1);
        this(new QueuedThreadPoolExecutor(1, n, new AsyncConnectionThreadFactory(0), (RejectedExecutionHandler)object, iLogger), options, rateLimiter, (ITransportGate)var3_3, new HttpConnection((SentryOptions)var1_1, requestDetails, (RateLimiter)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private AsyncHttpTransport(QueuedThreadPoolExecutor executor, SentryOptions options, RateLimiter rateLimiter, ITransportGate transportGate, HttpConnection httpConnection) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.executor = (QueuedThreadPoolExecutor)AnimationSpecKt.requireNonNull((Object)var1_1, (String)"executor is required");
        this.envelopeCache = (IEnvelopeCache)AnimationSpecKt.requireNonNull((Object)options.getEnvelopeDiskCache(), (String)"envelopeCache is required");
        this.options = (SentryOptions)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"options is required");
        this.rateLimiter = (RateLimiter)AnimationSpecKt.requireNonNull((Object)var3_3, (String)"rateLimiter is required");
        this.transportGate = (ITransportGate)AnimationSpecKt.requireNonNull((Object)transportGate, (String)"transportGate is required");
        this.connection = (HttpConnection)AnimationSpecKt.requireNonNull((Object)httpConnection, (String)"httpConnection is required");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void send$74b70ef(CloseKt envelope, Hint hint) throws IOException {
        CloseKt filteredEnvelope;
        IEnvelopeCache currentEnvelopeCache = this.envelopeCache;
        boolean cached = false;
        if (HintUtils.hasType(hint, Cached.class)) {
            currentEnvelopeCache = NoOpEnvelopeCache.getInstance();
            cached = true;
            this.options.getLogger().log(SentryLevel.DEBUG, "Captured Envelope is already cached", new Object[0]);
        }
        if ((filteredEnvelope = this.rateLimiter.filter$198c1f40(envelope, hint)) == null) {
            if (cached) {
                this.envelopeCache.discard$6b7e726e(envelope);
                return;
            }
        } else {
            void var2_2;
            void var3_3;
            CloseKt envelopeThatMayIncludeClientReport = HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class) ? this.options.getClientReportRecorder().attachReportToEnvelope$55c43c21(filteredEnvelope) : filteredEnvelope;
            Future<?> future = this.executor.submit(new EnvelopeSender(this, envelopeThatMayIncludeClientReport, hint, (IEnvelopeCache)var3_3));
            if (future != null && var2_2.isCancelled()) {
                void var1_1;
                this.options.getClientReportRecorder().recordLostEnvelope$280c6a9c(DiscardReason.QUEUE_OVERFLOW, (CloseKt)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush(long timeoutMillis) {
        void var1_1;
        this.executor.waitTillIdle((long)var1_1);
    }

    @Override
    public final void close() throws IOException {
        this.executor.shutdown();
        this.options.getLogger().log(SentryLevel.DEBUG, "Shutting down", new Object[0]);
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to shutdown the async connection async sender within 1 minute. Trying to force it now.", new Object[0]);
                this.executor.shutdownNow();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
            return;
        }
    }

    private static /* synthetic */ void lambda$markHintWhenSendingFailed$2(boolean retry, Retryable retryable) {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$initExecutor$0(IEnvelopeCache envelopeCache, ILogger logger, Runnable r, ThreadPoolExecutor executor) {
        if (r instanceof EnvelopeSender) {
            void var1_3;
            void var2_4;
            EnvelopeSender envelopeSender = (EnvelopeSender)r;
            if (!HintUtils.hasType(envelopeSender.hint, Cached.class)) {
                IEnvelopeCache iEnvelopeCache;
                iEnvelopeCache.store$74b70ef(envelopeSender.envelope$7be15cc7, envelopeSender.hint);
            }
            boolean bl = true;
            Hint hint = ((EnvelopeSender)var2_4).hint;
            HintUtils.runIfHasType(hint, SubmissionResult.class, result -> {});
            HintUtils.runIfHasType(hint, Retryable.class, arg_0 -> AsyncHttpTransport.lambda$markHintWhenSendingFailed$2(true, arg_0));
            var1_3.log(SentryLevel.WARNING, "Envelope rejected", new Object[0]);
        }
    }

    final class EnvelopeSender
    implements Runnable {
        private final CloseKt envelope$7be15cc7;
        private final Hint hint;
        private final IEnvelopeCache envelopeCache;
        private final TransportResult failedResult = TransportResult.error(-1);
        private /* synthetic */ AsyncHttpTransport this$0;

        /*
         * WARNING - void declaration
         */
        EnvelopeSender(AsyncHttpTransport asyncHttpTransport, CloseKt envelope, Hint hint, IEnvelopeCache envelopeCache) {
            void var3_3;
            void var2_2;
            this.this$0 = asyncHttpTransport;
            this.envelope$7be15cc7 = (CloseKt)AnimationSpecKt.requireNonNull((Object)var2_2, (String)"Envelope is required.");
            this.hint = var3_3;
            this.envelopeCache = (IEnvelopeCache)AnimationSpecKt.requireNonNull((Object)envelopeCache, (String)"EnvelopeCache is required.");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            TransportResult finalResult;
            TransportResult result = this.failedResult;
            try {
                result = this.flush();
                this.this$0.options.getLogger().log(SentryLevel.DEBUG, "Envelope flushed", new Object[0]);
                finalResult = result;
            }
            catch (Throwable e) {
                try {
                    void var2_3;
                    this.this$0.options.getLogger().log(SentryLevel.ERROR, e, "Envelope submission failed", new Object[0]);
                    throw var2_3;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    HintUtils.runIfHasType(this.hint, SubmissionResult.class, arg_0 -> this.lambda$run$0((TransportResult)var1_1, arg_0));
                    throw throwable;
                }
            }
            HintUtils.runIfHasType(this.hint, SubmissionResult.class, submissionResult -> {
                void var1_1;
                this.this$0.options.getLogger().log(SentryLevel.DEBUG, "Marking envelope submission result: %s", var1_1.isSuccess());
            });
            return;
        }

        /*
         * WARNING - void declaration
         */
        private TransportResult flush() {
            TransportResult transportResult = null;
            this.envelope$7be15cc7.getHeader().setSentAt(null);
            this.envelopeCache.store$74b70ef(this.envelope$7be15cc7, this.hint);
            HintUtils.runIfHasType(this.hint, DiskFlushNotification.class, diskFlushNotification -> {
                diskFlushNotification.markFlushed();
                this.this$0.options.getLogger().log(SentryLevel.DEBUG, "Disk flush envelope fired", new Object[0]);
            });
            this.this$0.transportGate;
            CloseKt envelopeWithClientReport = this.this$0.options.getClientReportRecorder().attachReportToEnvelope$55c43c21(this.envelope$7be15cc7);
            try {
                Comparable<SentryDate> now = this.this$0.options.getDateProvider().now();
                long l = now.nanoTimestamp();
                double d = l;
                now = d / 1000000.0;
                envelopeWithClientReport.getHeader().setSentAt(AnimationSpecKt.getDateTime((long)((Double)now).longValue()));
                TransportResult result = this.this$0.connection.send$7c6b7086(envelopeWithClientReport);
                if (!result.isSuccess()) {
                    void var3_6;
                    String message = "The transport failed to send the envelope with response code " + result.getResponseCode();
                    this.this$0.options.getLogger().log(SentryLevel.ERROR, message, new Object[0]);
                    if (result.getResponseCode() >= 400 && result.getResponseCode() != 429) {
                        HintUtils.runIfDoesNotHaveType(this.hint, Retryable.class, hint -> {
                            void var1_1;
                            this.this$0.options.getClientReportRecorder().recordLostEnvelope$280c6a9c(DiscardReason.NETWORK_ERROR, (CloseKt)var1_1);
                        });
                    }
                    throw new IllegalStateException((String)var3_6);
                }
                this.envelopeCache.discard$6b7e726e(this.envelope$7be15cc7);
            }
            catch (IOException e) {
                void var1_2;
                void var2_3;
                HintUtils.runIfHasType(this.hint, Retryable.class, retryable -> {}, (arg_0, arg_1) -> this.lambda$flush$4$da21b3((CloseKt)var2_3, arg_0, arg_1));
                throw new IllegalStateException("Sending the event failed.", (Throwable)var1_2);
            }
            return transportResult;
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$flush$4$da21b3(CloseKt envelopeWithClientReport, Object hint, Class clazz) {
            void var1_1;
            void var2_2;
            AnimationSpecKt.logNotInstanceOf((Class)clazz, (Object)var2_2, (ILogger)this.this$0.options.getLogger());
            this.this$0.options.getClientReportRecorder().recordLostEnvelope$280c6a9c(DiscardReason.NETWORK_ERROR, (CloseKt)var1_1);
        }
    }

    static final class AsyncConnectionThreadFactory
    implements ThreadFactory {
        private int cnt;

        private AsyncConnectionThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(Runnable r) {
            void var1_1;
            Thread ret = new Thread(r, "SentryAsyncConnection-" + this.cnt++);
            ret.setDaemon(true);
            return var1_1;
        }

        /* synthetic */ AsyncConnectionThreadFactory(byte by) {
            this();
        }
    }
}

