/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.transport.ReusableCountLatch;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class QueuedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final int maxQueueSize;
    private final ILogger logger;
    private final ReusableCountLatch unfinishedTasksCount = new ReusableCountLatch();

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPoolExecutor(int corePoolSize, int maxQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler, ILogger logger) {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)var3_3, rejectedExecutionHandler);
        void var2_2;
        void var3_3;
        this.maxQueueSize = var2_2;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable task) {
        QueuedThreadPoolExecutor queuedThreadPoolExecutor = this;
        if (queuedThreadPoolExecutor.unfinishedTasksCount.getCount() < queuedThreadPoolExecutor.maxQueueSize) {
            void var1_1;
            this.unfinishedTasksCount.increment();
            return super.submit((Runnable)var1_1);
        }
        this.logger.log(SentryLevel.WARNING, "Submit cancelled", new Object[0]);
        return new CancelledFuture();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void afterExecute(Runnable r, Throwable t) {
        try {
            void var2_3;
            void var1_1;
            super.afterExecute((Runnable)var1_1, (Throwable)var2_3);
            return;
        }
        finally {
            this.unfinishedTasksCount.decrement();
        }
    }

    /*
     * WARNING - void declaration
     */
    final void waitTillIdle(long timeoutMillis) {
        try {
            this.unfinishedTasksCount.waitTillZero(timeoutMillis, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException e) {
            void var1_2;
            this.logger.log(SentryLevel.ERROR, "Failed to wait till idle", (Throwable)var1_2);
            Thread.currentThread().interrupt();
            return;
        }
    }

    static final class CancelledFuture<T>
    implements Future<T> {
        CancelledFuture() {
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public final boolean isCancelled() {
            return true;
        }

        @Override
        public final boolean isDone() {
            return true;
        }

        @Override
        public final T get() {
            throw new CancellationException();
        }

        @Override
        public final T get(long timeout, TimeUnit unit) {
            throw new CancellationException();
        }
    }
}

