/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import androidx.compose.material.icons.outlined.CloseKt;
import io.sentry.DataCategory;
import io.sentry.Hint;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RateLimiter {
    private final ICurrentDateProvider currentDateProvider;
    private final SentryOptions options;
    private final Map<DataCategory, Date> sentryRetryAfterLimit = new ConcurrentHashMap<DataCategory, Date>();

    /*
     * WARNING - void declaration
     */
    private RateLimiter(ICurrentDateProvider currentDateProvider, SentryOptions options) {
        void var2_2;
        void var1_1;
        this.currentDateProvider = var1_1;
        this.options = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public RateLimiter(SentryOptions options) {
        this(CurrentDateProvider.getInstance(), (SentryOptions)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final CloseKt filter$198c1f40(CloseKt envelope, Hint hint) {
        void var1_1;
        Object object;
        ArrayList<SentryEnvelopeItem> dropItems = null;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            DataCategory dataCategory;
            Object object2 = item.getHeader().getType().getItemType();
            object = this;
            int n = -1;
            switch (object2.hashCode()) {
                case 96891546: {
                    if (!object2.equals("event")) break;
                    n = 0;
                    break;
                }
                case 1984987798: {
                    if (!object2.equals("session")) break;
                    n = 1;
                    break;
                }
                case -1963501277: {
                    if (!object2.equals("attachment")) break;
                    n = 2;
                    break;
                }
                case 2141246174: {
                    if (!object2.equals("transaction")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    dataCategory = DataCategory.Error;
                    break;
                }
                case 1: {
                    dataCategory = DataCategory.Session;
                    break;
                }
                case 2: {
                    dataCategory = DataCategory.Attachment;
                    break;
                }
                case 3: {
                    dataCategory = DataCategory.Transaction;
                    break;
                }
                default: {
                    dataCategory = DataCategory.Unknown;
                }
            }
            object2 = dataCategory;
            Date date = new Date(((RateLimiter)object).currentDateProvider.getCurrentTimeMillis());
            Date date2 = ((RateLimiter)object).sentryRetryAfterLimit.get((Object)DataCategory.All);
            boolean bl = date2 != null && !date.after(date2) ? true : (!DataCategory.Unknown.equals(object2) && (object = ((RateLimiter)object).sentryRetryAfterLimit.get(object2)) != null ? !date.after((Date)object) : false);
            if (!bl) continue;
            if (dropItems == null) {
                dropItems = new ArrayList<SentryEnvelopeItem>();
            }
            dropItems.add(item);
            this.options.getClientReportRecorder().recordLostEnvelopeItem(DiscardReason.RATELIMIT_BACKOFF, item);
        }
        if (dropItems != null) {
            this.options.getLogger().log(SentryLevel.INFO, "%d items will be dropped due rate limiting.", dropItems.size());
            ArrayList<SentryEnvelopeItem> toSend = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                if (dropItems.contains(item)) continue;
                toSend.add(item);
            }
            if (toSend.isEmpty()) {
                void var2_2;
                this.options.getLogger().log(SentryLevel.INFO, "Envelope discarded due all items rate limited.", new Object[0]);
                boolean bl = false;
                object = var2_2;
                HintUtils.runIfHasType((Hint)object, SubmissionResult.class, result -> {});
                HintUtils.runIfHasType((Hint)object, Retryable.class, arg_0 -> RateLimiter.lambda$markHintWhenSendingFailed$1(false, arg_0));
                return null;
            }
            return new CloseKt(envelope.getHeader(), toSend);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRetryAfterLimits(String sentryRateLimitHeader, String retryAfterHeader2, int errorCode2) {
        void var3_4;
        String[] stringArray;
        if (sentryRateLimitHeader != null) {
            for (String retryAfterHeader2 : sentryRateLimitHeader.split(",", -1)) {
                void var3_5;
                String[] retryAfterAndCategories = (retryAfterHeader2 = retryAfterHeader2.replace(" ", "")).split(":", -1);
                if (retryAfterAndCategories.length <= 0) continue;
                String errorCode2 = retryAfterAndCategories[0];
                long retryAfterMillis = RateLimiter.parseRetryAfterOrDefault(errorCode2);
                if (retryAfterAndCategories.length <= 1) continue;
                String allCategories = retryAfterAndCategories[1];
                Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
                if (allCategories != null && !allCategories.isEmpty()) {
                    String[] stringArray2 = stringArray.split(";", -1);
                    stringArray = stringArray2;
                    stringArray = stringArray2;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String catItem = stringArray[i];
                        DataCategory dataCategory = DataCategory.Unknown;
                        try {
                            String catItemCapitalized = StringUtils.capitalize(catItem);
                            if (catItemCapitalized != null) {
                                dataCategory = DataCategory.valueOf(catItemCapitalized);
                            } else {
                                this.options.getLogger().log(SentryLevel.ERROR, "Couldn't capitalize: %s", catItem);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.options.getLogger().log(SentryLevel.INFO, e, "Unknown category: %s", catItem);
                        }
                        if (DataCategory.Unknown.equals((Object)dataCategory)) continue;
                        this.applyRetryAfterOnlyIfLonger(dataCategory, date);
                    }
                    continue;
                }
                this.applyRetryAfterOnlyIfLonger(DataCategory.All, (Date)var3_5);
            }
            return;
        }
        if (var3_4 == 429) {
            void var1_1;
            long retryAfterMillis = RateLimiter.parseRetryAfterOrDefault((String)stringArray);
            Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
            this.applyRetryAfterOnlyIfLonger(DataCategory.All, (Date)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyRetryAfterOnlyIfLonger(DataCategory dataCategory, Date date) {
        void var3_3;
        Date oldDate = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (oldDate == null || date.after((Date)var3_3)) {
            void var2_2;
            void var1_1;
            this.sentryRetryAfterLimit.put((DataCategory)var1_1, (Date)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static long parseRetryAfterOrDefault(String retryAfterHeader) {
        void var1_1;
        long retryAfterMillis = 60000L;
        if (retryAfterHeader != null) {
            try {
                String string;
                retryAfterMillis = (long)(Double.parseDouble(string) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return (long)var1_1;
    }

    private static /* synthetic */ void lambda$markHintWhenSendingFailed$1(boolean retry, Retryable retryable) {
    }
}

