/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public final class StringUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String capitalize(String str) {
        String string;
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1).toLowerCase(Locale.ROOT);
    }

    /*
     * WARNING - void declaration
     */
    public static String calculateStringHash(String str, ILogger logger) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest2 = messageDigest.digest(str.getBytes(UTF_8));
            Comparable<BigInteger> no = new BigInteger(1, messageDigest2);
            no = new StringBuilder(no.toString(16));
            return ((StringBuilder)no).toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(SentryLevel.INFO, "SHA-1 isn't available to calculate the hash.", e);
        }
        catch (Throwable e) {
            String string;
            void var2_4;
            void var1_1;
            var1_1.log(SentryLevel.INFO, "string: %s could not calculate its hash", var2_4, string);
        }
        return null;
    }

    public static String normalizeUUID(String uuidString) {
        String string;
        if (uuidString.equals("0000-0000")) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return string;
    }
}

