/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.vendor.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class ISO8601Utils {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    public static String format(Date date, boolean millis) {
        TimeZone timeZone = TIMEZONE_UTC;
        int n = 1;
        Date date2 = date;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setTime(date2);
        int n2 = 19;
        n2 = 19 + (n != 0 ? 4 : 0);
        StringBuilder stringBuilder = new StringBuilder(n2 += timeZone.getRawOffset() == 0 ? 1 : 6);
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(1), 4);
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(2) + 1, 2);
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(5), 2);
        stringBuilder.append('T');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(11), 2);
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(12), 2);
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(13), 2);
        if (n != 0) {
            stringBuilder.append('.');
            ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(14), 3);
        }
        if ((n = timeZone.getOffset(gregorianCalendar.getTimeInMillis())) != 0) {
            int n3 = Math.abs(n / 60000 / 60);
            int n4 = Math.abs(n / 60000 % 60);
            stringBuilder.append(n < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(stringBuilder, n3, 2);
            stringBuilder.append(':');
            ISO8601Utils.padInt(stringBuilder, n4, 2);
        } else {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Date parse(String date, ParsePosition pos) throws ParseException {
        void var2_9;
        void var1_1;
        void var3_3;
        String string;
        RuntimeException fail;
        RuntimeException offset2;
        try {
            void timezone2;
            TimeZone timezone2;
            void calendar2;
            int offset2 = pos.getIndex();
            int year = ISO8601Utils.parseInt(date, offset2, offset2 += 4);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int month = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            if (ISO8601Utils.checkOffset(date, offset2, '-')) {
                // empty if block
            }
            int day = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = ISO8601Utils.checkOffset(date, offset2, 'T');
            if (!hasT && date.length() <= offset2) {
                GregorianCalendar calendar2 = new GregorianCalendar(year, month - 1, day);
                pos.setIndex(offset2);
                return calendar2.getTime();
            }
            if (calendar2 != false) {
                char c;
                hour = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    // empty if block
                }
                minutes = ISO8601Utils.parseInt(date, ++offset2, offset2 += 2);
                if (ISO8601Utils.checkOffset(date, offset2, ':')) {
                    ++offset2;
                }
                if (date.length() > offset2 && (c = date.charAt(offset2)) != 'Z' && c != '+' && c != '-') {
                    if ((seconds = ISO8601Utils.parseInt(date, offset2, offset2 += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (ISO8601Utils.checkOffset(date, offset2, '.')) {
                        int endOffset = ISO8601Utils.indexOfNonDigit(date, ++offset2 + 1);
                        int parseEndOffset = Math.min(endOffset, offset2 + 3);
                        int fraction = ISO8601Utils.parseInt(date, offset2, parseEndOffset);
                        switch (parseEndOffset - offset2) {
                            case 2: {
                                milliseconds = fraction * 10;
                                break;
                            }
                            case 1: {
                                milliseconds = fraction * 100;
                                break;
                            }
                            default: {
                                milliseconds = fraction;
                            }
                        }
                        offset2 = endOffset;
                    }
                }
            }
            if (date.length() <= offset2) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            char timezoneIndicator = date.charAt(offset2);
            if (timezoneIndicator == 'Z') {
                timezone2 = TIMEZONE_UTC;
                ++offset2;
            } else if (timezone2 == 43 || timezone2 == 45) {
                String timezoneOffset = date.substring(offset2);
                timezoneOffset = timezoneOffset.length() >= 5 ? timezoneOffset : timezoneOffset + "00";
                offset2 += timezoneOffset.length();
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone2 = TIMEZONE_UTC;
                } else {
                    String timezoneId = "GMT" + timezoneOffset;
                    timezone2 = TimeZone.getTimeZone(timezoneId);
                    String act = timezone2.getID();
                    if (!act.equals(timezoneId) && !(act = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone2.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + (char)timezone2 + "'");
            }
            GregorianCalendar calendar3 = new GregorianCalendar(timezone2);
            calendar3.setLenient(false);
            calendar3.set(1, year);
            calendar3.set(2, month - 1);
            calendar3.set(5, day);
            calendar3.set(11, hour);
            calendar3.set(12, minutes);
            calendar3.set(13, seconds);
            calendar3.set(14, milliseconds);
            pos.setIndex(offset2);
            return calendar3.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            offset2 = indexOutOfBoundsException;
            fail = indexOutOfBoundsException;
        }
        catch (NumberFormatException numberFormatException) {
            offset2 = numberFormatException;
            fail = numberFormatException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            offset2 = illegalArgumentException;
            fail = illegalArgumentException;
        }
        String input = date == null ? null : "\"" + string + '\"';
        String msg = fail.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = "(" + fail.getClass().getName() + ")";
        }
        ParseException ex = new ParseException("Failed to parse date [" + (String)var3_3 + "]: " + msg, var1_1.getIndex());
        ex.initCause((Throwable)var2_9);
        throw ex;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkOffset(String value, int offset, char expected) {
        void var2_2;
        void var1_1;
        String string;
        return offset < value.length() && string.charAt((int)var1_1) == var2_2;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i = beginIndex;
        int result = 0;
        if (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result = -digit;
        }
        while (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    /*
     * WARNING - void declaration
     */
    private static void padInt(StringBuilder buffer, int value, int length) {
        void var1_2;
        StringBuilder stringBuilder;
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        stringBuilder.append((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfNonDigit(String string, int offset) {
        String string2;
        for (int i = offset; i < string.length(); ++i) {
            void var2_2;
            char c = string.charAt(i);
            if (c >= '0' && var2_2 <= 57) continue;
            return i;
        }
        return string2.length();
    }
}

