/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.vendor.gson.stream;

import io.sentry.vendor.gson.stream.JsonToken;
import io.sentry.vendor.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class JsonReader
implements Closeable {
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    /*
     * WARNING - void declaration
     */
    public JsonReader(Reader in) {
        void var1_1;
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        this.in = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void beginArray() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (var1_1 == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final void endArray() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (var1_1 == 4) {
            --this.stackSize;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final void beginObject() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (var1_1 == true) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final void endObject() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (var1_1 == 2) {
            --this.stackSize;
            this.pathNames[this.stackSize] = null;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final JsonToken peek() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        switch (var1_1) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    private int doPeek() throws IOException {
        int n;
        int peekStack2;
        block41: {
            block43: {
                block42: {
                    block40: {
                        peekStack2 = this.stack[this.stackSize - 1];
                        if (peekStack2 != 1) break block40;
                        this.stack[this.stackSize - 1] = 2;
                        break block41;
                    }
                    if (peekStack2 != 2) break block42;
                    n = this.nextNonWhitespace(true);
                    switch (n) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            JsonReader peekStack2 = this;
                            throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                        }
                        case 44: {
                            break block41;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                }
                if (peekStack2 == 3 || peekStack2 == 5) {
                    int n2;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack2 == 5) {
                        n2 = this.nextNonWhitespace(true);
                        switch (n2) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                JsonReader peekStack2 = this;
                                throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    n2 = this.nextNonWhitespace(true);
                    switch (n2) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            JsonReader peekStack2 = this;
                            throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                        }
                        case 125: {
                            if (peekStack2 != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    JsonReader peekStack2 = this;
                    throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                }
                if (peekStack2 != 4) break block43;
                this.stack[this.stackSize - 1] = 5;
                n = this.nextNonWhitespace(true);
                switch (n) {
                    case 58: {
                        break block41;
                    }
                    case 61: {
                        JsonReader peekStack2 = this;
                        throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
            }
            if (peekStack2 == 6) {
                this.stack[this.stackSize - 1] = 7;
            } else {
                if (peekStack2 == 7) {
                    int n3 = this.nextNonWhitespace(false);
                    if (n3 == -1) {
                        this.peeked = 17;
                        return 17;
                    }
                    JsonReader peekStack2 = this;
                    throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                }
                if (peekStack2 == 8) {
                    throw new IllegalStateException("JsonReader is closed");
                }
            }
        }
        n = this.nextNonWhitespace(true);
        switch (n) {
            case 93: {
                if (peekStack2 == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (peekStack2 == 1 || peekStack2 == 2) {
                    JsonReader peekStack2 = this;
                    throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                JsonReader peekStack2 = this;
                throw peekStack2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
            }
            case 34: {
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.pos;
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            void var1_1;
            return (int)var1_1;
        }
        JsonReader jsonReader = this;
        if (!jsonReader.isLiteral(jsonReader.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        JsonReader jsonReader2 = this;
        throw jsonReader2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
    }

    /*
     * WARNING - void declaration
     */
    private int peekKeyword() throws IOException {
        int peeking;
        String keywordUpper;
        String keyword;
        char c = this.buffer[this.pos];
        if (c == 't' || c == 'T') {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (c == 'f' || c == 'F') {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (c == 'n' || c == 'N') {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            void var1_1;
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            c = this.buffer[this.pos + i];
            if (c == keyword.charAt(i) || var1_1 == keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.pos + length < this.limit || this.fillBuffer(length + 1)) {
            JsonReader jsonReader = this;
            if (jsonReader.isLiteral(jsonReader.buffer[this.pos + length])) {
                return 0;
            }
        }
        this.pos += length;
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        char[] buffer = this.buffer;
        int p = this.pos;
        int l = this.limit;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block6: while (true) {
            if (p + i == l) {
                if (i == buffer.length) {
                    return 0;
                }
                if (!this.fillBuffer(i + 1)) break;
                p = this.pos;
                l = this.limit;
            }
            char c = buffer[p + i];
            switch (c) {
                case '-': {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < '0' || c > '9') {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value = -(c - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value == 0L) {
                            return 0;
                        }
                        long newValue = value * 10L - (long)(c - 48);
                        fitsInLong &= value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                        value = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i;
        }
        if (!(last != 2 || !fitsInLong || value == Long.MIN_VALUE && !negative || value == 0L && negative)) {
            this.peekedLong = negative ? value : -value;
            this.pos += i;
            this.peeked = 15;
            return 15;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(char c) throws IOException {
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                JsonReader jsonReader = this;
                throw jsonReader.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String nextName() throws IOException {
        void var1_2;
        void result2;
        String result2;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 14) {
            result2 = this.nextUnquotedValue();
        } else if (result2 == 12) {
            result2 = this.nextQuotedValue('\'');
        } else if (result2 == 13) {
            result2 = this.nextQuotedValue('\"');
        } else {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result2;
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public String nextString() throws IOException {
        void var1_2;
        void result2;
        String result2;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 10) {
            result2 = this.nextUnquotedValue();
        } else if (result2 == 8) {
            result2 = this.nextQuotedValue('\'');
        } else if (result2 == 9) {
            result2 = this.nextQuotedValue('\"');
        } else if (result2 == 11) {
            result2 = this.peekedString;
            this.peekedString = null;
        } else if (result2 == 15) {
            result2 = Long.toString(this.peekedLong);
        } else if (result2 == 16) {
            result2 = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean nextBoolean() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 5) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return true;
        }
        if (var1_1 == 6) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return false;
        }
        throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final void nextNull() throws IOException {
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (var1_1 == 7) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return;
        }
        throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    /*
     * WARNING - void declaration
     */
    public final double nextDouble() throws IOException {
        void var2_2;
        void var1_1;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (var1_1 != 11) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double result = Double.parseDouble(this.peekedString);
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + result + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final long nextLong() throws IOException {
        void var2_3;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p == 8 || p == 9 || p == 10) {
            void var1_1;
            this.peekedString = p == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(var1_1 == 8 ? (char)'\'' : '\"');
            try {
                long result = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        long result = (long)asDouble;
        if ((double)result != var2_3) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private String nextQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        StringBuilder builder = null;
        do {
            int n;
            StringBuilder stringBuilder;
            int p = this.pos;
            int l = this.limit;
            int start = p;
            while (p < l) {
                int len;
                char c;
                if ((c = buffer[p++]) == quote) {
                    this.pos = p;
                    len = p - start - 1;
                    if (builder == null) {
                        return new String(buffer, start, len);
                    }
                    builder.append(buffer, start, len);
                    return builder.toString();
                }
                if (c == '\\') {
                    this.pos = len;
                    len = len - start - true;
                    if (builder == null) {
                        void var3_4;
                        int estimatedLength = len + 1 << 1;
                        stringBuilder = new StringBuilder(Math.max((int)var3_4, 16));
                    }
                    stringBuilder.append(buffer, start, len);
                    stringBuilder.append(this.readEscapeCharacter());
                    n = this.pos;
                    l = this.limit;
                    start = n;
                    continue;
                }
                if (c != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n;
            }
            if (stringBuilder == null) {
                void estimatedLength = n - start << 1;
                stringBuilder = new StringBuilder(Math.max((int)estimatedLength, 16));
            }
            stringBuilder.append(buffer, start, (int)(n - start));
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    /*
     * WARNING - void declaration
     */
    private String nextUnquotedValue() throws IOException {
        void var1_1;
        void var2_2;
        Object builder = null;
        int i = 0;
        block4: while (true) {
            if (this.pos + i < this.limit) {
                switch (this.buffer[this.pos + i]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        builder = this;
                        throw ((JsonReader)builder).syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
                continue;
            }
            if (i < this.buffer.length) {
                if (!this.fillBuffer(i + 1)) break;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder(Math.max(i, 16));
            }
            ((StringBuilder)builder).append(this.buffer, this.pos, i);
            this.pos += i;
            i = 0;
            if (!this.fillBuffer(1)) break;
        }
        String result = builder == null ? new String(this.buffer, this.pos, i) : ((StringBuilder)builder).append(this.buffer, this.pos, i).toString();
        this.pos += var2_2;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void skipQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        do {
            void var3_3;
            int p = this.pos;
            int l = this.limit;
            while (p < l) {
                char c;
                if ((c = buffer[p++]) == quote) {
                    this.pos = p;
                    return;
                }
                if (c == '\\') {
                    this.pos = p;
                    this.readEscapeCharacter();
                    p = this.pos;
                    l = this.limit;
                    continue;
                }
                if (c != '\n') continue;
                ++this.lineNumber;
                this.lineStart = p;
            }
            this.pos = var3_3;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    /*
     * WARNING - void declaration
     */
    public final int nextInt() throws IOException {
        void var1_1;
        void var3_2;
        int result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return result;
        }
        if (result == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (result == 8 || result == 9 || result == 10) {
            this.peekedString = result == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(result == 8 ? (char)'\'' : '\"');
            try {
                result = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        result = (int)asDouble;
        if ((double)result != var3_2) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return (int)var1_1;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipValue() throws IOException {
        int count2 = 0;
        do {
            block23: {
                void var2_3;
                int p2;
                if ((p2 = this.peeked) == 0) {
                    p2 = this.doPeek();
                }
                if (p2 == 3) {
                    this.push(1);
                    ++count2;
                } else if (p2 == 1) {
                    this.push(3);
                    ++count2;
                } else if (p2 == 4) {
                    --this.stackSize;
                    --count2;
                } else if (p2 == 2) {
                    --this.stackSize;
                    --count2;
                } else if (p2 == 14 || p2 == 10) {
                    JsonReader p2 = this;
                    do {
                        int n = 0;
                        while (p2.pos + n < p2.limit) {
                            switch (p2.buffer[p2.pos + n]) {
                                case '#': 
                                case '/': 
                                case ';': 
                                case '=': 
                                case '\\': {
                                    JsonReader count2 = p2;
                                    throw count2.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': 
                                case ',': 
                                case ':': 
                                case '[': 
                                case ']': 
                                case '{': 
                                case '}': {
                                    p2.pos += n;
                                    break block23;
                                }
                                default: {
                                    ++n;
                                    break;
                                }
                            }
                        }
                        p2.pos += n;
                    } while (p2.fillBuffer(1));
                } else if (p2 == 8 || p2 == 12) {
                    this.skipQuotedValue('\'');
                } else if (p2 == 9 || p2 == 13) {
                    this.skipQuotedValue('\"');
                } else if (var2_3 == 16) {
                    this.pos += this.peekedNumberLength;
                }
            }
            this.peeked = 0;
        } while (count2 != 0);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    /*
     * WARNING - void declaration
     */
    private void push(int newTop) {
        void var1_1;
        if (this.stackSize == this.stack.length) {
            void var2_2;
            int newLength = this.stackSize << 1;
            this.stack = Arrays.copyOf(this.stack, newLength);
            this.pathIndices = Arrays.copyOf(this.pathIndices, newLength);
            this.pathNames = Arrays.copyOf(this.pathNames, (int)var2_2);
        }
        this.stack[this.stackSize++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean fillBuffer(int minimum) throws IOException {
        int total;
        char[] buffer = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(buffer, this.pos, buffer, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((total = this.in.read(buffer, this.limit, buffer.length - this.limit)) != -1) {
            void var3_3;
            this.limit += var3_3;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && buffer[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++minimum;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int nextNonWhitespace(boolean throwOnEof) throws IOException {
        void var1_1;
        block8: {
            void var3_5;
            char c;
            char[] buffer = this.buffer;
            int p = this.pos;
            int l = this.limit;
            while (true) {
                if (p == l) {
                    this.pos = p;
                    if (!this.fillBuffer(1)) break block8;
                    p = this.pos;
                    l = this.limit;
                }
                if ((c = buffer[p++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = p;
                    continue;
                }
                if (c != ' ' && c != '\r' && c != '\t') break;
            }
            if (c == '/') {
                this.pos = p;
                if (p == l) {
                    --this.pos;
                    boolean charsLoaded = this.fillBuffer(2);
                    ++this.pos;
                    if (var1_1 == false) {
                        return c;
                    }
                }
                JsonReader jsonReader = this;
                throw jsonReader.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
            }
            if (c == '#') {
                this.pos = p;
                JsonReader jsonReader = this;
                throw jsonReader.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
            }
            this.pos = var3_5;
            return c;
        }
        if (var1_1 != false) {
            throw new EOFException("End of input" + this.locationString());
        }
        return -1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    /*
     * WARNING - void declaration
     */
    private String locationString() {
        void var2_2;
        void var1_1;
        int line = this.lineNumber + 1;
        int column = this.pos - this.lineStart + 1;
        return " at line " + (int)var1_1 + " column " + (int)var2_2 + " path " + this.getPath();
    }

    /*
     * WARNING - void declaration
     */
    private String getPath() {
        void var1_1;
        StringBuilder result = new StringBuilder("$");
        int size = this.stackSize;
        block4: for (int i = 0; i < size; ++i) {
            switch (this.stack[i]) {
                case 1: 
                case 2: {
                    result.append('[').append(this.pathIndices[i]).append(']');
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    result.append('.');
                    if (this.pathNames[i] == null) continue block4;
                    result.append(this.pathNames[i]);
                }
            }
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char escaped = this.buffer[this.pos++];
        switch (escaped) {
            case 'u': {
                void var1_1;
                int i;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                int result = 0;
                int end = i + 4;
                for (i = this.pos; i < end; ++i) {
                    char c = this.buffer[i];
                    result = (char)(result << 4);
                    if (c >= '0' && c <= '9') {
                        result = (char)(result + (c - 48));
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        result = (char)(result + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        result = (char)(result + (c - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return (char)var1_1;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                void var1_1;
                return (char)var1_1;
            }
        }
        throw this.syntaxError("Invalid escape sequence");
    }

    /*
     * WARNING - void declaration
     */
    private IOException syntaxError(String message) throws IOException {
        void var1_1;
        throw new MalformedJsonException((String)var1_1 + this.locationString());
    }
}

