/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.DesktopWindow;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());
    private static final String TRANSPARENT_OLD_BG = "transparent-old-bg";
    private static final String TRANSPARENT_OLD_OPAQUE = "transparent-old-opaque";
    private static final String TRANSPARENT_ALPHA = "transparent-alpha";
    public static final Shape MASK_NONE = null;

    private static NativeWindowUtils getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static void setWindowMask(Window w, Shape mask) {
        void var1_1;
        Window window;
        WindowUtils.getInstance().setWindowMask((Component)window, (Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setComponentMask(Component c, Shape mask) {
        void var1_1;
        Component component;
        WindowUtils.getInstance().setWindowMask(component, (Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setWindowMask(Window w, Icon mask) {
        void var1_1;
        Window window;
        WindowUtils.getInstance().setWindowMask((Component)window, (Icon)var1_1);
    }

    public static boolean isWindowAlphaSupported() {
        return WindowUtils.getInstance().isWindowAlphaSupported();
    }

    public static GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        return WindowUtils.getInstance().getAlphaCompatibleGraphicsConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    public static void setWindowAlpha(Window w, float alpha) {
        void var1_1;
        Window window;
        WindowUtils.getInstance().setWindowAlpha(window, Math.max(0.0f, Math.min((float)var1_1, 1.0f)));
    }

    /*
     * WARNING - void declaration
     */
    public static void setWindowTransparent(Window w, boolean transparent) {
        void var1_1;
        Window window;
        WindowUtils.getInstance().setWindowTransparent(window, (boolean)var1_1);
    }

    public static BufferedImage getWindowIcon(WinDef.HWND hwnd) {
        WinDef.HWND hWND;
        return WindowUtils.getInstance().getWindowIcon(hWND);
    }

    public static Dimension getIconSize(WinDef.HICON hIcon) {
        WinDef.HICON hICON;
        return WindowUtils.getInstance().getIconSize(hICON);
    }

    public static List<DesktopWindow> getAllWindows(boolean onlyVisibleWindows) {
        boolean bl;
        return WindowUtils.getInstance().getAllWindows(bl);
    }

    public static String getWindowTitle(WinDef.HWND hwnd) {
        WinDef.HWND hWND;
        return WindowUtils.getInstance().getWindowTitle(hWND);
    }

    public static String getProcessFilePath(WinDef.HWND hwnd) {
        WinDef.HWND hWND;
        return WindowUtils.getInstance().getProcessFilePath(hWND);
    }

    public static Rectangle getWindowLocationAndSize(WinDef.HWND hwnd) {
        WinDef.HWND hWND;
        return WindowUtils.getInstance().getWindowLocationAndSize(hWND);
    }

    private static class X11WindowUtils
    extends NativeWindowUtils {
        private boolean didCheck;
        private long[] alphaVisualIDs = new long[0];
        private static final long OPAQUE = 0xFFFFFFFFL;
        private static final String OPACITY = "_NET_WM_WINDOW_OPACITY";

        private X11WindowUtils() {
        }

        /*
         * WARNING - void declaration
         */
        private static X11.Pixmap createBitmap(X11.Display dpy, X11.Window win, Raster raster) {
            void var1_1;
            X11 x11 = X11.INSTANCE;
            Rectangle bounds = raster.getBounds();
            int width = bounds.x + bounds.width;
            int height = bounds.y + bounds.height;
            X11.Pixmap pm22 = x11.XCreatePixmap(dpy, win, width, height, 1);
            X11.GC gc = x11.XCreateGC(dpy, pm22, new NativeLong(0L), null);
            if (gc == null) {
                return null;
            }
            x11.XSetForeground(dpy, gc, new NativeLong(0L));
            x11.XFillRectangle(dpy, pm22, gc, 0, 0, width, height);
            final ArrayList rlist = new ArrayList();
            try {
                void var2_3;
                RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final boolean outputRange(int x, int y, int w, int h) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        rlist.add(new Rectangle((int)var1_1, (int)var2_2, (int)var3_3, h));
                        return true;
                    }
                });
                X11.XRectangle[] rects = (X11.XRectangle[])new X11.XRectangle().toArray(rlist.size());
                for (int i = 0; i < rects.length; ++i) {
                    Rectangle r = (Rectangle)rlist.get(i);
                    rects[i].x = (short)r.x;
                    rects[i].y = (short)r.y;
                    rects[i].width = (short)r.width;
                    rects[i].height = (short)r.height;
                    Pointer p = rects[i].getPointer();
                    p.setShort(0L, (short)r.x);
                    p.setShort(2L, (short)r.y);
                    p.setShort(4L, (short)r.width);
                    p.setShort(6L, (short)r.height);
                    rects[i].setAutoSynch(false);
                }
                x11.XSetForeground(dpy, gc, new NativeLong(1L));
                void v0 = var2_3;
                x11.XFillRectangles(dpy, pm22, gc, (X11.XRectangle[])v0, ((void)v0).length);
                x11.XFreeGC(dpy, gc);
            }
            catch (Throwable pm22) {
                X11.Display display;
                void var3_4;
                var3_4.XFreeGC(display, gc);
                throw pm22;
            }
            return var1_1;
        }

        @Override
        public boolean isWindowAlphaSupported() {
            return this.getAlphaVisualIDs().length > 0;
        }

        private static long getVisualID(GraphicsConfiguration config) {
            Object object;
            try {
                object = config.getClass().getMethod("getVisual", null).invoke(object, (Object[])null);
                return ((Number)object).longValue();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
                return -1L;
            }
        }

        @Override
        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            if (this.isWindowAlphaSupported()) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
                for (int i = 0; i < devices.length; ++i) {
                    GraphicsConfiguration[] configs = devices[i].getConfigurations();
                    for (int j = 0; j < configs.length; ++j) {
                        long visualID = X11WindowUtils.getVisualID(configs[j]);
                        long[] ids = this.getAlphaVisualIDs();
                        for (int k = 0; k < ids.length; ++k) {
                            if (visualID != ids[k]) continue;
                            return configs[j];
                        }
                    }
                }
            }
            return super.getAlphaCompatibleGraphicsConfiguration();
        }

        /*
         * WARNING - void declaration
         */
        private synchronized long[] getAlphaVisualIDs() {
            X11.XVisualInfo info;
            X11.Display dpy;
            X11 x11;
            block8: {
                long[] lArray;
                block9: {
                    if (this.didCheck) {
                        return this.alphaVisualIDs;
                    }
                    this.didCheck = true;
                    x11 = X11.INSTANCE;
                    dpy = x11.XOpenDisplay(null);
                    if (dpy == null) {
                        return this.alphaVisualIDs;
                    }
                    info = null;
                    try {
                        int i;
                        int screen = x11.XDefaultScreen(dpy);
                        X11.XVisualInfo template = new X11.XVisualInfo();
                        new X11.XVisualInfo().screen = screen;
                        template.depth = 32;
                        template.c_class = 4;
                        NativeLong mask = new NativeLong(14L);
                        IntByReference pcount = new IntByReference();
                        info = x11.XGetVisualInfo(dpy, mask, template, pcount);
                        if (info == null) break block8;
                        ArrayList<X11.VisualID> list = new ArrayList<X11.VisualID>();
                        X11.XVisualInfo[] infos = (X11.XVisualInfo[])info.toArray(pcount.getValue());
                        for (i = 0; i < infos.length; ++i) {
                            X11.Xrender.XRenderPictFormat format = X11.Xrender.INSTANCE.XRenderFindVisualFormat(dpy, infos[i].visual);
                            if (format.type != 1 || format.direct.alphaMask == 0) continue;
                            list.add(infos[i].visualid);
                        }
                        this.alphaVisualIDs = new long[list.size()];
                        for (i = 0; i < this.alphaVisualIDs.length; ++i) {
                            this.alphaVisualIDs[i] = ((Number)list.get(i)).longValue();
                        }
                        lArray = this.alphaVisualIDs;
                        if (info == null) break block9;
                        x11.XFree(info.getPointer());
                    }
                    catch (Throwable throwable) {
                        void var2_2;
                        void var1_1;
                        if (info != null) {
                            void var3_3;
                            x11.XFree(var3_3.getPointer());
                        }
                        var1_1.XCloseDisplay((X11.Display)var2_2);
                        throw throwable;
                    }
                }
                x11.XCloseDisplay(dpy);
                return lArray;
            }
            if (info != null) {
                x11.XFree(info.getPointer());
            }
            x11.XCloseDisplay(dpy);
            return this.alphaVisualIDs;
        }

        /*
         * WARNING - void declaration
         */
        private static X11.Window getContentWindow(Window w, X11.Display dpy, X11.Window win, Point offset) {
            void var2_2;
            if (w instanceof Frame && !((Frame)w).isUndecorated() || w instanceof Dialog && !((Dialog)w).isUndecorated()) {
                X11 x11 = X11.INSTANCE;
                X11.WindowByReference rootp = new X11.WindowByReference();
                Object parentp = new X11.WindowByReference();
                PointerByReference childrenp = new PointerByReference();
                IntByReference countp = new IntByReference();
                x11.XQueryTree(dpy, win, rootp, (X11.WindowByReference)((Object)parentp), childrenp, countp);
                Pointer p = childrenp.getValue();
                int[] nArray = p.getIntArray(0L, countp.getValue());
                parentp = nArray;
                parentp = nArray;
                int n = nArray.length;
                if (n > 0) {
                    void var1_1;
                    X11.WindowByReference id = parentp[0];
                    X11.Window child = new X11.Window((long)id);
                    X11.XWindowAttributes xwa = new X11.XWindowAttributes();
                    x11.XGetWindowAttributes((X11.Display)var1_1, child, xwa);
                    offset.x = -xwa.x;
                    var3_4.y = -xwa.y;
                }
                if (p != null) {
                    X11 x112;
                    x112.XFree(p);
                }
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static X11.Window getDrawable(Component w) {
            void var0_1;
            int id = (int)Native.getComponentID((Component)w);
            if (id == 0) {
                return null;
            }
            return new X11.Window((long)var0_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowAlpha(Window w, float alpha) {
            void var2_3;
            void var1_1;
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
            }
            Runnable action = new Runnable(this, w, alpha){
                final /* synthetic */ Window val$w;
                final /* synthetic */ float val$alpha;
                final /* synthetic */ X11WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$alpha = f;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    X11 x11 = X11.INSTANCE;
                    X11.Display dpy = x11.XOpenDisplay(null);
                    if (dpy == null) {
                        return;
                    }
                    try {
                        X11.Window win = X11WindowUtils.getDrawable(this.val$w);
                        if (this.val$alpha == 1.0f) {
                            x11.XDeleteProperty(dpy, win, x11.XInternAtom(dpy, X11WindowUtils.OPACITY, false));
                        } else {
                            void var3_3;
                            int opacity = (int)(this.val$alpha * 4.2949673E9f);
                            IntByReference patom = new IntByReference(opacity);
                            x11.XChangeProperty(dpy, (X11.Window)var3_3, x11.XInternAtom(dpy, X11WindowUtils.OPACITY, false), X11.XA_CARDINAL, 32, 0, patom.getPointer(), 1);
                        }
                        x11.XCloseDisplay(dpy);
                    }
                    catch (Throwable throwable) {
                        void var2_2;
                        void var1_1;
                        var1_1.XCloseDisplay((X11.Display)var2_2);
                        throw throwable;
                    }
                }
            };
            this.whenDisplayable((Component)var1_1, (Runnable)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowTransparent(Window w, boolean transparent) {
            void var2_2;
            void var1_1;
            void var3_3;
            boolean isTransparent;
            if (!(w instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
            }
            if (!w.getGraphicsConfiguration().equals(this.getAlphaCompatibleGraphicsConfiguration())) {
                throw new IllegalArgumentException("Window GraphicsConfiguration '" + w.getGraphicsConfiguration() + "' does not support transparency");
            }
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (transparent == var3_3) {
                return;
            }
            this.whenDisplayable(w, new Runnable(this, (Window)var1_1, (boolean)var2_2){
                final /* synthetic */ Window val$w;
                final /* synthetic */ boolean val$transparent;
                final /* synthetic */ X11WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$transparent = bl;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    JRootPane root = ((RootPaneContainer)((Object)this.val$w)).getRootPane();
                    JLayeredPane lp = root.getLayeredPane();
                    Container content = root.getContentPane();
                    if (content instanceof X11TransparentContentPane) {
                        ((X11TransparentContentPane)content).setTransparent(this.val$transparent);
                    } else if (this.val$transparent) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        X11TransparentContentPane x11content = this.this$0.new X11TransparentContentPane(content);
                        var1_1.setContentPane(x11content);
                        var2_2.add((Component)new RepaintTrigger((JComponent)var3_3), JLayeredPane.DRAG_LAYER);
                    }
                    this.this$0.setLayersTransparent(this.val$w, this.val$transparent);
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$transparent);
                    this.this$0.setDoubleBuffered(this.val$w, !this.val$transparent);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private void setWindowShape(Window w, PixmapSource src) {
            void var2_2;
            void var1_1;
            Runnable action = new Runnable(this, w, src){
                final /* synthetic */ Window val$w;
                final /* synthetic */ PixmapSource val$src;
                final /* synthetic */ X11WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$src = pixmapSource;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    void var3_3;
                    X11.Display dpy;
                    X11 x11;
                    block4: {
                        x11 = X11.INSTANCE;
                        dpy = x11.XOpenDisplay(null);
                        if (dpy == null) {
                            return;
                        }
                        X11.Pixmap pm = null;
                        try {
                            X11.Window win = X11WindowUtils.getDrawable(this.val$w);
                            pm = this.val$src.getPixmap(dpy, win);
                            X11.Xext xext = X11.Xext.INSTANCE;
                            xext.XShapeCombineMask(dpy, win, 0, 0, 0, pm == null ? X11.Pixmap.None : pm, 0);
                            if (pm == null) break block4;
                            x11.XFreePixmap(dpy, pm);
                        }
                        catch (Throwable throwable) {
                            void var2_2;
                            void var1_1;
                            if (pm != null) {
                                x11.XFreePixmap(dpy, pm);
                            }
                            var1_1.XCloseDisplay((X11.Display)var2_2);
                            throw throwable;
                        }
                    }
                    x11.XCloseDisplay(dpy);
                    this.this$0.setForceHeavyweightPopups(this.this$0.getWindow(this.val$w), var3_3 != null);
                }
            };
            this.whenDisplayable((Component)var1_1, (Runnable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void setMask(Component w, Raster raster) {
            void var2_2;
            void var1_1;
            X11WindowUtils x11WindowUtils = this;
            x11WindowUtils.setWindowShape(x11WindowUtils.getWindow((Component)var1_1), new PixmapSource(this, (Raster)var2_2){
                final /* synthetic */ Raster val$raster;
                final /* synthetic */ X11WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$raster = raster;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public X11.Pixmap getPixmap(X11.Display dpy, X11.Window win) {
                    if (this.val$raster != null) {
                        void var2_2;
                        void var1_1;
                        return X11WindowUtils.access$1100((X11.Display)var1_1, (X11.Window)var2_2, this.val$raster);
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ X11.Window access$1000(Window x0, X11.Display x1, X11.Window x2, Point x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            return X11WindowUtils.getContentWindow(x0, (X11.Display)var1_1, (X11.Window)var2_2, (Point)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ X11.Pixmap access$1100(X11.Display x0, X11.Window x1, Raster x2) {
            void var2_2;
            void var1_1;
            return X11WindowUtils.createBitmap(x0, (X11.Window)var1_1, (Raster)var2_2);
        }

        private static interface PixmapSource {
            public X11.Pixmap getPixmap(X11.Display var1, X11.Window var2);
        }

        private class X11TransparentContentPane
        extends NativeWindowUtils.TransparentContentPane {
            private static final long serialVersionUID = 1L;
            private Memory buffer;
            private int[] pixels;
            private final int[] pixel;

            /*
             * WARNING - void declaration
             */
            public X11TransparentContentPane(Container oldContent) {
                void var2_2;
                super(X11WindowUtils.this, (Container)var2_2);
                this.pixel = new int[4];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void paintDirect(BufferedImage buf, Rectangle bounds) {
                void var3_3;
                void var2_2;
                Window window = SwingUtilities.getWindowAncestor(this);
                X11 x11 = X11.INSTANCE;
                X11.Display dpy = x11.XOpenDisplay(null);
                X11.Window win = X11WindowUtils.getDrawable(window);
                Point offset = new Point();
                win = X11WindowUtils.access$1000(window, dpy, win, offset);
                X11.GC gc = x11.XCreateGC(dpy, win, new NativeLong(0L), null);
                Raster raster = buf.getData();
                int w = bounds.width;
                int h = bounds.height;
                if (this.buffer == null || this.buffer.size() != (long)(w * h << 2)) {
                    this.buffer = new Memory((long)(w * h << 2));
                    this.pixels = new int[w * h];
                }
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        raster.getPixel(x, y, this.pixel);
                        int alpha = this.pixel[3] & 0xFF;
                        int red = this.pixel[2] & 0xFF;
                        int green = this.pixel[1] & 0xFF;
                        int blue = this.pixel[0] & 0xFF;
                        this.pixels[y * w + x] = alpha << 24 | blue << 16 | green << 8 | red;
                    }
                }
                X11.XWindowAttributes xwa = new X11.XWindowAttributes();
                x11.XGetWindowAttributes(dpy, win, xwa);
                X11.XImage image = x11.XCreateImage(dpy, xwa.visual, 32, 2, 0, (Pointer)this.buffer, w, h, 32, w << 2);
                this.buffer.write(0L, this.pixels, 0, this.pixels.length);
                offset.x += bounds.x;
                offset.y += var2_2.y;
                x11.XPutImage(dpy, win, gc, image, 0, 0, offset.x, offset.y, w, h);
                x11.XFree(image.getPointer());
                x11.XFreeGC(dpy, (X11.GC)var3_3);
                x11.XCloseDisplay(dpy);
            }
        }
    }

    private static class MacWindowUtils
    extends NativeWindowUtils {
        private static final String WDRAG = "apple.awt.draggableWindowBackground";

        private MacWindowUtils() {
        }

        @Override
        public boolean isWindowAlphaSupported() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private OSXMaskingContentPane installMaskingPane(Window w) {
            void var2_4;
            void var1_1;
            OSXMaskingContentPane content;
            if (w instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)((Object)w);
                Container oldContent = rpc.getContentPane();
                if (oldContent instanceof OSXMaskingContentPane) {
                    content = (OSXMaskingContentPane)oldContent;
                } else {
                    content = new OSXMaskingContentPane((Component)var1_1);
                    rpc.setContentPane(content);
                }
            } else {
                Component oldContent = var1_1.getComponentCount() > 0 ? var1_1.getComponent(0) : null;
                if (oldContent instanceof OSXMaskingContentPane) {
                    content = (OSXMaskingContentPane)oldContent;
                } else {
                    void var3_3;
                    content = new OSXMaskingContentPane((Component)var3_3);
                    var1_1.add(content);
                }
            }
            return var2_4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowTransparent(Window w, boolean transparent) {
            void var3_3;
            boolean isTransparent;
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (transparent != var3_3) {
                void var2_2;
                void var1_1;
                this.setBackgroundTransparent((Window)var1_1, (boolean)var2_2, "setWindowTransparent");
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fixWindowDragging(Window w, String context) {
            JRootPane p;
            Boolean bl;
            if (w instanceof RootPaneContainer && (bl = (Boolean)(p = ((RootPaneContainer)((Object)w)).getRootPane()).getClientProperty(WDRAG)) == null) {
                void var1_1;
                void var3_3;
                var3_3.putClientProperty(WDRAG, Boolean.FALSE);
                if (var1_1.isDisplayable()) {
                    void var2_2;
                    LOG.log(Level.WARNING, "{0}(): To avoid content dragging, {1}() must be called before the window is realized, or apple.awt.draggableWindowBackground must be set to Boolean.FALSE before the window is realized.  If you really want content dragging, set apple.awt.draggableWindowBackground on the window''s root pane to Boolean.TRUE before calling {2}() to hide this message.", new Object[]{context, context, var2_2});
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowAlpha(Window w, float alpha) {
            void var2_2;
            void var1_1;
            if (w instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)w)).getRootPane();
                jRootPane.putClientProperty("Window.alpha", Float.valueOf(alpha));
                this.fixWindowDragging(w, "setWindowAlpha");
            }
            this.whenDisplayable(w, new Runnable(this, (Window)var1_1, (float)var2_2){
                final /* synthetic */ Window val$w;
                final /* synthetic */ float val$alpha;
                final /* synthetic */ MacWindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$alpha = f;
                }

                @Override
                public void run() {
                    try {
                        Method method = this.val$w.getClass().getMethod("getPeer", new Class[0]);
                        Object peer = method.invoke((Object)this.val$w, new Object[0]);
                        Method method2 = peer.getClass().getMethod("setAlpha", Float.TYPE);
                        method2.invoke((Object)method, Float.valueOf(this.val$alpha));
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void setWindowMask(Component w, Raster raster) {
            void var1_1;
            if (raster != null) {
                void var2_2;
                this.setWindowMask(w, this.toShape((Raster)var2_2));
                return;
            }
            this.setWindowMask(w, new Rectangle(0, 0, w.getWidth(), var1_1.getHeight()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowMask(Component c, Shape shape) {
            if (c instanceof Window) {
                void var2_2;
                void var1_1;
                Window w = (Window)c;
                OSXMaskingContentPane oSXMaskingContentPane = this.installMaskingPane(w);
                oSXMaskingContentPane.setMask(shape);
                this.setBackgroundTransparent((Window)var1_1, var2_2 != MASK_NONE, "setWindowMask");
            }
        }

        /*
         * WARNING - void declaration
         */
        private void setBackgroundTransparent(Window w, boolean transparent, String context) {
            void var3_4;
            void var1_1;
            JRootPane rp;
            JRootPane jRootPane = rp = w instanceof RootPaneContainer ? ((RootPaneContainer)((Object)w)).getRootPane() : null;
            if (transparent) {
                if (rp != null) {
                    rp.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, w.getBackground());
                }
                w.setBackground(new Color(0, 0, 0, 0));
            } else if (rp != null) {
                void var2_3;
                Color bg = (Color)rp.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG);
                if (bg != null) {
                    bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), bg.getAlpha());
                }
                w.setBackground((Color)var2_3);
                rp.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, null);
            } else {
                w.setBackground(null);
            }
            this.fixWindowDragging((Window)var1_1, (String)var3_4);
        }

        private static class OSXMaskingContentPane
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private Shape shape;

            /*
             * WARNING - void declaration
             */
            public OSXMaskingContentPane(Component oldContent) {
                super(new BorderLayout());
                if (oldContent != null) {
                    void var1_1;
                    this.add((Component)var1_1, "Center");
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setMask(Shape shape) {
                void var1_1;
                this.shape = var1_1;
                this.repaint();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void paint(Graphics graphics) {
                void var1_1;
                Graphics2D g = (Graphics2D)graphics.create();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.dispose();
                if (this.shape != null) {
                    void var2_2;
                    g = (Graphics2D)graphics.create();
                    g.setClip(this.shape);
                    super.paint(g);
                    var2_2.dispose();
                    return;
                }
                super.paint((Graphics)var1_1);
            }
        }
    }

    private static class W32WindowUtils
    extends NativeWindowUtils {
        private W32WindowUtils() {
        }

        /*
         * WARNING - void declaration
         */
        private WinDef.HWND getHWnd(Component w) {
            void var2_2;
            void var1_1;
            WinDef.HWND hwnd = new WinDef.HWND();
            hwnd.setPointer(Native.getComponentPointer((Component)var1_1));
            return var2_2;
        }

        @Override
        public boolean isWindowAlphaSupported() {
            return Boolean.getBoolean("sun.java2d.noddraw");
        }

        private boolean usingUpdateLayeredWindow(Window w) {
            if (w instanceof RootPaneContainer) {
                JRootPane jRootPane;
                return (jRootPane = ((RootPaneContainer)((Object)jRootPane)).getRootPane()).getClientProperty(WindowUtils.TRANSPARENT_OLD_BG) != null;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void storeAlpha(Window w, byte alpha) {
            if (w instanceof RootPaneContainer) {
                void var2_3;
                void var1_1;
                JRootPane root = ((RootPaneContainer)((Object)w)).getRootPane();
                Byte b = alpha == -1 ? null : Byte.valueOf(alpha);
                var1_1.putClientProperty(WindowUtils.TRANSPARENT_ALPHA, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private byte getAlpha(Window w) {
            Byte b;
            if (w instanceof RootPaneContainer && (b = (Byte)((JComponent)(w = ((RootPaneContainer)((Object)w)).getRootPane())).getClientProperty(WindowUtils.TRANSPARENT_ALPHA)) != null) {
                void var1_1;
                return var1_1.byteValue();
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowAlpha(Window w, float alpha) {
            void var2_2;
            void var1_1;
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
            }
            this.whenDisplayable(w, new Runnable(this, (Window)var1_1, (float)var2_2){
                final /* synthetic */ Window val$w;
                final /* synthetic */ float val$alpha;
                final /* synthetic */ W32WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$alpha = f;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    WinDef.HWND hWnd = W32WindowUtils.access$400(this.this$0, this.val$w);
                    User32 user = User32.INSTANCE;
                    int flags = user.GetWindowLong(hWnd, -20);
                    byte level = (byte)(255.0f * this.val$alpha);
                    if (W32WindowUtils.access$500(this.this$0, this.val$w)) {
                        void var3_4;
                        WinUser.BLENDFUNCTION blend = new WinUser.BLENDFUNCTION();
                        new WinUser.BLENDFUNCTION().SourceConstantAlpha = level;
                        blend.AlphaFormat = 1;
                        user.UpdateLayeredWindow(hWnd, null, null, null, null, null, 0, (WinUser.BLENDFUNCTION)var3_4, 2);
                    } else if (this.val$alpha == 1.0f) {
                        user.SetWindowLong(hWnd, -20, var3_3 &= 0xFFF7FFFF);
                    } else {
                        void var1_1;
                        void var2_2;
                        user.SetWindowLong(hWnd, -20, var3_3 |= 0x80000);
                        var2_2.SetLayeredWindowAttributes((WinDef.HWND)var1_1, 0, level, 2);
                    }
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$alpha != 1.0f);
                    W32WindowUtils.access$600(this.this$0, this.val$w, level);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowTransparent(Window w, boolean transparent) {
            void var2_2;
            void var1_1;
            void var3_3;
            boolean isTransparent;
            if (!(w instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
            }
            boolean bl = isTransparent = w.getBackground() != null && w.getBackground().getAlpha() == 0;
            if (transparent == var3_3) {
                return;
            }
            this.whenDisplayable(w, new Runnable(this, (Window)var1_1, (boolean)var2_2){
                final /* synthetic */ Window val$w;
                final /* synthetic */ boolean val$transparent;
                final /* synthetic */ W32WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = window;
                    this.val$transparent = bl;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    User32 user = User32.INSTANCE;
                    WinDef.HWND hWnd = W32WindowUtils.access$400(this.this$0, this.val$w);
                    int flags = user.GetWindowLong(hWnd, -20);
                    JRootPane root = ((RootPaneContainer)((Object)this.val$w)).getRootPane();
                    JLayeredPane lp = root.getLayeredPane();
                    Container content = root.getContentPane();
                    if (content instanceof W32TransparentContentPane) {
                        ((W32TransparentContentPane)content).setTransparent(this.val$transparent);
                    } else if (this.val$transparent) {
                        W32TransparentContentPane w32content = this.this$0.new W32TransparentContentPane(content);
                        root.setContentPane(w32content);
                        lp.add((Component)new RepaintTrigger(w32content), JLayeredPane.DRAG_LAYER);
                    }
                    if (this.val$transparent && !W32WindowUtils.access$500(this.this$0, this.val$w)) {
                        user.SetWindowLong(hWnd, -20, flags |= 0x80000);
                    } else if (!this.val$transparent && W32WindowUtils.access$500(this.this$0, this.val$w)) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        flags &= 0xFFF7FFFF;
                        var1_1.SetWindowLong((WinDef.HWND)var2_2, -20, (int)var3_3);
                    }
                    this.this$0.setLayersTransparent(this.val$w, this.val$transparent);
                    this.this$0.setForceHeavyweightPopups(this.val$w, this.val$transparent);
                    this.this$0.setDoubleBuffered(this.val$w, !this.val$transparent);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWindowMask(Component w, Shape mask) {
            void var2_2;
            void var1_1;
            if (mask instanceof Area && ((Area)mask).isPolygonal()) {
                this.setMask(w, (Area)mask);
                return;
            }
            super.setWindowMask((Component)var1_1, (Shape)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void setWindowRegion(Component w, WinDef.HRGN hrgn) {
            void var2_2;
            void var1_1;
            this.whenDisplayable(w, new Runnable(this, (Component)var1_1, (WinDef.HRGN)var2_2){
                final /* synthetic */ Component val$w;
                final /* synthetic */ WinDef.HRGN val$hrgn;
                final /* synthetic */ W32WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$w = component;
                    this.val$hrgn = hRGN;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    GDI32 gdi = GDI32.INSTANCE;
                    User32 user = User32.INSTANCE;
                    WinDef.HWND hWnd = W32WindowUtils.access$400(this.this$0, this.val$w);
                    try {
                        void var3_4;
                        void var2_2;
                        var2_2.SetWindowRgn((WinDef.HWND)var3_4, this.val$hrgn, true);
                        this.this$0.setForceHeavyweightPopups(this.this$0.getWindow(this.val$w), this.val$hrgn != null);
                        gdi.DeleteObject(this.val$hrgn);
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        var1_1.DeleteObject(this.val$hrgn);
                        throw throwable;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private void setMask(Component w, Area area) {
            void var2_4;
            void var1_1;
            void var3_5;
            GDI32 gdi = GDI32.INSTANCE;
            PathIterator pi = area.getPathIterator(null);
            int mode = pi.getWindingRule() == 1 ? 2 : 1;
            float[] coords = new float[6];
            ArrayList<WinDef.POINT> points = new ArrayList<WinDef.POINT>();
            int size = 0;
            ArrayList<Integer> sizes = new ArrayList<Integer>();
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                if (type == 0) {
                    size = 1;
                    points.add(new WinDef.POINT((int)coords[0], (int)coords[1]));
                } else if (type == 1) {
                    ++size;
                    points.add(new WinDef.POINT((int)coords[0], (int)coords[1]));
                } else if (type == 4) {
                    sizes.add(size);
                } else {
                    throw new RuntimeException("Area is not polygonal: " + area);
                }
                pi.next();
            }
            WinDef.POINT[] lppt = (WinDef.POINT[])new WinDef.POINT().toArray(points.size());
            ArrayList<WinDef.POINT> arrayList = points;
            WinDef.POINT[] pts = arrayList.toArray(new WinDef.POINT[arrayList.size()]);
            for (int i = 0; i < lppt.length; ++i) {
                lppt[i].x = pts[i].x;
                lppt[i].y = pts[i].y;
            }
            int[] counts = new int[sizes.size()];
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = (Integer)sizes.get(i);
            }
            WinDef.HRGN hrgn = var3_5.CreatePolyPolygonRgn(lppt, counts, counts.length, mode);
            this.setWindowRegion((Component)var1_1, (WinDef.HRGN)var2_4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void setMask(Component w2, Raster raster) {
            void var1_1;
            GDI32 gdi = GDI32.INSTANCE;
            WinDef.HRGN region = raster != null ? gdi.CreateRectRgn(0, 0, 0, 0) : null;
            if (region != null) {
                WinDef.HRGN tempRgn = gdi.CreateRectRgn(0, 0, 0, 0);
                try {
                    void var2_3;
                    RasterRangesUtils.outputOccupiedRanges((Raster)var2_3, new RasterRangesUtils.RangesOutput(this, tempRgn, region){
                        final /* synthetic */ WinDef.HRGN val$tempRgn;
                        final /* synthetic */ WinDef.HRGN val$region;
                        final /* synthetic */ W32WindowUtils this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$tempRgn = hRGN;
                            this.val$region = hRGN2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public boolean outputRange(int x, int y, int w, int h) {
                            void var2_2;
                            void var3_3;
                            void var1_1;
                            GDI32 gdi = GDI32.INSTANCE;
                            gdi.SetRectRgn(this.val$tempRgn, x, y, (int)(var1_1 + var3_3), (int)(var2_2 + h));
                            return gdi.CombineRgn(this.val$region, this.val$region, this.val$tempRgn, 2) != 0;
                        }
                    });
                    gdi.DeleteObject(tempRgn);
                }
                catch (Throwable w2) {
                    void var3_4;
                    var3_4.DeleteObject(tempRgn);
                    throw w2;
                }
            }
            this.setWindowRegion((Component)var1_1, region);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BufferedImage getWindowIcon(WinDef.HWND hwnd) {
            void var1_1;
            WinGDI.BITMAPINFOHEADER hdr;
            WinDef.DWORDByReference hIconNumber = new WinDef.DWORDByReference();
            WinDef.LRESULT result = User32.INSTANCE.SendMessageTimeout(hwnd, 127, new WinDef.WPARAM(1L), new WinDef.LPARAM(0L), 2, 500, hIconNumber);
            if (result.intValue() == 0) {
                result = User32.INSTANCE.SendMessageTimeout(hwnd, 127, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L), 2, 500, hIconNumber);
            }
            if (result.intValue() == 0) {
                result = User32.INSTANCE.SendMessageTimeout(hwnd, 127, new WinDef.WPARAM(2L), new WinDef.LPARAM(0L), 2, 500, hIconNumber);
            }
            if (result.intValue() == 0) {
                result = new WinDef.LRESULT(User32.INSTANCE.GetClassLongPtr(hwnd, -14).intValue());
                hIconNumber.getValue().setValue(result.intValue());
            }
            if (result.intValue() == 0) {
                result = new WinDef.LRESULT(User32.INSTANCE.GetClassLongPtr(hwnd, -34).intValue());
                hIconNumber.getValue().setValue(result.intValue());
            }
            if (result.intValue() == 0) {
                return null;
            }
            WinDef.HICON hIcon = new WinDef.HICON(new Pointer(hIconNumber.getValue().longValue()));
            Dimension iconSize = this.getIconSize(hIcon);
            if (iconSize.width == 0 || iconSize.height == 0) {
                return null;
            }
            int width = iconSize.width;
            int height = iconSize.height;
            byte[] lpBitsColor = new byte[width * height * 24 / 8];
            Memory lpBitsColorPtr = new Memory((long)lpBitsColor.length);
            byte[] lpBitsMask = new byte[width * height * 24 / 8];
            Memory lpBitsMaskPtr = new Memory((long)lpBitsMask.length);
            WinGDI.BITMAPINFO bitmapInfo = new WinGDI.BITMAPINFO();
            bitmapInfo.bmiHeader = hdr = new WinGDI.BITMAPINFOHEADER();
            hdr.biWidth = width;
            hdr.biHeight = height;
            hdr.biPlanes = 1;
            hdr.biBitCount = (short)24;
            hdr.biCompression = 0;
            hdr.write();
            bitmapInfo.write();
            WinDef.HDC hDC = User32.INSTANCE.GetDC(null);
            WinGDI.ICONINFO iconInfo = new WinGDI.ICONINFO();
            User32.INSTANCE.GetIconInfo(hIcon, iconInfo);
            iconInfo.read();
            GDI32.INSTANCE.GetDIBits(hDC, iconInfo.hbmColor, 0, height, (Pointer)lpBitsColorPtr, bitmapInfo, 0);
            lpBitsColorPtr.read(0L, lpBitsColor, 0, lpBitsColor.length);
            GDI32.INSTANCE.GetDIBits(hDC, iconInfo.hbmMask, 0, height, (Pointer)lpBitsMaskPtr, bitmapInfo, 0);
            lpBitsMaskPtr.read(0L, lpBitsMask, 0, lpBitsMask.length);
            BufferedImage image = new BufferedImage(width, height, 2);
            int x = 0;
            int y = height - 1;
            for (int i = 0; i < lpBitsColor.length; i += 3) {
                void var2_3;
                int b = lpBitsColor[i] & 0xFF;
                int g = lpBitsColor[i + 1] & 0xFF;
                int r = lpBitsColor[i + 2] & 0xFF;
                int n = 255 - lpBitsMask[i] & 0xFF;
                int argb = n << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, (int)var2_3);
                x = (x + 1) % width;
                if (x != 0) continue;
                --y;
            }
            User32.INSTANCE.ReleaseDC(null, hDC);
            return var1_1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public Dimension getIconSize(WinDef.HICON hIcon) {
            block16: {
                block15: {
                    block14: {
                        iconInfo = new WinGDI.ICONINFO();
                        try {
                            if (User32.INSTANCE.GetIconInfo(hIcon /* !! */ , iconInfo)) break block14;
                            hIcon /* !! */  = new Dimension();
                        }
                        catch (Throwable var1_2) {
                            if (iconInfo.hbmColor != null && iconInfo.hbmColor.getPointer() != Pointer.NULL) {
                                GDI32.INSTANCE.DeleteObject(iconInfo.hbmColor);
                            }
                            if (iconInfo.hbmMask != null && iconInfo.hbmMask.getPointer() != Pointer.NULL) {
                                GDI32.INSTANCE.DeleteObject(var2_3.hbmMask);
                            }
                            throw var1_2;
                        }
                        if (iconInfo.hbmColor != null && iconInfo.hbmColor.getPointer() != Pointer.NULL) {
                            GDI32.INSTANCE.DeleteObject(iconInfo.hbmColor);
                        }
                        if (iconInfo.hbmMask != null && iconInfo.hbmMask.getPointer() != Pointer.NULL) {
                            GDI32.INSTANCE.DeleteObject(iconInfo.hbmMask);
                        }
                        return hIcon /* !! */ ;
                    }
                    iconInfo.read();
                    bmp /* !! */  = new WinGDI.BITMAP();
                    if (iconInfo.hbmColor == null || iconInfo.hbmColor.getPointer() == Pointer.NULL) ** GOTO lbl39
                    nWrittenBytes = GDI32.INSTANCE.GetObject(iconInfo.hbmColor, bmp /* !! */ .size(), bmp /* !! */ .getPointer());
                    bmp /* !! */ .read();
                    if (nWrittenBytes <= 0) break block15;
                    bmp /* !! */  = new Dimension(bmp /* !! */ .bmWidth.intValue(), bmp /* !! */ .bmHeight.intValue());
                    if (iconInfo.hbmColor != null && iconInfo.hbmColor.getPointer() != Pointer.NULL) {
                        GDI32.INSTANCE.DeleteObject(iconInfo.hbmColor);
                    }
                    if (iconInfo.hbmMask != null && iconInfo.hbmMask.getPointer() != Pointer.NULL) {
                        GDI32.INSTANCE.DeleteObject(iconInfo.hbmMask);
                    }
                    return bmp /* !! */ ;
                }
                break block16;
lbl39:
                // 1 sources

                if (iconInfo.hbmMask == null || iconInfo.hbmMask.getPointer() == Pointer.NULL) break block16;
                nWrittenBytes = GDI32.INSTANCE.GetObject(iconInfo.hbmMask, bmp /* !! */ .size(), bmp /* !! */ .getPointer());
                bmp /* !! */ .read();
                if (var3_5 <= 0) break block16;
                var1_1 = new Dimension(bmp /* !! */ .bmWidth.intValue(), var1_1.bmHeight.intValue() / 2);
                if (iconInfo.hbmColor != null && iconInfo.hbmColor.getPointer() != Pointer.NULL) {
                    GDI32.INSTANCE.DeleteObject(iconInfo.hbmColor);
                }
                if (iconInfo.hbmMask != null && iconInfo.hbmMask.getPointer() != Pointer.NULL) {
                    GDI32.INSTANCE.DeleteObject(iconInfo.hbmMask);
                }
                return var1_1;
            }
            if (iconInfo.hbmColor != null && iconInfo.hbmColor.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(iconInfo.hbmColor);
            }
            if (iconInfo.hbmMask != null && iconInfo.hbmMask.getPointer() != Pointer.NULL) {
                GDI32.INSTANCE.DeleteObject(iconInfo.hbmMask);
            }
            return new Dimension();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<DesktopWindow> getAllWindows(boolean onlyVisibleWindows) {
            void var2_3;
            void var1_2;
            LinkedList result = new LinkedList();
            WinUser.WNDENUMPROC lpEnumFunc = new WinUser.WNDENUMPROC(this, onlyVisibleWindows, result){
                final /* synthetic */ boolean val$onlyVisibleWindows;
                final /* synthetic */ List val$result;
                final /* synthetic */ W32WindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$onlyVisibleWindows = bl;
                    this.val$result = list;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean callback(WinDef.HWND hwnd, Pointer arg12) {
                    try {
                        boolean arg12 = !this.val$onlyVisibleWindows || User32.INSTANCE.IsWindowVisible(hwnd);
                        if (arg12) {
                            void var3_5;
                            void var2_4;
                            void var1_1;
                            String title = this.this$0.getWindowTitle(hwnd);
                            String filePath = this.this$0.getProcessFilePath(hwnd);
                            Rectangle locAndSize = this.this$0.getWindowLocationAndSize(hwnd);
                            this.val$result.add(new DesktopWindow((WinDef.HWND)var1_1, (String)var2_4, (String)var3_5, locAndSize));
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        exception.printStackTrace();
                    }
                    return true;
                }
            };
            if (!User32.INSTANCE.EnumWindows((WinUser.WNDENUMPROC)var1_2, null)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            return var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getWindowTitle(WinDef.HWND hwnd) {
            void var1_2;
            void var3_4;
            void var2_3;
            int requiredLength = User32.INSTANCE.GetWindowTextLength(hwnd) + 1;
            char[] title = new char[requiredLength];
            int length = User32.INSTANCE.GetWindowText(hwnd, title, (int)var2_3);
            return Native.toString((char[])Arrays.copyOfRange((char[])var3_4, 0, (int)var1_2));
        }

        /*
         * Exception decompiling
         */
        @Override
        public String getProcessFilePath(WinDef.HWND hwnd) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Rectangle getWindowLocationAndSize(WinDef.HWND hwnd) {
            void var2_2;
            void var1_1;
            WinDef.RECT lpRect = new WinDef.RECT();
            if (!User32.INSTANCE.GetWindowRect((WinDef.HWND)var1_1, lpRect)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            return new Rectangle(lpRect.left, lpRect.top, Math.abs(lpRect.right - lpRect.left), Math.abs(lpRect.bottom - var2_2.top));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ WinDef.HWND access$400(W32WindowUtils x0, Component x1) {
            void var1_1;
            return x0.getHWnd((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$500(W32WindowUtils x0, Window x1) {
            void var1_1;
            return x0.usingUpdateLayeredWindow((Window)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$600(W32WindowUtils x0, Window x1, byte x2) {
            void var2_2;
            void var1_1;
            x0.storeAlpha((Window)var1_1, (byte)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ byte access$700(W32WindowUtils x0, Window x1) {
            void var1_1;
            return x0.getAlpha((Window)var1_1);
        }

        private class W32TransparentContentPane
        extends NativeWindowUtils.TransparentContentPane {
            private static final long serialVersionUID = 1L;
            private WinDef.HDC memDC;
            private WinDef.HBITMAP hBitmap;
            private Pointer pbits;
            private Dimension bitmapSize;

            /*
             * WARNING - void declaration
             */
            public W32TransparentContentPane(Container content) {
                void var2_2;
                super(W32WindowUtils.this, (Container)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            private void disposeBackingStore() {
                GDI32 gdi = GDI32.INSTANCE;
                if (this.hBitmap != null) {
                    gdi.DeleteObject(this.hBitmap);
                    this.hBitmap = null;
                }
                if (this.memDC != null) {
                    void var1_1;
                    var1_1.DeleteDC(this.memDC);
                    this.memDC = null;
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                this.disposeBackingStore();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setTransparent(boolean transparent) {
                void var1_1;
                super.setTransparent(transparent);
                if (var1_1 == false) {
                    this.disposeBackingStore();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void paintDirect(BufferedImage buf, Rectangle bounds) {
                Window win = SwingUtilities.getWindowAncestor(this);
                GDI32 gdi = GDI32.INSTANCE;
                User32 user = User32.INSTANCE;
                int x = bounds.x;
                int y = bounds.y;
                Point origin = SwingUtilities.convertPoint(this, x, y, win);
                int w = bounds.width;
                int h = bounds.height;
                int ww = win.getWidth();
                int wh = win.getHeight();
                WinDef.HDC screenDC = user.GetDC(null);
                WinNT.HANDLE oldBitmap = null;
                try {
                    void var2_4;
                    void var3_5;
                    if (this.memDC == null) {
                        this.memDC = gdi.CreateCompatibleDC(screenDC);
                    }
                    if (this.hBitmap == null || !win.getSize().equals(this.bitmapSize)) {
                        if (this.hBitmap != null) {
                            gdi.DeleteObject(this.hBitmap);
                            this.hBitmap = null;
                        }
                        WinGDI.BITMAPINFO bmi = new WinGDI.BITMAPINFO();
                        new WinGDI.BITMAPINFO().bmiHeader.biWidth = ww;
                        bmi.bmiHeader.biHeight = wh;
                        bmi.bmiHeader.biPlanes = 1;
                        bmi.bmiHeader.biBitCount = (short)32;
                        bmi.bmiHeader.biCompression = 0;
                        bmi.bmiHeader.biSizeImage = ww * wh << 2;
                        PointerByReference ppbits = new PointerByReference();
                        this.hBitmap = gdi.CreateDIBSection(this.memDC, bmi, 0, ppbits, null, 0);
                        this.pbits = ppbits.getValue();
                        this.bitmapSize = new Dimension(ww, wh);
                    }
                    oldBitmap = gdi.SelectObject(this.memDC, this.hBitmap);
                    Raster raster = buf.getData();
                    int[] pixel = new int[4];
                    int[] bits = new int[w];
                    for (int row = 0; row < h; ++row) {
                        for (int col = 0; col < w; ++col) {
                            raster.getPixel(col, row, pixel);
                            int alpha = (pixel[3] & 0xFF) << 24;
                            int red = pixel[2] & 0xFF;
                            int green = (pixel[1] & 0xFF) << 8;
                            int blue = (pixel[0] & 0xFF) << 16;
                            bits[col] = alpha | red | green | blue;
                        }
                        int v = wh - (origin.y + row) - 1;
                        this.pbits.write((long)(v * ww + origin.x << 2), bits, 0, w);
                    }
                    WinUser.SIZE winSize = new WinUser.SIZE();
                    new WinUser.SIZE().cx = win.getWidth();
                    winSize.cy = win.getHeight();
                    WinDef.POINT winLoc = new WinDef.POINT();
                    new WinDef.POINT().x = win.getX();
                    winLoc.y = win.getY();
                    WinDef.POINT srcLoc = new WinDef.POINT();
                    WinUser.BLENDFUNCTION blend = new WinUser.BLENDFUNCTION();
                    WinDef.HWND hWnd = W32WindowUtils.access$400(W32WindowUtils.this, win);
                    ByteByReference bref = new ByteByReference();
                    IntByReference iref = new IntByReference();
                    byte level = W32WindowUtils.access$700(W32WindowUtils.this, (Window)var3_5);
                    try {
                        void var1_1;
                        if (user.GetLayeredWindowAttributes(hWnd, null, bref, iref) && (var1_1.getValue() & 2) != 0) {
                            level = bref.getValue();
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
                    blend.SourceConstantAlpha = var2_4;
                    blend.AlphaFormat = 1;
                    user.UpdateLayeredWindow(hWnd, screenDC, winLoc, winSize, this.memDC, srcLoc, 0, blend, 2);
                    user.ReleaseDC(null, screenDC);
                }
                catch (Throwable throwable) {
                    user.ReleaseDC(null, screenDC);
                    if (this.memDC != null && oldBitmap != null) {
                        gdi.SelectObject(this.memDC, oldBitmap);
                    }
                    throw throwable;
                }
                if (this.memDC != null && oldBitmap != null) {
                    gdi.SelectObject(this.memDC, oldBitmap);
                    return;
                }
            }
        }
    }

    private static class Holder {
        public static boolean requiresVisible;
        public static final NativeWindowUtils INSTANCE;

        private Holder() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            if (Platform.isWindows()) {
                INSTANCE = new W32WindowUtils();
                return;
            }
            if (Platform.isMac()) {
                INSTANCE = new MacWindowUtils();
                return;
            }
            if (Platform.isX11()) {
                INSTANCE = new X11WindowUtils();
                requiresVisible = System.getProperty("java.version").matches("^1\\.4\\..*");
                return;
            }
            String os = System.getProperty("os.name");
            throw new UnsupportedOperationException("No support for " + (String)var0);
        }
    }

    public static abstract class NativeWindowUtils {
        /*
         * WARNING - void declaration
         */
        protected Window getWindow(Component c) {
            void var1_1;
            if (c instanceof Window) {
                return (Window)c;
            }
            return SwingUtilities.getWindowAncestor((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void whenDisplayable(Component w, Runnable action) {
            void var2_2;
            void var1_1;
            if (w.isDisplayable() && (!Holder.requiresVisible || w.isVisible())) {
                action.run();
                return;
            }
            if (Holder.requiresVisible) {
                this.getWindow(w).addWindowListener(new WindowAdapter(this, action){
                    final /* synthetic */ Runnable val$action;
                    final /* synthetic */ NativeWindowUtils this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$action = runnable;
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                        e.getWindow().removeWindowListener(this);
                        this.val$action.run();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        e.getWindow().removeWindowListener(this);
                    }
                });
                return;
            }
            var1_1.addHierarchyListener(new HierarchyListener(this, (Runnable)var2_2){
                final /* synthetic */ Runnable val$action;
                final /* synthetic */ NativeWindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$action = runnable;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L && e.getComponent().isDisplayable()) {
                        void var1_1;
                        var1_1.getComponent().removeHierarchyListener(this);
                        this.val$action.run();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        protected Raster toRaster(Shape mask) {
            WritableRaster writableRaster;
            Object raster = null;
            if (mask != MASK_NONE) {
                Rectangle bounds = mask.getBounds();
                if (bounds.width > 0 && bounds.height > 0) {
                    void var1_1;
                    void var3_3;
                    BufferedImage clip = new BufferedImage(bounds.x + bounds.width, bounds.y + bounds.height, 12);
                    Graphics2D g = clip.createGraphics();
                    g.setColor(Color.black);
                    g.fillRect(0, 0, bounds.x + bounds.width, bounds.y + var3_3.height);
                    g.setColor(Color.white);
                    g.fill((Shape)var1_1);
                    writableRaster = ((BufferedImage)((Object)writableRaster)).getRaster();
                }
            }
            return writableRaster;
        }

        /*
         * WARNING - void declaration
         */
        protected Raster toRaster(Component c, Icon mask) {
            WritableRaster writableRaster;
            Object raster = null;
            if (mask != null) {
                void var1_1;
                void var2_2;
                Rectangle bounds = new Rectangle(0, 0, mask.getIconWidth(), mask.getIconHeight());
                BufferedImage clip = new BufferedImage(bounds.width, bounds.height, 2);
                Graphics2D g = clip.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, bounds.width, ((Rectangle)((Object)writableRaster)).height);
                g.setComposite(AlphaComposite.SrcOver);
                var2_2.paintIcon((Component)var1_1, g, 0, 0);
                writableRaster = clip.getAlphaRaster();
            }
            return writableRaster;
        }

        /*
         * WARNING - void declaration
         */
        protected Shape toShape(Raster raster) {
            void var2_2;
            void var1_1;
            Area area = new Area(new Rectangle(0, 0, 0, 0));
            RasterRangesUtils.outputOccupiedRanges((Raster)var1_1, new RasterRangesUtils.RangesOutput(this, area){
                final /* synthetic */ Area val$area;
                final /* synthetic */ NativeWindowUtils this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$area = area;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean outputRange(int x, int y, int w, int h) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.val$area.add(new Area(new Rectangle((int)var1_1, (int)var2_2, (int)var3_3, h)));
                    return true;
                }
            });
            return var2_2;
        }

        public void setWindowAlpha(Window w, float alpha) {
        }

        public boolean isWindowAlphaSupported() {
            return false;
        }

        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            object = ((GraphicsEnvironment)object).getDefaultScreenDevice();
            return ((GraphicsDevice)object).getDefaultConfiguration();
        }

        public void setWindowTransparent(Window w, boolean transparent) {
        }

        protected void setDoubleBuffered(Component root, boolean buffered) {
            if (root instanceof JComponent) {
                ((JComponent)root).setDoubleBuffered(buffered);
            }
            if (root instanceof JRootPane && buffered) {
                ((JRootPane)root).setDoubleBuffered(true);
                return;
            }
            if (root instanceof Container) {
                Component[] kids = ((Container)root).getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    this.setDoubleBuffered(kids[i], buffered);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void setLayersTransparent(Window w, boolean transparent) {
            void var3_3;
            void var1_1;
            Color bg;
            Color color = bg = transparent ? new Color(0, 0, 0, 0) : null;
            if (w instanceof RootPaneContainer) {
                void var2_2;
                JComponent content;
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)w);
                JRootPane root = rootPaneContainer.getRootPane();
                JLayeredPane lp = root.getLayeredPane();
                Container c = root.getContentPane();
                JComponent jComponent = content = c instanceof JComponent ? (JComponent)c : null;
                if (var2_2 != false) {
                    lp.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, lp.isOpaque());
                    lp.setOpaque(false);
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, root.isOpaque());
                    root.setOpaque(false);
                    if (content != null) {
                        content.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, content.isOpaque());
                        content.setOpaque(false);
                    }
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, root.getParent().getBackground());
                } else {
                    lp.setOpaque(Boolean.TRUE.equals(lp.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    lp.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, null);
                    root.setOpaque(Boolean.TRUE.equals(root.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, null);
                    if (content != null) {
                        content.setOpaque(Boolean.TRUE.equals(content.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                        content.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, null);
                    }
                    bg = (Color)root.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG);
                    root.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, null);
                }
            }
            var1_1.setBackground((Color)var3_3);
        }

        protected void setMask(Component c, Raster raster) {
            throw new UnsupportedOperationException("Window masking is not available");
        }

        /*
         * WARNING - void declaration
         */
        protected void setWindowMask(Component w, Raster raster) {
            void var2_2;
            void var1_1;
            if (w.isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight: " + w);
            }
            this.setMask((Component)var1_1, (Raster)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void setWindowMask(Component w, Shape mask) {
            void var2_2;
            void var1_1;
            this.setWindowMask((Component)var1_1, this.toRaster((Shape)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public void setWindowMask(Component w, Icon mask) {
            void var2_2;
            void var1_1;
            this.setWindowMask(w, this.toRaster((Component)var1_1, (Icon)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        protected void setForceHeavyweightPopups(Window w, boolean force) {
            if (!(w instanceof HeavyweightForcer)) {
                void var2_2;
                Window[] owned = w.getOwnedWindows();
                for (int i = 0; i < owned.length; ++i) {
                    if (!(owned[i] instanceof HeavyweightForcer)) continue;
                    if (force) {
                        return;
                    }
                    owned[i].dispose();
                }
                Boolean b = Boolean.valueOf(System.getProperty("jna.force_hw_popups", "true"));
                if (var2_2 != false && b.booleanValue()) {
                    void var1_1;
                    new HeavyweightForcer((Window)var1_1);
                }
            }
        }

        protected BufferedImage getWindowIcon(WinDef.HWND hwnd) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected Dimension getIconSize(WinDef.HICON hIcon) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected List<DesktopWindow> getAllWindows(boolean onlyVisibleWindows) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected String getWindowTitle(WinDef.HWND hwnd) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected String getProcessFilePath(WinDef.HWND hwnd) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected Rectangle getWindowLocationAndSize(WinDef.HWND hwnd) {
            throw new UnsupportedOperationException("This platform is not supported, yet.");
        }

        protected abstract class TransparentContentPane
        extends JPanel
        implements AWTEventListener {
            private static final long serialVersionUID = 1L;
            private boolean transparent;
            final /* synthetic */ NativeWindowUtils this$0;

            /*
             * WARNING - void declaration
             */
            public TransparentContentPane(NativeWindowUtils this$0, Container oldContent) {
                void var1_1;
                this.this$0 = var1_1;
                super(new BorderLayout());
                this.add((Component)oldContent, "Center");
                this.setTransparent(true);
                if (oldContent instanceof JPanel) {
                    void var2_2;
                    ((JComponent)var2_2).setOpaque(false);
                }
            }

            @Override
            public void addNotify() {
                super.addNotify();
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 2L);
            }

            @Override
            public void removeNotify() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                super.removeNotify();
            }

            /*
             * WARNING - void declaration
             */
            public void setTransparent(boolean transparent) {
                void var1_1;
                this.transparent = transparent;
                this.setOpaque(!transparent);
                this.setDoubleBuffered(var1_1 == false);
                this.repaint();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void eventDispatched(AWTEvent e) {
                if (e.getID() == 300 && SwingUtilities.isDescendingFrom(((ContainerEvent)e).getChild(), this)) {
                    void var1_1;
                    Component child = ((ContainerEvent)e).getChild();
                    this.this$0.setDoubleBuffered((Component)var1_1, false);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void paint(Graphics gr) {
                void var1_1;
                if (this.transparent) {
                    Rectangle r = gr.getClipBounds();
                    int w = r.width;
                    int h = r.height;
                    if (this.getWidth() > 0 && this.getHeight() > 0) {
                        void var3_3;
                        void var2_2;
                        BufferedImage buf = new BufferedImage(w, h, 3);
                        Graphics2D g = buf.createGraphics();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(0, 0, (int)var2_2, (int)var3_3);
                        g.dispose();
                        g = buf.createGraphics();
                        g.translate(-r.x, -r.y);
                        super.paint(g);
                        g.dispose();
                        this.paintDirect(buf, (Rectangle)var1_1);
                    }
                    return;
                }
                super.paint((Graphics)var1_1);
            }

            protected abstract void paintDirect(BufferedImage var1, Rectangle var2);
        }
    }

    protected static class RepaintTrigger
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final Listener listener = this.createListener();
        private final JComponent content;
        private Rectangle dirty;

        /*
         * WARNING - void declaration
         */
        public RepaintTrigger(JComponent content) {
            void var1_1;
            this.content = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addNotify() {
            void var1_1;
            super.addNotify();
            Window w = SwingUtilities.getWindowAncestor(this);
            RepaintTrigger repaintTrigger = this;
            repaintTrigger.setSize(repaintTrigger.getParent().getSize());
            w.addComponentListener(this.listener);
            var1_1.addWindowListener(this.listener);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 48L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void removeNotify() {
            void var1_1;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
            Window w = SwingUtilities.getWindowAncestor(this);
            w.removeComponentListener(this.listener);
            var1_1.removeWindowListener(this.listener);
            super.removeNotify();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = g.getClipBounds();
            if (this.dirty == null || !this.dirty.contains(bounds)) {
                void var1_1;
                this.dirty = this.dirty == null ? bounds : this.dirty.union((Rectangle)var1_1);
                this.content.repaint(this.dirty);
                return;
            }
            this.dirty = null;
        }

        protected Listener createListener() {
            return new Listener(this);
        }

        protected class Listener
        extends WindowAdapter
        implements AWTEventListener,
        ComponentListener,
        HierarchyListener {
            final /* synthetic */ RepaintTrigger this$0;

            /*
             * WARNING - void declaration
             */
            protected Listener(RepaintTrigger this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                this.this$0.repaint();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.this$0.setSize(this.this$0.getParent().getSize());
                this.this$0.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.this$0.repaint();
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                this.this$0.repaint();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void eventDispatched(AWTEvent e) {
                Component src;
                if (e instanceof MouseEvent && (src = ((MouseEvent)e).getComponent()) != null && SwingUtilities.isDescendingFrom(src, this.this$0.content)) {
                    void var2_2;
                    MouseEvent me = SwingUtilities.convertMouseEvent((Component)var2_2, (MouseEvent)e, this.this$0.content);
                    Component c = SwingUtilities.getDeepestComponentAt(this.this$0.content, me.getX(), me.getY());
                    if (c != null) {
                        void var1_1;
                        this.this$0.setCursor(var1_1.getCursor());
                    }
                }
            }
        }
    }

    private static class HeavyweightForcer
    extends Window {
        private static final long serialVersionUID = 1L;
        private final boolean packed;

        /*
         * WARNING - void declaration
         */
        public HeavyweightForcer(Window parent) {
            super((Window)var1_1);
            void var1_1;
            this.pack();
            this.packed = true;
        }

        @Override
        public boolean isVisible() {
            return this.packed;
        }

        @Override
        public Rectangle getBounds() {
            return this.getOwner().getBounds();
        }
    }
}

