/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.dnd;

import com.sun.jna.Platform;
import com.sun.jna.platform.dnd.GhostedDragImage;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public abstract class DragHandler
implements DragGestureListener,
DragSourceListener,
DragSourceMotionListener {
    private static final Logger LOG = Logger.getLogger(DragHandler.class.getName());
    public static final Dimension MAX_GHOST_SIZE = new Dimension(250, 250);
    public static final float DEFAULT_GHOST_ALPHA = 0.5f;
    public static final int UNKNOWN_MODIFIERS = -1;
    public static final Transferable UNKNOWN_TRANSFERABLE = null;
    protected static final int MOVE = 2;
    protected static final int COPY = 1;
    protected static final int LINK = 0x40000000;
    protected static final int NONE = 0;
    static final int MOVE_MASK = 64;
    static final boolean OSX = Platform.isMac();
    static final int COPY_MASK = OSX ? 512 : 128;
    static final int LINK_MASK = OSX ? 768 : 192;
    static final int KEY_MASK = 9152;
    private static int modifiers = -1;
    private static Transferable transferable = UNKNOWN_TRANSFERABLE;
    private int supportedActions;
    private boolean fixCursor = true;
    private Component dragSource;
    private GhostedDragImage ghost;
    private Point imageOffset;
    private Dimension maxGhostSize = MAX_GHOST_SIZE;
    private float ghostAlpha = 0.5f;
    private String lastAction;
    private boolean moved;

    static int getModifiers() {
        return modifiers;
    }

    public static Transferable getTransferable(DropTargetEvent e) {
        if (e instanceof DropTargetDragEvent) {
            try {
                return ((DropTargetDragEvent)e).getTransferable();
            }
            catch (Exception exception) {
            }
        } else if (e instanceof DropTargetDropEvent) {
            DropTargetEvent dropTargetEvent;
            return ((DropTargetDropEvent)dropTargetEvent).getTransferable();
        }
        return transferable;
    }

    /*
     * WARNING - void declaration
     */
    protected DragHandler(Component dragSource, int actions) {
        void var1_1;
        this.dragSource = dragSource;
        this.supportedActions = actions;
        try {
            String[] size;
            String max;
            String alpha = System.getProperty("DragHandler.alpha");
            if (alpha != null) {
                try {
                    this.ghostAlpha = Float.parseFloat(alpha);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((max = System.getProperty("DragHandler.maxDragImageSize")) != null && (size = max.split("x")).length == 2) {
                try {
                    void var2_3;
                    this.maxGhostSize = new Dimension(Integer.parseInt(size[0]), Integer.parseInt((String)var2_3[1]));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (SecurityException securityException) {}
        this.disableSwingDragSupport(dragSource);
        DragSource dragSource2 = DragSource.getDefaultDragSource();
        dragSource2.createDefaultDragGestureRecognizer((Component)var1_1, this.supportedActions, this);
    }

    /*
     * WARNING - void declaration
     */
    private void disableSwingDragSupport(Component comp) {
        if (comp instanceof JTree) {
            ((JTree)comp).setDragEnabled(false);
            return;
        }
        if (comp instanceof JList) {
            ((JList)comp).setDragEnabled(false);
            return;
        }
        if (comp instanceof JTable) {
            ((JTable)comp).setDragEnabled(false);
            return;
        }
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setDragEnabled(false);
            return;
        }
        if (comp instanceof JColorChooser) {
            ((JColorChooser)comp).setDragEnabled(false);
            return;
        }
        if (comp instanceof JFileChooser) {
            void var1_1;
            ((JFileChooser)var1_1).setDragEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean canDrag(DragGestureEvent e) {
        void var1_2;
        int mods = e.getTriggerEvent().getModifiersEx() & 0x23C0;
        if (mods == 64) {
            return (this.supportedActions & 2) != 0;
        }
        if (mods == COPY_MASK) {
            return (this.supportedActions & 1) != 0;
        }
        if (var1_2 == LINK_MASK) {
            return (this.supportedActions & 0x40000000) != 0;
        }
        return true;
    }

    protected void setModifiers(int mods) {
        modifiers = mods;
    }

    protected abstract Transferable getTransferable(DragGestureEvent var1);

    protected Icon getDragIcon(DragGestureEvent e, Point srcOffset) {
        return null;
    }

    protected void dragStarted(DragGestureEvent e) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        block7: {
            if ((e.getDragAction() & this.supportedActions) != 0 && this.canDrag(e)) {
                this.setModifiers(e.getTriggerEvent().getModifiersEx() & 0x23C0);
                Transferable transferable = this.getTransferable(e);
                if (transferable == null) {
                    return;
                }
                try {
                    void var2_2;
                    void var1_1;
                    Point srcOffset = new Point(0, 0);
                    Icon icon = this.getDragIcon(e, srcOffset);
                    Point origin = e.getDragOrigin();
                    this.imageOffset = new Point(srcOffset.x - origin.x, srcOffset.y - origin.y);
                    Icon dragIcon = this.scaleDragIcon(icon, this.imageOffset);
                    Cursor cursor = null;
                    if (dragIcon != null && DragSource.isDragImageSupported()) {
                        GraphicsConfiguration gc = e.getComponent().getGraphicsConfiguration();
                        e.startDrag(cursor, this.createDragImage(gc, dragIcon), this.imageOffset, transferable, this);
                    } else {
                        if (dragIcon != null) {
                            void var3_3;
                            Point screen = this.dragSource.getLocationOnScreen();
                            screen.translate(origin.x, origin.y);
                            Point cursorOffset = new Point(-this.imageOffset.x, -this.imageOffset.y);
                            this.ghost = new GhostedDragImage(this.dragSource, (Icon)var3_3, this.getImageLocation(screen), cursorOffset);
                            this.ghost.setAlpha(this.ghostAlpha);
                        }
                        e.startDrag(cursor, transferable, this);
                    }
                    this.dragStarted(e);
                    this.moved = false;
                    var1_1.getDragSource().addDragSourceMotionListener(this);
                    DragHandler.transferable = var2_2;
                    return;
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    if (this.ghost == null) break block7;
                    this.ghost.dispose();
                    this.ghost = null;
                }
            }
        }
    }

    protected Icon scaleDragIcon(Icon icon, Point imageOffset) {
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    protected Image createDragImage(GraphicsConfiguration gc, Icon icon) {
        void var1_1;
        void var2_2;
        void var3_3;
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = gc.createCompatibleImage(w, h, 3);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, (int)var3_3, h);
        g.setComposite(AlphaComposite.getInstance(2, this.ghostAlpha));
        var2_2.paintIcon(this.dragSource, g, 0, 0);
        g.dispose();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int reduce(int actions) {
        void var1_1;
        if ((actions & 2) != 0 && actions != 2) {
            return 2;
        }
        if ((actions & 1) != 0 && actions != 1) {
            return 1;
        }
        return (int)var1_1;
    }

    protected Cursor getCursorForAction(int actualAction) {
        switch (actualAction) {
            case 2: {
                return DragSource.DefaultMoveDrop;
            }
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveNoDrop;
    }

    /*
     * WARNING - void declaration
     */
    protected int getAcceptableDropAction(int targetActions) {
        void var1_1;
        DragHandler dragHandler = this;
        return dragHandler.reduce(dragHandler.supportedActions & var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected int getDropAction(DragSourceEvent ev) {
        if (ev instanceof DragSourceDragEvent) {
            ev = (DragSourceDragEvent)ev;
            return ((DragSourceDragEvent)ev).getDropAction();
        }
        if (ev instanceof DragSourceDropEvent) {
            void var1_1;
            return ((DragSourceDropEvent)var1_1).getDropAction();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int adjustDropAction(DragSourceEvent ev) {
        void var2_2;
        int action = this.getDropAction(ev);
        if (ev instanceof DragSourceDragEvent) {
            int n;
            DragSourceDragEvent e = (DragSourceDragEvent)ev;
            if (action == 0 && (n = e.getGestureModifiersEx() & 0x23C0) == 0) {
                void var1_1;
                action = this.getAcceptableDropAction(var1_1.getTargetActions());
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateCursor(DragSourceEvent ev) {
        void var2_2;
        void var1_1;
        if (!this.fixCursor) {
            return;
        }
        DragHandler dragHandler = this;
        Cursor cursor = dragHandler.getCursorForAction(dragHandler.adjustDropAction(ev));
        var1_1.getDragSourceContext().setCursor((Cursor)var2_2);
    }

    static String actionString(int action) {
        switch (action) {
            case 2: {
                return "MOVE";
            }
            case 3: {
                return "MOVE|COPY";
            }
            case 0x40000002: {
                return "MOVE|LINK";
            }
            case 0x40000003: {
                return "MOVE|COPY|LINK";
            }
            case 1: {
                return "COPY";
            }
            case 0x40000001: {
                return "COPY|LINK";
            }
            case 0x40000000: {
                return "LINK";
            }
        }
        return "NONE";
    }

    /*
     * WARNING - void declaration
     */
    private void describe(String type, DragSourceEvent e) {
        if (LOG.isLoggable(Level.FINE)) {
            void var3_3;
            DragSourceDragEvent ev;
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("drag: ");
            msgBuilder.append(type);
            DragSourceContext ds = e.getDragSourceContext();
            if (e instanceof DragSourceDragEvent) {
                void var1_1;
                ev = (DragSourceDragEvent)e;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(var1_1.getSourceActions()));
                msgBuilder.append(" usr=");
                msgBuilder.append(DragHandler.actionString(ev.getUserAction()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(ev.getTargetActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(ev.getDropAction()));
                msgBuilder.append(" mods=");
                msgBuilder.append(ev.getGestureModifiersEx());
            } else {
                msgBuilder.append(": e=");
                msgBuilder.append(ev);
            }
            String msg = var3_3.toString();
            if (!msg.equals(this.lastAction)) {
                void var2_2;
                LOG.log(Level.FINE, msg);
                this.lastAction = var2_2;
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        DragSource dragSource;
        this.describe("end", e);
        this.setModifiers(-1);
        transferable = UNKNOWN_TRANSFERABLE;
        if (this.ghost != null) {
            if (e.getDropSuccess()) {
                this.ghost.dispose();
            } else {
                this.ghost.returnToOrigin();
            }
            this.ghost = null;
        }
        dragSource = ((DragSourceEvent)((Object)dragSource)).getDragSourceContext().getDragSource();
        dragSource.removeDragSourceMotionListener(this);
        this.moved = false;
    }

    /*
     * WARNING - void declaration
     */
    private Point getImageLocation(Point where) {
        void var1_1;
        where.translate(this.imageOffset.x, this.imageOffset.y);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragEnter(DragSourceDragEvent e) {
        void var1_1;
        this.describe("enter", e);
        if (this.ghost != null) {
            this.ghost.move(this.getImageLocation(e.getLocation()));
        }
        this.updateCursor((DragSourceEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragMouseMoved(DragSourceDragEvent e) {
        this.describe("move", e);
        if (this.ghost != null) {
            this.ghost.move(this.getImageLocation(e.getLocation()));
        }
        if (this.moved) {
            void var1_1;
            this.updateCursor((DragSourceEvent)var1_1);
        }
        this.moved = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragOver(DragSourceDragEvent e) {
        void var1_1;
        this.describe("over", e);
        if (this.ghost != null) {
            this.ghost.move(this.getImageLocation(e.getLocation()));
        }
        this.updateCursor((DragSourceEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragExit(DragSourceEvent e) {
        void var1_1;
        this.describe("exit", (DragSourceEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
        void var1_1;
        this.describe("change", e);
        this.setModifiers(e.getGestureModifiersEx() & 0x23C0);
        if (this.ghost != null) {
            this.ghost.move(this.getImageLocation(e.getLocation()));
        }
        this.updateCursor((DragSourceEvent)var1_1);
    }
}

