/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class Advapi32Util {
    /*
     * WARNING - void declaration
     */
    public static String getUserName() {
        void var0;
        void var2_2;
        char[] buffer = new char[128];
        IntByReference len = new IntByReference(128);
        boolean result = Advapi32.INSTANCE.GetUserNameW(buffer, len);
        if (!result) {
            void var1_1;
            switch (Kernel32.INSTANCE.GetLastError()) {
                case 122: {
                    buffer = new char[len.getValue()];
                    break;
                }
                default: {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            result = Advapi32.INSTANCE.GetUserNameW(buffer, (IntByReference)var1_1);
        }
        if (var2_2 == false) {
            throw new Win32Exception(Native.getLastError());
        }
        return Native.toString((char[])var0);
    }

    public static Account getAccountByName(String accountName) {
        String string;
        return Advapi32Util.getAccountByName(null, string);
    }

    /*
     * WARNING - void declaration
     */
    public static Account getAccountByName(String systemName, String accountName) {
        Account account;
        void var3_3;
        void var1_1;
        void var2_2;
        char[] referencedDomainName;
        IntByReference pSid = new IntByReference(0);
        IntByReference cchDomainName = new IntByReference(0);
        PointerByReference peUse = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountName(systemName, accountName, null, pSid, null, cchDomainName, peUse)) {
            throw new RuntimeException("LookupAccountNameW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int rc = Kernel32.INSTANCE.GetLastError();
        if (pSid.getValue() == 0 || rc != 122) {
            throw new Win32Exception(rc);
        }
        Memory sidMemory = new Memory((long)pSid.getValue());
        WinNT.PSID result = new WinNT.PSID((Pointer)sidMemory);
        if (!Advapi32.INSTANCE.LookupAccountName(systemName, accountName, result, pSid, referencedDomainName = new char[cchDomainName.getValue() + 1], cchDomainName, peUse)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Account account2 = new Account();
        new Account().accountType = peUse.getPointer().getInt(0L);
        String[] accountNamePartsBs = accountName.split("\\\\", 2);
        String[] accountNamePartsAt = accountName.split("@", 2);
        account2.name = accountNamePartsBs.length == 2 ? var2_2[1] : (accountNamePartsAt.length == 2 ? accountNamePartsAt[0] : var1_1);
        if (var3_3.getValue() > 0) {
            account2.domain = Native.toString((char[])referencedDomainName);
            account2.fqn = account2.domain + "\\" + account2.name;
        } else {
            account2.fqn = account2.name;
        }
        account2.sid = result.getBytes();
        account2.sidString = Advapi32Util.convertSidToStringSid(new WinNT.PSID(account2.sid));
        return account;
    }

    public static Account getAccountBySid(WinNT.PSID sid) {
        WinNT.PSID pSID;
        return Advapi32Util.getAccountBySid(null, pSID);
    }

    /*
     * WARNING - void declaration
     */
    public static Account getAccountBySid(String systemName, WinNT.PSID sid) {
        Account account;
        void var1_1;
        void var3_3;
        void var2_2;
        IntByReference cchName = new IntByReference(257);
        IntByReference cchDomainName = new IntByReference(256);
        PointerByReference peUse = new PointerByReference();
        char[] domainName = new char[cchDomainName.getValue()];
        char[] name = new char[cchName.getValue()];
        int rc = 0;
        if (!Advapi32.INSTANCE.LookupAccountSid(systemName, sid, name, (IntByReference)var2_2, domainName, (IntByReference)var3_3, peUse) && (rc = Kernel32.INSTANCE.GetLastError()) != 1332) {
            throw new Win32Exception(rc);
        }
        Account account2 = new Account();
        if (rc == 1332) {
            account2.accountType = 8;
            account2.name = "NONE_MAPPED";
        } else {
            account2.accountType = peUse.getPointer().getInt(0L);
            account2.name = Native.toString((char[])name);
        }
        account2.domain = Native.toString((char[])domainName);
        account2.fqn = account2.domain.isEmpty() ? account2.name : account2.domain + "\\" + account2.name;
        account2.sid = sid.getBytes();
        account2.sidString = Advapi32Util.convertSidToStringSid((WinNT.PSID)var1_1);
        return account;
    }

    public static String convertSidToStringSid(WinNT.PSID sid) {
        String string;
        PointerByReference stringSid = new PointerByReference();
        if (!Advapi32.INSTANCE.ConvertSidToStringSid(sid, stringSid)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        WinNT.PSID ptr = string.getValue();
        try {
            string = ptr.getWideString(0L);
        }
        catch (Throwable throwable) {
            WinNT.PSID pSID;
            Kernel32Util.freeLocalMemory((Pointer)pSID);
            throw throwable;
        }
        Kernel32Util.freeLocalMemory((Pointer)ptr);
        return string;
    }

    public static byte[] convertStringSidToSid(String sidString) {
        byte[] byArray;
        WinNT.PSIDByReference pSID = new WinNT.PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(sidString, pSID)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        WinNT.PSID value = byArray.getValue();
        try {
            byArray = value.getBytes();
        }
        catch (Throwable throwable) {
            WinNT.PSID pSID2;
            Kernel32Util.freeLocalMemory(pSID2.getPointer());
            throw throwable;
        }
        Kernel32Util.freeLocalMemory(value.getPointer());
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWellKnownSid(String sidString, int wellKnownSidType) {
        boolean bl;
        void var2_3;
        WinNT.PSIDByReference pSID = new WinNT.PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(sidString, pSID)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Object value = var2_3.getValue();
        try {
            bl = Advapi32.INSTANCE.IsWellKnownSid((WinNT.PSID)((Object)value), bl ? 1 : 0);
        }
        catch (Throwable throwable) {
            Object object;
            Kernel32Util.freeLocalMemory(object.getPointer());
            throw throwable;
        }
        Kernel32Util.freeLocalMemory(value.getPointer());
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWellKnownSid(byte[] sidBytes, int wellKnownSidType) {
        void var1_1;
        Object object;
        Object pSID = (Object)new WinNT.PSID(sidBytes);
        return Advapi32.INSTANCE.IsWellKnownSid((WinNT.PSID)((Object)object), (int)var1_1);
    }

    public static int alignOnDWORD(int cbAcl) {
        return cbAcl + 3 & 0xFFFFFFFC;
    }

    public static int getAceSize(int sidLength) {
        int n;
        return Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null) + n - 4;
    }

    public static Account getAccountBySid(String sidString) {
        String string;
        return Advapi32Util.getAccountBySid(null, string);
    }

    /*
     * WARNING - void declaration
     */
    public static Account getAccountBySid(String systemName, String sidString) {
        void var1_1;
        return Advapi32Util.getAccountBySid(systemName, new WinNT.PSID(Advapi32Util.convertStringSidToSid((String)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static Account[] getTokenGroups(WinNT.HANDLE hToken) {
        ArrayList arrayList;
        void var2_3;
        WinNT.SID_AND_ATTRIBUTES[] sID_AND_ATTRIBUTESArray;
        IntByReference tokenInformationLength = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(hToken, 2, null, 0, tokenInformationLength)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 122) {
            throw new Win32Exception(rc);
        }
        WinNT.TOKEN_GROUPS groups = new WinNT.TOKEN_GROUPS(tokenInformationLength.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(hToken, 2, groups, tokenInformationLength.getValue(), (IntByReference)sID_AND_ATTRIBUTESArray)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ArrayList userGroups = new ArrayList();
        for (WinNT.SID_AND_ATTRIBUTES sidAndAttribute : var2_3.getGroups()) {
            Account group;
            try {
                group = Advapi32Util.getAccountBySid(sidAndAttribute.Sid);
            }
            catch (Exception exception) {
                group = new Account();
                new Account().sid = sidAndAttribute.Sid.getBytes();
                group.name = group.sidString = Advapi32Util.convertSidToStringSid(sidAndAttribute.Sid);
                group.fqn = group.sidString;
                group.accountType = 2;
            }
            userGroups.add(group);
        }
        return arrayList.toArray(new Account[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Account getTokenPrimaryGroup(WinNT.HANDLE hToken) {
        Object object;
        Object group;
        void var1_1;
        IntByReference tokenInformationLength = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(hToken, 5, null, 0, tokenInformationLength)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 122) {
            throw new Win32Exception(rc);
        }
        WinNT.TOKEN_PRIMARY_GROUP primaryGroup = new WinNT.TOKEN_PRIMARY_GROUP(tokenInformationLength.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(hToken, 5, primaryGroup, tokenInformationLength.getValue(), (IntByReference)var1_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            group = Advapi32Util.getAccountBySid(primaryGroup.PrimaryGroup);
        }
        catch (Exception exception) {
            void var2_3;
            group = new Account();
            new Account().sid = primaryGroup.PrimaryGroup.getBytes();
            ((Account)group).name = ((Account)group).sidString = Advapi32Util.convertSidToStringSid(var2_3.PrimaryGroup);
            ((Account)group).fqn = ((Account)group).sidString;
            ((Account)group).accountType = 2;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Account getTokenAccount(WinNT.HANDLE hToken) {
        void var2_3;
        void var1_1;
        WinNT.HANDLE hANDLE;
        IntByReference tokenInformationLength = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(hToken, 1, null, 0, tokenInformationLength)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 122) {
            throw new Win32Exception(rc);
        }
        WinNT.TOKEN_USER user = new WinNT.TOKEN_USER(tokenInformationLength.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(hANDLE, 1, user, tokenInformationLength.getValue(), (IntByReference)var1_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Advapi32Util.getAccountBySid(var2_3.User.Sid);
    }

    /*
     * WARNING - void declaration
     */
    public static Account[] getCurrentUserGroups() {
        Account[] accountArray;
        WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
        Win32Exception err = null;
        try {
            WinNT.HANDLE threadHandle = Kernel32.INSTANCE.GetCurrentThread();
            if (!Advapi32.INSTANCE.OpenThreadToken(threadHandle, 10, true, phToken)) {
                int rc = Kernel32.INSTANCE.GetLastError();
                if (rc != 1008) {
                    void var2_5;
                    throw new Win32Exception((int)var2_5);
                }
                WinNT.HANDLE processHandle = Kernel32.INSTANCE.GetCurrentProcess();
                if (!Advapi32.INSTANCE.OpenProcessToken(processHandle, 10, phToken)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            accountArray = Advapi32Util.getTokenGroups(phToken.getValue());
        }
        catch (Win32Exception win32Exception) {
            try {
                Win32Exception win32Exception2 = win32Exception;
                err = win32Exception;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                block17: {
                    void e;
                    WinNT.HANDLE hToken = e.getValue();
                    if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)hToken)) {
                        try {
                            Kernel32Util.closeHandle(hToken);
                        }
                        catch (Win32Exception e2) {
                            void var0_2;
                            if (err == null) {
                                err = e2;
                                break block17;
                            }
                            err.addSuppressedReflected((Throwable)var0_2);
                        }
                    }
                }
                if (err != null) {
                    void var1_3;
                    throw var1_3;
                }
                throw throwable;
            }
        }
        WinNT.HANDLE hToken = phToken.getValue();
        if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)hToken)) {
            try {
                void var3_8;
                Kernel32Util.closeHandle((WinNT.HANDLE)var3_8);
            }
            catch (Win32Exception e) {
                if (err == null) {
                    err = e;
                }
                err.addSuppressedReflected((Throwable)((Object)e));
            }
        }
        if (err != null) {
            throw err;
        }
        return accountArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryKeyExists(WinReg.HKEY root, String key) {
        void var1_1;
        return Advapi32Util.registryKeyExists(root, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryKeyExists(WinReg.HKEY root, String key, int samDesiredExtra) {
        void var0_1;
        void var2_3;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x20019 | var2_3, phkKey);
        switch (rc) {
            case 0: {
                void var3_4;
                Advapi32.INSTANCE.RegCloseKey(var3_4.getValue());
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new Win32Exception((int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryValueExists(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryValueExists(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryValueExists(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        int n;
        void var3_6;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 0x20019 | var3_6, phkKey);
        switch (rc) {
            case 0: {
                break;
            }
            case 2: {
                return false;
            }
            default: {
                throw new Win32Exception(rc);
            }
        }
        try {
            void var0_2;
            void var1_3;
            void var2_5;
            IntByReference lpcbData = new IntByReference();
            IntByReference lpType = new IntByReference();
            n = Advapi32.INSTANCE.RegQueryValueEx(phkKey.getValue(), (String)var2_5, 0, (IntByReference)var1_3, (Pointer)null, (IntByReference)var0_2);
            switch (n) {
                case 0: 
                case 122: 
                case 234: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            throw new Win32Exception(n);
        }
        finally {
            if (phkKey.getValue() != WinBase.INVALID_HANDLE_VALUE && (n = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue())) != 0) {
                throw new Win32Exception(n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetStringValue(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetStringValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetStringValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_5;
        String string;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, string, 0, 0x20019 | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            string = Advapi32Util.registryGetStringValue(phkKey.getValue(), (String)var2_4);
            return string;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetStringValue(WinReg.HKEY hKey, String value) {
        void var2_2;
        void var3_3;
        void var1_1;
        WinReg.HKEY hKEY;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (Pointer)null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 1 && lpType.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
        }
        if (lpcbData.getValue() == 0) {
            return "";
        }
        Memory mem = new Memory((long)(lpcbData.getValue() + Native.WCHAR_SIZE));
        mem.clear();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKEY, (String)var1_1, 0, (IntByReference)var3_3, (Pointer)mem, (IntByReference)var2_2);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return mem.getWideString(0L);
        }
        return mem.getString(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetExpandableStringValue(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetExpandableStringValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetExpandableStringValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_5;
        String string;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, string, 0, 0x20019 | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            string = Advapi32Util.registryGetExpandableStringValue(phkKey.getValue(), (String)var2_4);
            return string;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String registryGetExpandableStringValue(WinReg.HKEY hKey, String value) {
        void var2_2;
        void var3_3;
        void var1_1;
        WinReg.HKEY hKEY;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (char[])null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_SZ");
        }
        if (lpcbData.getValue() == 0) {
            return "";
        }
        Memory mem = new Memory((long)(lpcbData.getValue() + Native.WCHAR_SIZE));
        mem.clear();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKEY, (String)var1_1, 0, (IntByReference)var3_3, (Pointer)mem, (IntByReference)var2_2);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return mem.getWideString(0L);
        }
        return mem.getString(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetStringArray(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetStringArray(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetStringArray(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_5;
        String[] stringArray;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)stringArray, 0, 0x20019 | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            stringArray = Advapi32Util.registryGetStringArray(phkKey.getValue(), (String)var2_4);
            return stringArray;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetStringArray(WinReg.HKEY hKey, String value) {
        ArrayList arrayList;
        void var3_4;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (char[])null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 7) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_SZ");
        }
        Memory data = new Memory((long)(lpcbData.getValue() + 2 * Native.WCHAR_SIZE));
        data.clear();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, (IntByReference)var3_4, (Pointer)data, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        ArrayList result = new ArrayList();
        int offset = 0;
        while ((long)offset < data.size()) {
            void var2_3;
            String s;
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                s = data.getWideString((long)offset);
                offset += s.length() * Native.WCHAR_SIZE;
                offset += Native.WCHAR_SIZE;
            } else {
                s = data.getString((long)offset);
                offset += s.length();
                ++offset;
            }
            if (s.length() == 0) break;
            result.add(var2_3);
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] registryGetBinaryValue(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetBinaryValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] registryGetBinaryValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_5;
        byte[] byArray;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)byArray, 0, 0x20019 | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            byArray = Advapi32Util.registryGetBinaryValue(phkKey.getValue(), (String)var2_4);
            return byArray;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] registryGetBinaryValue(WinReg.HKEY hKey, String value) {
        void var2_2;
        void var3_3;
        void var1_1;
        WinReg.HKEY hKEY;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (Pointer)null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 3) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_BINARY");
        }
        byte[] data = new byte[lpcbData.getValue()];
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKEY, (String)var1_1, 0, (IntByReference)var3_3, data, (IntByReference)var2_2);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    public static int registryGetIntValue(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetIntValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int registryGetIntValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_6;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x20019 | var3_6, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_5;
            int n = Advapi32Util.registryGetIntValue(phkKey.getValue(), (String)var2_5);
            return n;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int registryGetIntValue(WinReg.HKEY hKey, String value) {
        void var2_2;
        void var3_3;
        void var1_1;
        WinReg.HKEY hKEY;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (char[])null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 4) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_DWORD");
        }
        IntByReference data = new IntByReference();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKEY, (String)var1_1, 0, (IntByReference)var3_3, data, (IntByReference)var2_2);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        return data.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static long registryGetLongValue(WinReg.HKEY root, String key, String value) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryGetLongValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static long registryGetLongValue(WinReg.HKEY root, String key, String value, int samDesiredExtra) {
        void var3_5;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x20019 | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            long l = Advapi32Util.registryGetLongValue(phkKey.getValue(), (String)var2_4);
            return l;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long registryGetLongValue(WinReg.HKEY hKey, String value) {
        void var2_2;
        void var3_3;
        void var1_1;
        WinReg.HKEY hKEY;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryValueEx(hKey, value, 0, lpType, (char[])null, lpcbData);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 11) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_QWORD");
        }
        LongByReference data = new LongByReference();
        rc = Advapi32.INSTANCE.RegQueryValueEx(hKEY, (String)var1_1, 0, (IntByReference)var3_3, data, (IntByReference)var2_2);
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        return data.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static Object registryGetValue(WinReg.HKEY hkKey, String subKey, String lpValueName) {
        void var3_3;
        void var2_2;
        void var1_1;
        WinReg.HKEY hKEY;
        Object result = null;
        IntByReference lpType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        int rc = Advapi32.INSTANCE.RegGetValue(hkKey, subKey, lpValueName, 65535, lpType, (Pointer)null, lpcbData);
        if (lpType.getValue() == 0) {
            return null;
        }
        if (rc != 0 && rc != 122) {
            throw new Win32Exception(rc);
        }
        Memory byteData = new Memory((long)(lpcbData.getValue() + Native.WCHAR_SIZE));
        byteData.clear();
        rc = Advapi32.INSTANCE.RegGetValue(hKEY, (String)var1_1, (String)var2_2, 65535, lpType, (Pointer)byteData, lpcbData);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() == 4) {
            result = byteData.getInt(0L);
        } else if (lpType.getValue() == 11) {
            result = byteData.getLong(0L);
        } else if (lpType.getValue() == 3) {
            result = byteData.getByteArray(0L, lpcbData.getValue());
        } else if (lpType.getValue() == 1 || lpType.getValue() == 2) {
            result = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? byteData.getWideString(0L) : byteData.getString(0L);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryCreateKey(WinReg.HKEY hKey, String keyName) {
        void var1_1;
        return Advapi32Util.registryCreateKey(hKey, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryCreateKey(WinReg.HKEY hKey, String keyName, int samDesiredExtra) {
        void var3_4;
        void var2_3;
        void var1_2;
        WinReg.HKEYByReference phkResult = new WinReg.HKEYByReference();
        IntByReference lpdwDisposition = new IntByReference();
        int rc = Advapi32.INSTANCE.RegCreateKeyEx(hKey, (String)var1_2, 0, null, 0, 0x20019 | var2_3, null, phkResult, lpdwDisposition);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        rc = Advapi32.INSTANCE.RegCloseKey(var3_4.getValue());
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
        return 1 == lpdwDisposition.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryCreateKey(WinReg.HKEY root, String parentPath, String keyName) {
        void var2_2;
        void var1_1;
        return Advapi32Util.registryCreateKey(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean registryCreateKey(WinReg.HKEY root, String parentPath, String keyName, int samDesiredExtra) {
        void var3_6;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 4 | var3_6, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_5;
            boolean bl = Advapi32Util.registryCreateKey(phkKey.getValue(), (String)var2_5);
            return bl;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetIntValue(WinReg.HKEY hKey, String name, int value) {
        void var3_4;
        void var1_2;
        void var2_3;
        byte[] byArray = new byte[4];
        byte[] data = byArray;
        byArray[0] = (byte)value;
        data[1] = (byte)(value >> 8);
        data[2] = (byte)(value >> 16);
        data[3] = (byte)(var2_3 >>> 24);
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKey, (String)var1_2, 0, 4, (byte[])var3_4, 4);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetIntValue(WinReg.HKEY root, String keyPath, String name, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetIntValue(root, (String)var1_1, (String)var2_2, (int)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetIntValue(WinReg.HKEY root, String keyPath, String name, int value, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetIntValue(phkKey.getValue(), (String)var2_4, (int)var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetLongValue(WinReg.HKEY hKey, String name, long value) {
        void var1_2;
        void var2_3;
        byte[] byArray = new byte[8];
        byte[] data = byArray;
        byArray[0] = (byte)(value & 0xFFL);
        data[1] = (byte)(value >> 8 & 0xFFL);
        data[2] = (byte)(value >> 16 & 0xFFL);
        data[3] = (byte)(value >> 24 & 0xFFL);
        data[4] = (byte)(value >> 32 & 0xFFL);
        data[5] = (byte)(value >> 40 & 0xFFL);
        data[6] = (byte)(value >> 48 & 0xFFL);
        data[7] = (byte)(var2_3 >> 56 & 0xFFL);
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKey, (String)var1_2, 0, 11, data, 8);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetLongValue(WinReg.HKEY root, String keyPath, String name, long value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetLongValue(root, (String)var1_1, (String)var2_2, (long)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetLongValue(WinReg.HKEY root, String keyPath, String name, long value, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetLongValue(phkKey.getValue(), (String)var2_4, (long)var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringValue(WinReg.HKEY hKey, String name, String value) {
        void var1_2;
        void var3_4;
        Memory data;
        if (value == null) {
            value = "";
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            data = new Memory((long)((value.length() + 1) * Native.WCHAR_SIZE));
            data.setWideString(0L, value);
        } else {
            void var2_3;
            data = new Memory((long)(value.length() + 1));
            data.setString(0L, (String)var2_3);
        }
        void v0 = var3_4;
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKey, (String)var1_2, 0, 1, (Pointer)v0, (int)v0.size());
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringValue(WinReg.HKEY root, String keyPath, String name, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetStringValue(root, (String)var1_1, (String)var2_2, (String)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringValue(WinReg.HKEY root, String keyPath, String name, String value, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetStringValue(phkKey.getValue(), (String)var2_4, (String)var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetExpandableStringValue(WinReg.HKEY hKey, String name, String value) {
        void var1_2;
        void var3_4;
        Memory data;
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            data = new Memory((long)((value.length() + 1) * Native.WCHAR_SIZE));
            data.setWideString(0L, value);
        } else {
            void var2_3;
            data = new Memory((long)(value.length() + 1));
            data.setString(0L, (String)var2_3);
        }
        void v0 = var3_4;
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKey, (String)var1_2, 0, 2, (Pointer)v0, (int)v0.size());
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetExpandableStringValue(WinReg.HKEY root, String keyPath, String name, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetExpandableStringValue(root, (String)var1_1, (String)var2_2, (String)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetExpandableStringValue(WinReg.HKEY root, String keyPath, String name, String value, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetExpandableStringValue(phkKey.getValue(), (String)var2_4, (String)var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringArray(WinReg.HKEY hKey, String name, String[] arr) {
        void var1_1;
        WinReg.HKEY hKEY;
        void var2_2;
        int charwidth = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? Native.WCHAR_SIZE : 1;
        int size = 0;
        String[] stringArray = arr;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            String s = stringArray[i];
            size += s.length() * charwidth;
            size += charwidth;
        }
        int offset = 0;
        Memory data = new Memory((long)(size += charwidth));
        data.clear();
        for (void s : var2_2) {
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                data.setWideString((long)offset, (String)s);
            } else {
                data.setString((long)offset, (String)s);
            }
            offset += s.length() * charwidth;
            offset += charwidth;
        }
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKEY, (String)var1_1, 0, 7, (Pointer)data, size);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringArray(WinReg.HKEY root, String keyPath, String name, String[] arr) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetStringArray(root, (String)var1_1, (String)var2_2, (String[])var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetStringArray(WinReg.HKEY root, String keyPath, String name, String[] arr, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetStringArray(phkKey.getValue(), (String)var2_4, (String[])var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetBinaryValue(WinReg.HKEY hKey, String name, byte[] data) {
        void var1_2;
        void var2_3;
        void v0 = var2_3;
        int rc = Advapi32.INSTANCE.RegSetValueEx(hKey, (String)var1_2, 0, 3, (byte[])v0, ((void)v0).length);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetBinaryValue(WinReg.HKEY root, String keyPath, String name, byte[] data) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.registrySetBinaryValue(root, (String)var1_1, (String)var2_2, (byte[])var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registrySetBinaryValue(WinReg.HKEY root, String keyPath, String name, byte[] data, int samDesiredExtra) {
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var3_5;
            void var2_4;
            Advapi32Util.registrySetBinaryValue(phkKey.getValue(), (String)var2_4, (byte[])var3_5);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteKey(WinReg.HKEY hKey, String keyName) {
        void var1_2;
        int rc = Advapi32.INSTANCE.RegDeleteKey(hKey, (String)var1_2);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteKey(WinReg.HKEY root, String keyPath, String keyName) {
        void var2_2;
        void var1_1;
        Advapi32Util.registryDeleteKey(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteKey(WinReg.HKEY root, String keyPath, String keyName, int samDesiredExtra) {
        void var3_5;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            Advapi32Util.registryDeleteKey(phkKey.getValue(), (String)var2_4);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteValue(WinReg.HKEY hKey, String valueName) {
        void var1_2;
        int rc = Advapi32.INSTANCE.RegDeleteValue(hKey, (String)var1_2);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteValue(WinReg.HKEY root, String keyPath, String valueName) {
        void var2_2;
        void var1_1;
        Advapi32Util.registryDeleteValue(root, (String)var1_1, (String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void registryDeleteValue(WinReg.HKEY root, String keyPath, String valueName, int samDesiredExtra) {
        void var3_5;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, 0x2001F | var3_5, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var2_4;
            Advapi32Util.registryDeleteValue(phkKey.getValue(), (String)var2_4);
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetKeys(WinReg.HKEY hKey) {
        IntByReference lpcSubKeys = new IntByReference();
        IntByReference lpcMaxSubKeyLen = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryInfoKey(hKey, null, null, null, lpcSubKeys, lpcMaxSubKeyLen, null, null, null, null, null, null);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        ArrayList<String> keys = new ArrayList<String>(lpcSubKeys.getValue());
        char[] name = new char[lpcMaxSubKeyLen.getValue() + 1];
        for (int i = 0; i < lpcSubKeys.getValue(); ++i) {
            void var3_4;
            IntByReference lpcchValueName = new IntByReference(lpcMaxSubKeyLen.getValue() + 1);
            int n = Advapi32.INSTANCE.RegEnumKeyEx(hKey, i, name, (IntByReference)var3_4, null, null, null, null);
            if (n != 0) {
                throw new Win32Exception(n);
            }
            keys.add(Native.toString((char[])name));
        }
        return keys.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetKeys(WinReg.HKEY root, String keyPath) {
        void var1_1;
        return Advapi32Util.registryGetKeys(root, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] registryGetKeys(WinReg.HKEY root, String keyPath, int samDesiredExtra) {
        void var2_4;
        String[] stringArray;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)stringArray, 0, 0x20019 | var2_4, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            stringArray = Advapi32Util.registryGetKeys(phkKey.getValue());
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            void var3_5;
            rc = Advapi32.INSTANCE.RegCloseKey(var3_5.getValue());
            if (rc != 0) {
                void var0_1;
                throw new Win32Exception((int)var0_1);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static WinReg.HKEYByReference registryGetKey(WinReg.HKEY root, String keyPath, int samDesired) {
        void var3_4;
        void var2_3;
        void var1_2;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)var1_2, 0, (int)var2_3, phkKey);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static void registryCloseKey(WinReg.HKEY hKey) {
        int rc = Advapi32.INSTANCE.RegCloseKey(hKey);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static TreeMap<String, Object> registryGetValues(WinReg.HKEY hKey) {
        IntByReference lpcValues = new IntByReference();
        IntByReference lpcMaxValueNameLen = new IntByReference();
        IntByReference lpcMaxValueLen = new IntByReference();
        int rc = Advapi32.INSTANCE.RegQueryInfoKey(hKey, null, null, null, null, null, null, lpcValues, lpcMaxValueNameLen, lpcMaxValueLen, null, null);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        TreeMap<String, Object> keyValues = new TreeMap<String, Object>();
        char[] name = new char[lpcMaxValueNameLen.getValue() + 1];
        Memory byteData = new Memory((long)(lpcMaxValueLen.getValue() + 2 * Native.WCHAR_SIZE));
        block13: for (int i = 0; i < lpcValues.getValue(); ++i) {
            byteData.clear();
            IntByReference lpcchValueName22 = new IntByReference(lpcMaxValueNameLen.getValue() + 1);
            IntByReference lpcbData = new IntByReference(lpcMaxValueLen.getValue());
            IntByReference lpType = new IntByReference();
            int lpcchValueName22 = Advapi32.INSTANCE.RegEnumValue(hKey, i, name, lpcchValueName22, null, lpType, (Pointer)byteData, lpcbData);
            if (lpcchValueName22 != 0) {
                throw new Win32Exception(lpcchValueName22);
            }
            String nameString = Native.toString((char[])name);
            if (lpcbData.getValue() == 0) {
                switch (lpType.getValue()) {
                    case 3: {
                        keyValues.put(nameString, new byte[0]);
                        continue block13;
                    }
                    case 1: 
                    case 2: {
                        keyValues.put(nameString, new char[0]);
                        continue block13;
                    }
                    case 7: {
                        keyValues.put(nameString, new String[0]);
                        continue block13;
                    }
                    case 0: {
                        keyValues.put(nameString, null);
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("Unsupported empty type: " + lpType.getValue());
                    }
                }
            }
            switch (lpType.getValue()) {
                case 11: {
                    keyValues.put(nameString, byteData.getLong(0L));
                    continue block13;
                }
                case 4: {
                    keyValues.put(nameString, byteData.getInt(0L));
                    continue block13;
                }
                case 1: 
                case 2: {
                    if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                        keyValues.put(nameString, byteData.getWideString(0L));
                        continue block13;
                    }
                    keyValues.put(nameString, byteData.getString(0L));
                    continue block13;
                }
                case 3: {
                    keyValues.put(nameString, byteData.getByteArray(0L, lpcbData.getValue()));
                    continue block13;
                }
                case 7: {
                    ArrayList<String> result = new ArrayList<String>();
                    int offset = 0;
                    while ((long)offset < byteData.size()) {
                        String s;
                        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                            s = byteData.getWideString((long)offset);
                            offset += s.length() * Native.WCHAR_SIZE;
                            offset += Native.WCHAR_SIZE;
                        } else {
                            s = byteData.getString((long)offset);
                            offset += s.length();
                            ++offset;
                        }
                        if (s.length() == 0) break;
                        result.add(s);
                    }
                    keyValues.put(nameString, result.toArray(new String[0]));
                    continue block13;
                }
                default: {
                    void var10_13;
                    throw new RuntimeException("Unsupported type: " + var10_13.getValue());
                }
            }
        }
        return keyValues;
    }

    /*
     * WARNING - void declaration
     */
    public static TreeMap<String, Object> registryGetValues(WinReg.HKEY root, String keyPath) {
        void var1_1;
        return Advapi32Util.registryGetValues(root, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static TreeMap<String, Object> registryGetValues(WinReg.HKEY root, String keyPath, int samDesiredExtra) {
        void var2_4;
        TreeMap<String, Object> treeMap;
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, (String)((Object)treeMap), 0, 0x20019 | var2_4, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            treeMap = Advapi32Util.registryGetValues(phkKey.getValue());
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            return treeMap;
        }
        catch (Throwable throwable) {
            void var3_5;
            rc = Advapi32.INSTANCE.RegCloseKey(var3_5.getValue());
            if (rc != 0) {
                void var0_1;
                throw new Win32Exception((int)var0_1);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InfoKey registryQueryInfoKey(WinReg.HKEY hKey, int lpcbSecurityDescriptor) {
        void var1_3;
        InfoKey infoKey = new InfoKey(hKey, lpcbSecurityDescriptor);
        int rc = Advapi32.INSTANCE.RegQueryInfoKey(hKey, infoKey.lpClass, infoKey.lpcClass, null, infoKey.lpcSubKeys, infoKey.lpcMaxSubKeyLen, infoKey.lpcMaxClassLen, infoKey.lpcValues, infoKey.lpcMaxValueNameLen, infoKey.lpcMaxValueLen, infoKey.lpcbSecurityDescriptor, infoKey.lpftLastWriteTime);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static EnumKey registryRegEnumKey(WinReg.HKEY hKey, int dwIndex) {
        void var1_3;
        EnumKey enumKey = new EnumKey(hKey, dwIndex);
        int rc = Advapi32.INSTANCE.RegEnumKeyEx(hKey, enumKey.dwIndex, enumKey.lpName, enumKey.lpcName, null, enumKey.lpClass, enumKey.lpcbClass, enumKey.lpftLastWriteTime);
        if (rc != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String getEnvironmentBlock(Map<String, String> environment) {
        void var1_1;
        Object object;
        StringBuilder out = new StringBuilder(environment.size() << 5);
        for (Map.Entry entry : object.entrySet()) {
            void var3_4;
            String key = (String)entry.getKey();
            String string = (String)entry.getValue();
            if (string == null) continue;
            out.append((String)var3_4).append("=").append(string).append('\u0000');
        }
        return var1_1.append('\u0000').toString();
    }

    /*
     * WARNING - void declaration
     */
    public static WinNT.ACE_HEADER[] getFileSecurity(String fileName, boolean compact) {
        void var6_11;
        Object lpnSize;
        Memory memory;
        int n;
        int nLength = 1024;
        do {
            int lengthNeeded;
            boolean repeat = false;
            memory = new Memory((long)nLength);
            lpnSize = new IntByReference();
            boolean bl = Advapi32.INSTANCE.GetFileSecurity(fileName, 4, (Pointer)memory, nLength, (IntByReference)lpnSize);
            if (!bl) {
                int lastError = Kernel32.INSTANCE.GetLastError();
                memory.clear();
                if (122 != lastError) {
                    throw new Win32Exception(lastError);
                }
            }
            if (nLength >= (lengthNeeded = lpnSize.getValue())) continue;
            repeat = true;
            nLength = lengthNeeded;
            memory.clear();
        } while (n != false);
        lpnSize = new WinNT.SECURITY_DESCRIPTOR_RELATIVE((Pointer)memory);
        WinNT.ACL lengthNeeded = lpnSize.getDiscretionaryACL();
        WinNT.ACE_HEADER[] aceStructures = lengthNeeded.getACEs();
        if (compact) {
            ArrayList arrayList;
            ArrayList result = new ArrayList();
            HashMap<void, WinNT.ACCESS_ACEStructure> aceMap = new HashMap<void, WinNT.ACCESS_ACEStructure>();
            WinNT.ACE_HEADER[] aCE_HEADERArray = aceStructures;
            n = aceStructures.length;
            for (int i = 0; i < n; ++i) {
                void var5_8;
                WinNT.ACE_HEADER aceStructure = aCE_HEADERArray[i];
                if (aceStructure instanceof WinNT.ACCESS_ACEStructure) {
                    WinNT.ACCESS_ACEStructure accessACEStructure = (WinNT.ACCESS_ACEStructure)aceStructure;
                    boolean inherted = (aceStructure.AceFlags & 0x1F) != 0;
                    String key2 = accessACEStructure.getSidString() + "/" + inherted + "/" + ((Object)((Object)aceStructure)).getClass().getName();
                    WinNT.ACCESS_ACEStructure aceStructure2 = (WinNT.ACCESS_ACEStructure)((Object)aceMap.get(key2));
                    if (aceStructure2 != null) {
                        int accessMask;
                        int key2 = aceStructure2.Mask;
                        aceStructure2.Mask = accessMask = key2 | accessACEStructure.Mask;
                        continue;
                    }
                    aceMap.put(var5_8, accessACEStructure);
                    result.add(aceStructure2);
                    continue;
                }
                result.add(var5_8);
            }
            return arrayList.toArray(new WinNT.ACE_HEADER[0]);
        }
        return var6_11;
    }

    /*
     * WARNING - void declaration
     */
    private static Memory getSecurityDescriptorForFile(String absoluteFilePath) {
        void var3_3;
        void var1_1;
        String string;
        int lastError;
        IntByReference lpnSize = new IntByReference();
        int n = Advapi32.INSTANCE.GetFileSecurity(absoluteFilePath, 7, null, 0, lpnSize) ? 1 : 0;
        if (n == 0 && 122 != (lastError = Kernel32.INSTANCE.GetLastError())) {
            throw new Win32Exception(lastError);
        }
        int nLength = lpnSize.getValue();
        Memory securityDescriptorMemoryPointer = new Memory((long)nLength);
        boolean bl = Advapi32.INSTANCE.GetFileSecurity(string, 7, (Pointer)securityDescriptorMemoryPointer, n, (IntByReference)var1_1);
        n = bl ? 1 : 0;
        if (!bl) {
            securityDescriptorMemoryPointer.clear();
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory getSecurityDescriptorForObject(String absoluteObjectPath, int objectType, boolean getSACL) {
        void var0_2;
        PointerByReference ppSecurityDescriptor;
        int infoType = 7 | (getSACL ? 8 : 0);
        int lastError = Advapi32.INSTANCE.GetNamedSecurityInfo(absoluteObjectPath, objectType, infoType, null, null, null, null, ppSecurityDescriptor = new PointerByReference());
        if (lastError != 0) {
            throw new Win32Exception(lastError);
        }
        int nLength = Advapi32.INSTANCE.GetSecurityDescriptorLength(ppSecurityDescriptor.getValue());
        Memory memory = new Memory((long)nLength);
        Pointer secValue = ppSecurityDescriptor.getValue();
        try {
            void var1_5;
            void var0_1;
            void var3_8;
            byte[] data = secValue.getByteArray(0L, nLength);
            memory.write(0L, (byte[])var3_8, 0, (int)var0_1);
            var0_2 = var1_5;
        }
        catch (Throwable throwable) {
            void var2_7;
            Kernel32Util.freeLocalMemory((Pointer)var2_7);
            throw throwable;
        }
        Kernel32Util.freeLocalMemory(secValue);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     */
    public static void setSecurityDescriptorForObject(String absoluteObjectPath, int objectType, WinNT.SECURITY_DESCRIPTOR_RELATIVE securityDescriptor, boolean setOwner, boolean setGroup, boolean setDACL, boolean setSACL, boolean setDACLProtectedStatus, boolean setSACLProtectedStatus) {
        void var3_4;
        void var1_2;
        int lastError;
        WinNT.PSID psidOwner = securityDescriptor.getOwner();
        WinNT.PSID psidGroup = securityDescriptor.getGroup();
        WinNT.ACL dacl = securityDescriptor.getDiscretionaryACL();
        WinNT.ACL sacl = securityDescriptor.getSystemACL();
        int infoType = 0;
        if (setOwner) {
            if (psidOwner == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain owner");
            }
            if (!Advapi32.INSTANCE.IsValidSid(psidOwner)) {
                throw new IllegalArgumentException("Owner PSID is invalid");
            }
            infoType = 1;
        }
        if (setGroup) {
            if (psidGroup == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain group");
            }
            if (!Advapi32.INSTANCE.IsValidSid(psidGroup)) {
                throw new IllegalArgumentException("Group PSID is invalid");
            }
            infoType |= 2;
        }
        if (setDACL) {
            if (dacl == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain DACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(dacl.getPointer())) {
                throw new IllegalArgumentException("DACL is invalid");
            }
            infoType |= 4;
        }
        if (setSACL) {
            if (sacl == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain SACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(sacl.getPointer())) {
                throw new IllegalArgumentException("SACL is invalid");
            }
            infoType |= 8;
        }
        if (setDACLProtectedStatus) {
            if ((securityDescriptor.Control & 0x1000) != 0) {
                infoType |= Integer.MIN_VALUE;
            } else if ((securityDescriptor.Control & 0x1000) == 0) {
                infoType |= 0x20000000;
            }
        }
        if (setSACLProtectedStatus) {
            void var2_3;
            if ((securityDescriptor.Control & 0x2000) != 0) {
                infoType |= 0x40000000;
            } else if ((var2_3.Control & 0x2000) == 0) {
                infoType |= 0x10000000;
            }
        }
        if ((lastError = Advapi32.INSTANCE.SetNamedSecurityInfo(absoluteObjectPath, (int)var1_2, infoType, var3_4 != false ? psidOwner.getPointer() : null, setGroup ? psidGroup.getPointer() : null, setDACL ? dacl.getPointer() : null, setSACL ? sacl.getPointer() : null)) != 0) {
            void var0_1;
            throw new Win32Exception((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean accessCheck(File file, AccessCheckPermission permissionToCheck) {
        boolean bl;
        Win32Exception win32Exception;
        File securityDescriptorMemoryPointer = Advapi32Util.getSecurityDescriptorForFile(file.getAbsolutePath().replace('/', '\\'));
        WinNT.HANDLEByReference openedAccessToken = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference duplicatedToken = new WinNT.HANDLEByReference();
        Win32Exception err = null;
        try {
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.GetCurrentProcess();
            if (!Advapi32.INSTANCE.OpenProcessToken(hProcess, 131086, openedAccessToken)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            if (!Advapi32.INSTANCE.DuplicateToken(openedAccessToken.getValue(), 2, duplicatedToken)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            WinNT.GENERIC_MAPPING mapping = new WinNT.GENERIC_MAPPING();
            new WinNT.GENERIC_MAPPING().genericRead = new WinDef.DWORD(1179785L);
            mapping.genericWrite = new WinDef.DWORD(1179926L);
            mapping.genericExecute = new WinDef.DWORD(1179808L);
            mapping.genericAll = new WinDef.DWORD(0x1F01FFL);
            WinDef.DWORDByReference rights = new WinDef.DWORDByReference(new WinDef.DWORD(permissionToCheck.getCode()));
            Advapi32.INSTANCE.MapGenericMask(rights, mapping);
            WinNT.PRIVILEGE_SET privileges = new WinNT.PRIVILEGE_SET(1);
            new WinNT.PRIVILEGE_SET(1).PrivilegeCount = new WinDef.DWORD(0L);
            WinDef.DWORDByReference privilegeLength = new WinDef.DWORDByReference(new WinDef.DWORD(privileges.size()));
            WinDef.DWORDByReference grantedAccess = new WinDef.DWORDByReference();
            WinDef.BOOLByReference result = new WinDef.BOOLByReference();
            if (!Advapi32.INSTANCE.AccessCheck((Pointer)securityDescriptorMemoryPointer, duplicatedToken.getValue(), ((WinDef.DWORDByReference)((Object)win32Exception)).getValue(), mapping, privileges, privilegeLength, grantedAccess, result)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            bl = result.getValue().booleanValue();
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                err = win32Exception2;
                throw win32Exception2;
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        void var3_7;
                        void e;
                        Kernel32Util.closeHandleRefs(new WinNT.HANDLEByReference[]{e, var3_7});
                    }
                    catch (Win32Exception e) {
                        void var2_6;
                        if (err == null) {
                            err = e;
                            break block17;
                        }
                        err.addSuppressedReflected((Throwable)var2_6);
                    }
                }
                if (securityDescriptorMemoryPointer != null) {
                    File file2;
                    file2.clear();
                }
                if (err != null) {
                    throw err;
                }
                throw throwable;
            }
        }
        try {
            Kernel32Util.closeHandleRefs(openedAccessToken, duplicatedToken);
        }
        catch (Win32Exception e) {
            if (err == null) {
                err = e;
            }
            err.addSuppressedReflected((Throwable)((Object)e));
        }
        if (securityDescriptorMemoryPointer != null) {
            securityDescriptorMemoryPointer.clear();
        }
        if (err != null) {
            throw err;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static WinNT.SECURITY_DESCRIPTOR_RELATIVE getFileSecurityDescriptor(File file, boolean getSACL) {
        Object object;
        void var1_1;
        Object securityDesc = Advapi32Util.getSecurityDescriptorForObject(file.getAbsolutePath().replaceAll("/", "\\"), 1, (boolean)var1_1);
        object = new WinNT.SECURITY_DESCRIPTOR_RELATIVE((Pointer)object);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static void setFileSecurityDescriptor(File file, WinNT.SECURITY_DESCRIPTOR_RELATIVE securityDescriptor, boolean setOwner, boolean setGroup, boolean setDACL, boolean setSACL, boolean setDACLProtectedStatus, boolean setSACLProtectedStatus) {
        void var3_3;
        void var2_2;
        void var1_1;
        Advapi32Util.setSecurityDescriptorForObject(file.getAbsolutePath().replaceAll("/", "\\"), 1, (WinNT.SECURITY_DESCRIPTOR_RELATIVE)var1_1, (boolean)var2_2, (boolean)var3_3, setDACL, setSACL, setDACLProtectedStatus, setSACLProtectedStatus);
    }

    public static void encryptFile(File file) {
        String string;
        String lpFileName = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.EncryptFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void decryptFile(File file) {
        String string;
        String lpFileName = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.DecryptFile(string, new WinDef.DWORD(0L))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int fileEncryptionStatus(File file) {
        void var1_1;
        String string;
        WinDef.DWORDByReference status = new WinDef.DWORDByReference();
        String lpFileName = file.getAbsolutePath();
        if (!Advapi32.INSTANCE.FileEncryptionStatus(string, status)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return var1_1.getValue().intValue();
    }

    /*
     * WARNING - void declaration
     */
    public static void disableEncryption(File directory, boolean disable) {
        void var1_1;
        String string;
        String dirPath = directory.getAbsolutePath();
        if (!Advapi32.INSTANCE.EncryptionDisable(string, (boolean)var1_1)) {
            throw new Win32Exception(Native.getLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void backupEncryptedFile(File src, File destDir) {
        String string;
        void var2_3;
        void var3_4;
        void var1_2;
        PointerByReference pvContext;
        String srcFileName;
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("destDir must be a directory.");
        }
        WinDef.ULONG readFlag = new WinDef.ULONG(0L);
        WinDef.ULONG writeFlag = new WinDef.ULONG(1L);
        if (src.isDirectory()) {
            writeFlag.setValue(3L);
        }
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw(srcFileName = src.getAbsolutePath(), readFlag, pvContext = new PointerByReference()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WinBase.FE_EXPORT_FUNC pfExportCallback = new WinBase.FE_EXPORT_FUNC(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final WinDef.DWORD callback(Pointer pbData, Pointer pvCallbackContext, WinDef.ULONG ulLength) {
                void var3_4;
                byte[] arr = pbData.getByteArray(0L, var3_4.intValue());
                try {
                    outputStream.write(arr);
                }
                catch (IOException e) {
                    void var1_2;
                    throw new RuntimeException((Throwable)var1_2);
                }
                return new WinDef.DWORD(0L);
            }
        };
        if (Advapi32.INSTANCE.ReadEncryptedFileRaw(pfExportCallback, null, pvContext.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pvContext.getValue());
        String destFileName = var1_2.getAbsolutePath() + File.separator + ((File)((Object)e)).getName();
        pvContext = new PointerByReference();
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw(destFileName, (WinDef.ULONG)var3_4, pvContext) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        String elementsReadWrapper = new IntByReference(0);
        String pfImportCallback = new WinBase.FE_IMPORT_FUNC((IntByReference)elementsReadWrapper, (ByteArrayOutputStream)var2_3){
            final /* synthetic */ IntByReference val$elementsReadWrapper;
            final /* synthetic */ ByteArrayOutputStream val$outputStream;
            {
                this.val$elementsReadWrapper = intByReference;
                this.val$outputStream = byteArrayOutputStream;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WinDef.DWORD callback(Pointer pbData, Pointer pvCallbackContext, WinDef.ULONGByReference ulLength) {
                void var3_4;
                void var2_3;
                void var1_1;
                int elementsRead = this.val$elementsReadWrapper.getValue();
                int n = this.val$outputStream.size() - elementsRead;
                int length = Math.min(n, ulLength.getValue().intValue());
                var1_1.write(0L, this.val$outputStream.toByteArray(), elementsRead, length);
                this.val$elementsReadWrapper.setValue((int)(var2_3 + length));
                var3_4.setValue(new WinDef.ULONG(length));
                return new WinDef.DWORD(0L);
            }
        };
        if (Advapi32.INSTANCE.WriteEncryptedFileRaw((WinBase.FE_IMPORT_FUNC)((Object)string), null, pvContext.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pvContext.getValue());
    }

    public static class Privilege
    implements Closeable {
        private boolean currentlyImpersonating = false;
        private boolean privilegesEnabled = false;
        private final WinNT.LUID[] pLuids;

        public Privilege(String ... privileges) throws IllegalArgumentException, Win32Exception {
            this.pLuids = new WinNT.LUID[privileges.length];
            int i = 0;
            String[] stringArray = privileges;
            int n = privileges.length;
            for (int j = 0; j < n; ++j) {
                String p = stringArray[j];
                this.pLuids[i] = new WinNT.LUID();
                if (!Advapi32.INSTANCE.LookupPrivilegeValue(null, p, this.pLuids[i])) {
                    throw new IllegalArgumentException("Failed to find privilege \"" + privileges[i] + "\" - " + Kernel32.INSTANCE.GetLastError());
                }
                ++i;
            }
        }

        @Override
        public void close() {
            this.disable();
        }

        /*
         * WARNING - void declaration
         */
        public Privilege enable() throws Win32Exception {
            block12: {
                if (this.privilegesEnabled) {
                    return this;
                }
                WinNT.HANDLEByReference phThreadToken = new WinNT.HANDLEByReference();
                try {
                    phThreadToken.setValue(this.getThreadToken());
                    WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(this.pLuids.length);
                    for (int i = 0; i < this.pLuids.length; ++i) {
                        tp.Privileges[i] = new WinNT.LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef.DWORD(2L));
                    }
                    if (!Advapi32.INSTANCE.AdjustTokenPrivileges(phThreadToken.getValue(), false, tp, 0, null, null)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    this.privilegesEnabled = true;
                    if (phThreadToken.getValue() == WinBase.INVALID_HANDLE_VALUE || phThreadToken.getValue() == null) break block12;
                    Kernel32.INSTANCE.CloseHandle(phThreadToken.getValue());
                }
                catch (Win32Exception ex) {
                    try {
                        void var2_3;
                        if (this.currentlyImpersonating) {
                            Advapi32.INSTANCE.SetThreadToken(null, null);
                            this.currentlyImpersonating = false;
                        } else if (this.privilegesEnabled) {
                            void var3_6;
                            WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(this.pLuids.length);
                            for (int i = 0; i < this.pLuids.length; ++i) {
                                tp.Privileges[i] = new WinNT.LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef.DWORD(0L));
                            }
                            Advapi32.INSTANCE.AdjustTokenPrivileges(phThreadToken.getValue(), false, (WinNT.TOKEN_PRIVILEGES)var3_6, 0, null, null);
                            this.privilegesEnabled = false;
                        }
                        throw var2_3;
                    }
                    catch (Throwable throwable) {
                        if (phThreadToken.getValue() != WinBase.INVALID_HANDLE_VALUE && phThreadToken.getValue() != null) {
                            void var1_1;
                            Kernel32.INSTANCE.CloseHandle(phThreadToken.getValue());
                            var1_1.setValue(null);
                        }
                        throw throwable;
                    }
                }
                phThreadToken.setValue(null);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public void disable() throws Win32Exception {
            block7: {
                WinNT.HANDLEByReference phThreadToken = new WinNT.HANDLEByReference();
                try {
                    phThreadToken.setValue(this.getThreadToken());
                    if (this.currentlyImpersonating) {
                        Advapi32.INSTANCE.SetThreadToken(null, null);
                    } else if (this.privilegesEnabled) {
                        void var2_2;
                        WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(this.pLuids.length);
                        for (int i = 0; i < this.pLuids.length; ++i) {
                            tp.Privileges[i] = new WinNT.LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef.DWORD(0L));
                        }
                        Advapi32.INSTANCE.AdjustTokenPrivileges(phThreadToken.getValue(), false, (WinNT.TOKEN_PRIVILEGES)var2_2, 0, null, null);
                        this.privilegesEnabled = false;
                    }
                    if (phThreadToken.getValue() == WinBase.INVALID_HANDLE_VALUE || phThreadToken.getValue() == null) break block7;
                    Kernel32.INSTANCE.CloseHandle(phThreadToken.getValue());
                }
                catch (Throwable throwable) {
                    if (phThreadToken.getValue() != WinBase.INVALID_HANDLE_VALUE && phThreadToken.getValue() != null) {
                        void var1_1;
                        Kernel32.INSTANCE.CloseHandle(phThreadToken.getValue());
                        var1_1.setValue(null);
                    }
                    throw throwable;
                }
                phThreadToken.setValue(null);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private WinNT.HANDLE getThreadToken() throws Win32Exception {
            void var1_1;
            block11: {
                WinNT.HANDLEByReference phThreadToken2 = new WinNT.HANDLEByReference();
                WinNT.HANDLEByReference phProcessToken = new WinNT.HANDLEByReference();
                try {
                    if (!Advapi32.INSTANCE.OpenThreadToken(Kernel32.INSTANCE.GetCurrentThread(), 32, false, phThreadToken2)) {
                        int lastError = Kernel32.INSTANCE.GetLastError();
                        if (1008 != lastError) {
                            throw new Win32Exception(lastError);
                        }
                        if (!Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 2, phProcessToken)) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        if (!Advapi32.INSTANCE.DuplicateTokenEx(phProcessToken.getValue(), 36, null, 2, 2, phThreadToken2)) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        if (!Advapi32.INSTANCE.SetThreadToken(null, phThreadToken2.getValue())) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        this.currentlyImpersonating = true;
                    }
                    if (phProcessToken.getValue() == WinBase.INVALID_HANDLE_VALUE || phProcessToken.getValue() == null) break block11;
                    Kernel32.INSTANCE.CloseHandle(phProcessToken.getValue());
                }
                catch (Win32Exception ex) {
                    try {
                        void var3_5;
                        if (phThreadToken2.getValue() != WinBase.INVALID_HANDLE_VALUE && phThreadToken2.getValue() != null) {
                            Kernel32.INSTANCE.CloseHandle(phThreadToken2.getValue());
                            phThreadToken2.setValue(null);
                        }
                        throw var3_5;
                    }
                    catch (Throwable phThreadToken2) {
                        if (phProcessToken.getValue() != WinBase.INVALID_HANDLE_VALUE && phProcessToken.getValue() != null) {
                            void var2_3;
                            Kernel32.INSTANCE.CloseHandle(phProcessToken.getValue());
                            var2_3.setValue(null);
                        }
                        throw phThreadToken2;
                    }
                }
                phProcessToken.setValue(null);
            }
            return var1_1.getValue();
        }
    }

    public static enum AccessCheckPermission {
        READ(Integer.MIN_VALUE),
        WRITE(0x40000000),
        EXECUTE(0x20000000);

        final int code;

        /*
         * WARNING - void declaration
         */
        private AccessCheckPermission(int code) {
            void var3_3;
            this.code = var3_3;
        }

        public final int getCode() {
            return this.code;
        }
    }

    public static class EventLogIterator
    implements Iterable<EventLogRecord>,
    Iterator<EventLogRecord> {
        private WinNT.HANDLE _h;
        private Memory _buffer = new Memory(65536L);
        private boolean _done = false;
        private int _dwRead = 0;
        private Pointer _pevlr = null;
        private int _flags;

        /*
         * WARNING - void declaration
         */
        public EventLogIterator(String sourceName) {
            this(null, (String)var1_1, 4);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public EventLogIterator(String serverName, String sourceName, int flags) {
            void var2_2;
            void var1_1;
            void var3_3;
            this._flags = var3_3;
            this._h = Advapi32.INSTANCE.OpenEventLog((String)var1_1, (String)var2_2);
            if (this._h == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean read() {
            void var1_1;
            if (this._done || this._dwRead > 0) {
                return false;
            }
            IntByReference pnBytesRead = new IntByReference();
            IntByReference pnMinNumberOfBytesNeeded = new IntByReference();
            if (!Advapi32.INSTANCE.ReadEventLog(this._h, 1 | this._flags, 0, (Pointer)this._buffer, (int)this._buffer.size(), pnBytesRead, pnMinNumberOfBytesNeeded)) {
                int rc = Kernel32.INSTANCE.GetLastError();
                if (rc == 122) {
                    void var2_2;
                    this._buffer = new Memory((long)pnMinNumberOfBytesNeeded.getValue());
                    if (!Advapi32.INSTANCE.ReadEventLog(this._h, 1 | this._flags, 0, (Pointer)this._buffer, (int)this._buffer.size(), pnBytesRead, (IntByReference)var2_2)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                } else {
                    this.close();
                    if (rc != 38) {
                        void var3_3;
                        throw new Win32Exception((int)var3_3);
                    }
                    return false;
                }
            }
            this._dwRead = var1_1.getValue();
            this._pevlr = this._buffer;
            return true;
        }

        public void close() {
            this._done = true;
            if (this._h != null) {
                if (!Advapi32.INSTANCE.CloseEventLog(this._h)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                this._h = null;
            }
        }

        @Override
        public Iterator<EventLogRecord> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.read();
            return !this._done;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EventLogRecord next() {
            void var1_1;
            this.read();
            EventLogRecord record = new EventLogRecord(this._pevlr);
            this._dwRead -= record.getLength();
            this._pevlr = this._pevlr.share((long)record.getLength());
            return var1_1;
        }

        @Override
        public void remove() {
        }
    }

    public static class EventLogRecord {
        private WinNT.EVENTLOGRECORD _record;
        private String _source;
        private byte[] _data;
        private String[] _strings;

        public WinNT.EVENTLOGRECORD getRecord() {
            return this._record;
        }

        public int getInstanceId() {
            return this._record.EventID.intValue();
        }

        @Deprecated
        public int getEventId() {
            return this._record.EventID.intValue();
        }

        public String getSource() {
            return this._source;
        }

        public int getStatusCode() {
            return this._record.EventID.intValue() & 0xFFFF;
        }

        public int getRecordNumber() {
            return this._record.RecordNumber.intValue();
        }

        public int getLength() {
            return this._record.Length.intValue();
        }

        public String[] getStrings() {
            return this._strings;
        }

        public EventLogType getType() {
            switch (this._record.EventType.intValue()) {
                case 0: 
                case 4: {
                    return EventLogType.Informational;
                }
                case 16: {
                    return EventLogType.AuditFailure;
                }
                case 8: {
                    return EventLogType.AuditSuccess;
                }
                case 1: {
                    return EventLogType.Error;
                }
                case 2: {
                    return EventLogType.Warning;
                }
            }
            throw new RuntimeException("Invalid type: " + this._record.EventType.intValue());
        }

        public byte[] getData() {
            return this._data;
        }

        /*
         * WARNING - void declaration
         */
        public EventLogRecord(Pointer pevlr) {
            this._record = new WinNT.EVENTLOGRECORD(pevlr);
            this._source = pevlr.getWideString((long)this._record.size());
            if (this._record.DataLength.intValue() > 0) {
                this._data = pevlr.getByteArray((long)this._record.DataOffset.intValue(), this._record.DataLength.intValue());
            }
            if (this._record.NumStrings.intValue() > 0) {
                void var2_2;
                ArrayList<String> strings = new ArrayList<String>();
                long offset = this._record.StringOffset.intValue();
                for (int count = this._record.NumStrings.intValue(); count > 0; --count) {
                    String s = pevlr.getWideString(offset);
                    strings.add(s);
                    offset += (long)(s.length() * Native.WCHAR_SIZE);
                    offset += (long)Native.WCHAR_SIZE;
                }
                this._strings = var2_2.toArray(new String[0]);
            }
        }
    }

    public static enum EventLogType {
        Error,
        Warning,
        Informational,
        AuditSuccess,
        AuditFailure;

    }

    public static class EnumKey {
        public WinReg.HKEY hKey;
        public int dwIndex = 0;
        public char[] lpName = new char[255];
        public IntByReference lpcName = new IntByReference(255);
        public char[] lpClass = new char[255];
        public IntByReference lpcbClass = new IntByReference(255);
        public WinBase.FILETIME lpftLastWriteTime = new WinBase.FILETIME();

        public EnumKey() {
        }

        /*
         * WARNING - void declaration
         */
        public EnumKey(WinReg.HKEY hKey, int dwIndex) {
            void var2_2;
            void var1_1;
            this.hKey = var1_1;
            this.dwIndex = var2_2;
        }
    }

    public static class InfoKey {
        public WinReg.HKEY hKey;
        public char[] lpClass = new char[260];
        public IntByReference lpcClass = new IntByReference(260);
        public IntByReference lpcSubKeys = new IntByReference();
        public IntByReference lpcMaxSubKeyLen = new IntByReference();
        public IntByReference lpcMaxClassLen = new IntByReference();
        public IntByReference lpcValues = new IntByReference();
        public IntByReference lpcMaxValueNameLen = new IntByReference();
        public IntByReference lpcMaxValueLen = new IntByReference();
        public IntByReference lpcbSecurityDescriptor = new IntByReference();
        public WinBase.FILETIME lpftLastWriteTime = new WinBase.FILETIME();

        public InfoKey() {
        }

        /*
         * WARNING - void declaration
         */
        public InfoKey(WinReg.HKEY hKey, int securityDescriptor) {
            void var2_2;
            void var1_1;
            this.hKey = var1_1;
            this.lpcbSecurityDescriptor = new IntByReference((int)var2_2);
        }
    }

    public static class Account {
        public String name;
        public String domain;
        public byte[] sid;
        public String sidString;
        public int accountType;
        public String fqn;
    }
}

