/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.tlb.imp.TlbConst;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbParameterNotFoundException;
import java.util.Hashtable;

public class TlbCmdlineArgs
extends Hashtable<String, String>
implements TlbConst {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    public TlbCmdlineArgs(String[] args) {
        void var1_1;
        this.readCmdArgs((String[])var1_1);
    }

    public int getIntParam(String key) {
        String string;
        string = this.getRequiredParam(string);
        return Integer.parseInt(string);
    }

    /*
     * WARNING - void declaration
     */
    public String getParam(String key) {
        void var1_1;
        return (String)this.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getRequiredParam(String key) {
        void var2_2;
        String param = this.getParam(key);
        if (param == null) {
            void var1_1;
            throw new TlbParameterNotFoundException("Commandline parameter not found: " + (String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void readCmdArgs(String[] args) {
        if (args.length < 2) {
            this.showCmdHelp();
        }
        for (int i = 0; i < args.length; i += 2) {
            String cmdName = args[i];
            String cmdValue = args[i + 1];
            if (cmdName.startsWith("-") && !cmdValue.startsWith("-")) {
                void var3_3;
                this.put(var3_3.substring(1), cmdValue);
                continue;
            }
            this.showCmdHelp();
            return;
        }
    }

    public boolean isTlbFile() {
        return this.containsKey("tlb.file");
    }

    public boolean isTlbId() {
        return this.containsKey("tlb.id");
    }

    public String getBindingMode() {
        if (this.containsKey("bind.mode")) {
            return this.getParam("bind.mode");
        }
        return "vtable";
    }

    /*
     * WARNING - void declaration
     */
    public void showCmdHelp() {
        void var1_1;
        String helpStr = "usage: TlbImp [-tlb.id -tlb.major.version -tlb.minor.version] [-tlb.file] [-bind.mode vTable, dispId] [-output.dir]\n\noptions:\n-tlb.id               The guid of the type library.\n-tlb.major.version    The major version of the type library.\n-tlb.minor.version    The minor version of the type library.\n-tlb.file             The file name containing the type library.\n-bind.mode            The binding mode used to create the Java code.\n-output.dir           The optional output directory, default is the user temp directory.\n\nsamples:\nMicrosoft Shell Controls And Automation:\n-tlb.file shell32.dll\n-tlb.id {50A7E9B0-70EF-11D1-B75A-00A0C90564FE} -tlb.major.version 1 -tlb.minor.version 0\n\nMicrosoft Word 12.0 Object Library:\n-tlb.id {00020905-0000-0000-C000-000000000046} -tlb.major.version 8 -tlb.minor.version 4\n\n";
        System.out.println((String)var1_1);
        System.exit(0);
    }
}

