/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.util.CallbackProxy;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.IRunningObjectTable;
import com.sun.jna.platform.win32.COM.util.ProxyObject;
import com.sun.jna.platform.win32.COM.util.RunningObjectTable;
import com.sun.jna.platform.win32.COM.util.annotation.ComObject;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ObjectFactory {
    private final List<WeakReference<ProxyObject>> registeredObjects = new LinkedList<WeakReference<ProxyObject>>();
    private static final WinDef.LCID LOCALE_USER_DEFAULT = Kernel32.INSTANCE.GetUserDefaultLCID();
    private WinDef.LCID LCID;

    protected void finalize() throws Throwable {
        try {
            this.disposeAll();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public IRunningObjectTable getRunningObjectTable() {
        RunningObjectTable runningObjectTable;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        PointerByReference rotPtr = new PointerByReference();
        WinNT.HRESULT hRESULT = Ole32.INSTANCE.GetRunningObjectTable(new WinDef.DWORD(0L), rotPtr);
        COMUtils.checkRC(hRESULT);
        com.sun.jna.platform.win32.COM.RunningObjectTable raw = new com.sun.jna.platform.win32.COM.RunningObjectTable(rotPtr.getValue());
        runningObjectTable = new RunningObjectTable((com.sun.jna.platform.win32.COM.RunningObjectTable)((Object)runningObjectTable), this);
        return runningObjectTable;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T createProxy(Class<T> comInterface, IDispatch dispatch) {
        void var2_2;
        Object t;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        ProxyObject jop = new ProxyObject(comInterface, dispatch, this);
        Object proxy = Proxy.newProxyInstance(comInterface.getClassLoader(), new Class[]{comInterface}, (InvocationHandler)jop);
        t = ((Class)t).cast(var2_2);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T createObject(Class<T> comInterface) {
        void var1_1;
        void var2_2;
        void var3_3;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        ComObject comObectAnnotation = comInterface.getAnnotation(ComObject.class);
        if (comObectAnnotation == null) {
            throw new COMException("createObject: Interface must define a value for either clsId or progId via the ComInterface annotation");
        }
        Object guid = this.discoverClsId(comObectAnnotation);
        PointerByReference ptrDisp = new PointerByReference();
        guid = Ole32.INSTANCE.CoCreateInstance((Guid.GUID)((Object)guid), null, 21, IDispatch.IID_IDISPATCH, ptrDisp);
        COMUtils.checkRC((WinNT.HRESULT)((Object)guid));
        Dispatch d = new Dispatch(var3_3.getValue());
        T t = this.createProxy(comInterface, d);
        var2_2.Release();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T fetchObject(Class<T> comInterface) throws COMException {
        void var1_1;
        void var2_2;
        void var3_3;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        ComObject comObectAnnotation = comInterface.getAnnotation(ComObject.class);
        if (comObectAnnotation == null) {
            throw new COMException("createObject: Interface must define a value for either clsId or progId via the ComInterface annotation");
        }
        Object guid = this.discoverClsId(comObectAnnotation);
        PointerByReference ptrDisp = new PointerByReference();
        guid = OleAuto.INSTANCE.GetActiveObject((Guid.GUID)((Object)guid), null, ptrDisp);
        COMUtils.checkRC((WinNT.HRESULT)((Object)guid));
        Dispatch d = new Dispatch(var3_3.getValue());
        T t = this.createProxy(comInterface, d);
        var2_2.Release();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Guid.GUID discoverClsId(ComObject annotation) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        String clsIdStr = annotation.clsId();
        String progIdStr = annotation.progId();
        if (clsIdStr != null && !clsIdStr.isEmpty()) {
            return new Guid.CLSID(clsIdStr);
        }
        if (progIdStr != null && !progIdStr.isEmpty()) {
            void var2_2;
            WinNT.HRESULT hRESULT;
            Guid.CLSID.ByReference rclsid = new Guid.CLSID.ByReference();
            hRESULT = Ole32.INSTANCE.CLSIDFromProgID((String)((Object)hRESULT), rclsid);
            COMUtils.checkRC(hRESULT);
            return var2_2;
        }
        throw new COMException("ComObject must define a value for either clsId or progId");
    }

    /*
     * WARNING - void declaration
     */
    IDispatchCallback createDispatchCallback(Class<?> comEventCallbackInterface, IComEventCallbackListener comEventCallbackListener) {
        void var2_2;
        void var1_1;
        return new CallbackProxy(this, (Class<?>)var1_1, (IComEventCallbackListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void register(ProxyObject proxyObject) {
        List<WeakReference<ProxyObject>> list = this.registeredObjects;
        synchronized (list) {
            void var1_1;
            this.registeredObjects.add(new WeakReference<void>(var1_1));
            return;
        }
    }

    public void unregister(ProxyObject proxyObject) {
        List<WeakReference<ProxyObject>> list = this.registeredObjects;
        synchronized (list) {
            Iterator<WeakReference<ProxyObject>> iterator = this.registeredObjects.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProxyObject> weakReference = iterator.next();
                ProxyObject po = (ProxyObject)weakReference.get();
                if (po != null && po != proxyObject) continue;
                iterator.remove();
            }
            return;
        }
    }

    public void disposeAll() {
        List<WeakReference<ProxyObject>> list = this.registeredObjects;
        synchronized (list) {
            Object object = new ArrayList<WeakReference<ProxyObject>>(this.registeredObjects);
            object = object.iterator();
            while (object.hasNext()) {
                WeakReference weakReference = (WeakReference)object.next();
                ProxyObject po = (ProxyObject)weakReference.get();
                if (po == null) continue;
                ((ProxyObject)((Object)weakReference)).dispose();
            }
            this.registeredObjects.clear();
            return;
        }
    }

    public WinDef.LCID getLCID() {
        if (this.LCID != null) {
            return this.LCID;
        }
        return LOCALE_USER_DEFAULT;
    }

    /*
     * WARNING - void declaration
     */
    public void setLCID(WinDef.LCID value) {
        void var1_1;
        this.LCID = var1_1;
    }
}

