/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.internal.ReflectionUtils;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ConnectionPoint;
import com.sun.jna.platform.win32.COM.ConnectionPointContainer;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.util.ComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.IConnectionPoint;
import com.sun.jna.platform.win32.COM.util.IConnectionPointContainer;
import com.sun.jna.platform.win32.COM.util.IRawDispatchHandle;
import com.sun.jna.platform.win32.COM.util.IUnknown;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.COM.util.annotation.ComProperty;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ProxyObject
implements IConnectionPoint,
com.sun.jna.platform.win32.COM.util.IDispatch,
IRawDispatchHandle,
InvocationHandler {
    private long unknownId = -1L;
    private final Class<?> theInterface;
    private final ObjectFactory factory;
    private final IDispatch rawDispatch;

    /*
     * WARNING - void declaration
     */
    public ProxyObject(Class<?> theInterface, IDispatch rawDispatch, ObjectFactory factory) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.rawDispatch = var2_2;
        this.theInterface = var1_1;
        this.factory = factory;
        this.rawDispatch.AddRef();
        this.getUnknownId();
        var3_3.register(this);
    }

    /*
     * WARNING - void declaration
     */
    private long getUnknownId() {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (-1L == this.unknownId) {
            try {
                PointerByReference ppvObject = new PointerByReference();
                Thread thread = Thread.currentThread();
                thread.getName();
                Guid.IID iid = com.sun.jna.platform.win32.COM.IUnknown.IID_IUNKNOWN;
                WinNT.HRESULT hr = this.getRawDispatch().QueryInterface(new Guid.REFIID(iid), ppvObject);
                if (!WinNT.S_OK.equals((Object)hr)) {
                    String formatMessageFromHR = Kernel32Util.formatMessage(hr);
                    throw new COMException("getUnknownId: " + formatMessageFromHR, (WinNT.HRESULT)((Object)thread));
                }
                Dispatch dispatch = new Dispatch(ppvObject.getValue());
                this.unknownId = Pointer.nativeValue((Pointer)dispatch.getPointer());
                dispatch.Release();
            }
            catch (RuntimeException runtimeException) {
                void var1_2;
                RuntimeException e = runtimeException;
                if (runtimeException instanceof COMException) {
                    throw e;
                }
                throw new COMException("Error occured when trying get Unknown Id ", (Throwable)var1_2);
            }
        }
        return this.unknownId;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public synchronized void dispose() {
        if (((Dispatch)this.rawDispatch).getPointer() != Pointer.NULL) {
            this.rawDispatch.Release();
            ((Dispatch)this.rawDispatch).setPointer(Pointer.NULL);
            this.factory.unregister(this);
        }
    }

    @Override
    public IDispatch getRawDispatch() {
        return this.rawDispatch;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object arg) {
        ProxyObject other;
        if (arg == null) {
            return false;
        }
        if (arg instanceof ProxyObject) {
            other = (ProxyObject)arg;
            return this.getUnknownId() == other.getUnknownId();
        }
        if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(other);
            if (handler instanceof ProxyObject) {
                try {
                    void var1_1;
                    other = (ProxyObject)handler;
                    return this.getUnknownId() == super.getUnknownId();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        long id = this.getUnknownId();
        return (int)(id >>> 32) + (int)var1_1;
    }

    public String toString() {
        return this.theInterface.getName() + "{unk=" + this.hashCode() + "}";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean declaredAsInterface2 = method.getAnnotation(ComMethod.class) != null || method.getAnnotation(ComProperty.class) != null;
        if (!declaredAsInterface2 && (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(IRawDispatchHandle.class) || method.getDeclaringClass().equals(IUnknown.class) || method.getDeclaringClass().equals(com.sun.jna.platform.win32.COM.util.IDispatch.class) || method.getDeclaringClass().equals(IConnectionPoint.class))) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException declaredAsInterface2 = invocationTargetException;
                throw invocationTargetException.getCause();
            }
        }
        if (!declaredAsInterface2 && ReflectionUtils.isDefault((Method)method)) {
            Object methodHandle = ReflectionUtils.getMethodHandle((Method)method);
            return ReflectionUtils.invokeDefaultMethod((Object)proxy, (Object)methodHandle, (Object[])args);
        }
        Class<?> returnType = method.getReturnType();
        boolean isVoid = Void.TYPE.equals(returnType);
        ComProperty prop = method.getAnnotation(ComProperty.class);
        if (prop != null) {
            int dispId = prop.dispId();
            Object[] fullLengthArgs = this.unfoldWhenVarargs(method, args);
            if (isVoid) {
                if (dispId != -1) {
                    this.setProperty(new OaIdl.DISPID(dispId), fullLengthArgs);
                    return null;
                }
                String propName = this.getMutatorName(method, prop);
                this.setProperty(propName, fullLengthArgs);
                return null;
            }
            if (dispId != -1) {
                return this.getProperty(returnType, new OaIdl.DISPID(dispId), args);
            }
            String propName = this.getAccessorName(method, prop);
            return this.getProperty(returnType, propName, args);
        }
        ComMethod meth = method.getAnnotation(ComMethod.class);
        if (meth != null) {
            void var1_5;
            void var2_6;
            void var3_7;
            Object[] fullLengthArgs = this.unfoldWhenVarargs(method, (Object[])var3_7);
            int dispId = meth.dispId();
            if (dispId != -1) {
                return this.invokeMethod(returnType, new OaIdl.DISPID(dispId), fullLengthArgs);
            }
            String methName = this.getMethodName((Method)var2_6, meth);
            return this.invokeMethod(returnType, (String)var1_5, fullLengthArgs);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private ConnectionPoint fetchRawConnectionPoint(Guid.IID iid) {
        void var3_3;
        Object object;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        IConnectionPointContainer iConnectionPointContainer = this.queryInterface(IConnectionPointContainer.class);
        Dispatch rawCpcDispatch = (Dispatch)iConnectionPointContainer.getRawDispatch();
        ConnectionPointContainer rawCpc = new ConnectionPointContainer(rawCpcDispatch.getPointer());
        Guid.REFIID adviseRiid = new Guid.REFIID(iid.getPointer());
        PointerByReference ppCp = new PointerByReference();
        object = ((ConnectionPointContainer)((Object)iConnectionPointContainer)).FindConnectionPoint((Guid.REFIID)((Object)object), ppCp);
        COMUtils.checkRC(object);
        object = new ConnectionPoint(var3_3.getValue());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IComEventCallbackCookie advise(Class<?> comEventCallbackInterface, IComEventCallbackListener comEventCallbackListener) throws COMException {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            void var1_1;
            ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
            if (comInterfaceAnnotation == null) {
                throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
            }
            Guid.IID iid = this.getIID(comInterfaceAnnotation);
            ConnectionPoint rawCp = this.fetchRawConnectionPoint(iid);
            IDispatchCallback rawListener = this.factory.createDispatchCallback(comEventCallbackInterface, comEventCallbackListener);
            comEventCallbackListener.setDispatchCallbackListener(rawListener);
            WinDef.DWORDByReference pdwCookie = new WinDef.DWORDByReference();
            WinNT.HRESULT hr = rawCp.Advise(rawListener, pdwCookie);
            rawCp.Release();
            COMUtils.checkRC((WinNT.HRESULT)var1_1);
            return new ComEventCallbackCookie(pdwCookie.getValue());
        }
        catch (RuntimeException runtimeException) {
            void var3_4;
            void var2_2;
            RuntimeException e = runtimeException;
            if (runtimeException instanceof COMException) {
                throw e;
            }
            throw new COMException("Error occured in advise when trying to connect the listener " + var2_2, (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unadvise(Class<?> comEventCallbackInterface, IComEventCallbackCookie cookie) throws COMException {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            void var2_2;
            ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
            if (comInterfaceAnnotation == null) {
                throw new COMException("unadvise: Interface must define a value for iid via the ComInterface annotation");
            }
            Guid.IID iid = this.getIID(comInterfaceAnnotation);
            ConnectionPoint rawCp = this.fetchRawConnectionPoint(iid);
            WinNT.HRESULT hr = rawCp.Unadvise(((ComEventCallbackCookie)cookie).getValue());
            rawCp.Release();
            COMUtils.checkRC((WinNT.HRESULT)var2_2);
            return;
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            RuntimeException e = runtimeException;
            if (runtimeException instanceof COMException) {
                throw e;
            }
            throw new COMException("Error occured in unadvise when trying to disconnect the listener from " + this, (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void setProperty(String name, T value) {
        void var2_2;
        void var1_1;
        ProxyObject proxyObject = this;
        OaIdl.DISPID dispID = proxyObject.resolveDispId(proxyObject.getRawDispatch(), name);
        this.setProperty((OaIdl.DISPID)var1_1, (T)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void setProperty(OaIdl.DISPID dispId, T value) {
        void var1_1;
        void var2_2;
        void var3_3;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Variant.VARIANT v = Convert.toVariant(value);
        WinNT.HRESULT hr = this.oleMethod(4, null, this.getRawDispatch(), dispId, v);
        Convert.free((Variant.VARIANT)var3_3, var2_2);
        COMUtils.checkRC((WinNT.HRESULT)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setProperty(String name, Object ... args) {
        void var2_2;
        void var1_1;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        ProxyObject proxyObject = this;
        OaIdl.DISPID dispID = proxyObject.resolveDispId(proxyObject.getRawDispatch(), name);
        this.setProperty((OaIdl.DISPID)var1_1, (Object[])var2_2);
    }

    private void setProperty(OaIdl.DISPID dispID, Object ... args) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Variant.VARIANT[] vargs = args == null ? new Variant.VARIANT[]{} : new Variant.VARIANT[args.length];
        for (int i = 0; i < vargs.length; ++i) {
            vargs[i] = Convert.toVariant(args[i]);
        }
        WinNT.HRESULT hr = this.oleMethod(4, null, this.getRawDispatch(), dispID, vargs);
        for (int i = 0; i < vargs.length; ++i) {
            Convert.free(vargs[i], args[i]);
        }
        COMUtils.checkRC(hr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getProperty(Class<T> returnType, String name, Object ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        ProxyObject proxyObject = this;
        OaIdl.DISPID dispID = proxyObject.resolveDispId(proxyObject.getRawDispatch(), name);
        return this.getProperty((Class<T>)var1_1, (OaIdl.DISPID)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getProperty(Class<T> returnType, OaIdl.DISPID dispID, Object ... args) {
        void var1_1;
        void var2_2;
        Variant.VARIANT[] vargs = args == null ? new Variant.VARIANT[]{} : new Variant.VARIANT[args.length];
        for (int i = 0; i < vargs.length; ++i) {
            vargs[i] = Convert.toVariant(args[i]);
        }
        Variant.VARIANT.ByReference result = new Variant.VARIANT.ByReference();
        WinNT.HRESULT hr = this.oleMethod(2, result, this.getRawDispatch(), dispID, vargs);
        for (int i = 0; i < vargs.length; ++i) {
            Convert.free(vargs[i], args[i]);
        }
        COMUtils.checkRC((WinNT.HRESULT)var2_2);
        return (T)Convert.toJavaObject(result, var1_1, this.factory, false, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeMethod(Class<T> returnType, String name, Object ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        ProxyObject proxyObject = this;
        OaIdl.DISPID dispID = proxyObject.resolveDispId(proxyObject.getRawDispatch(), name);
        return this.invokeMethod((Class<T>)var1_1, (OaIdl.DISPID)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeMethod(Class<T> returnType, OaIdl.DISPID dispID, Object ... args) {
        void var1_1;
        void var2_2;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Variant.VARIANT[] vargs = args == null ? new Variant.VARIANT[]{} : new Variant.VARIANT[args.length];
        for (int i = 0; i < vargs.length; ++i) {
            vargs[i] = Convert.toVariant(args[i]);
        }
        Variant.VARIANT.ByReference result = new Variant.VARIANT.ByReference();
        WinNT.HRESULT hr = this.oleMethod(1, result, this.getRawDispatch(), dispID, vargs);
        for (int i = 0; i < vargs.length; ++i) {
            Convert.free(vargs[i], args[i]);
        }
        COMUtils.checkRC((WinNT.HRESULT)var2_2);
        return (T)Convert.toJavaObject(result, var1_1, this.factory, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private Object[] unfoldWhenVarargs(Method method, Object[] argParams) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (argParams == null) {
            return null;
        }
        if (argParams.length == 0 || !method.isVarArgs() || !(argParams[argParams.length - 1] instanceof Object[])) {
            return argParams;
        }
        Object[] varargs = (Object[])argParams[argParams.length - 1];
        Object[] args = new Object[argParams.length - 1 + varargs.length];
        System.arraycopy(argParams, 0, args, 0, argParams.length - 1);
        System.arraycopy(varargs, 0, args, ((void)var2_2).length - 1, ((void)var1_1).length);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T queryInterface(Class<T> comInterface) throws COMException {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            void var3_4;
            T t;
            ComInterface comInterfaceAnnotation = comInterface.getAnnotation(ComInterface.class);
            if (comInterfaceAnnotation == null) {
                throw new COMException("queryInterface: Interface must define a value for iid via the ComInterface annotation");
            }
            Guid.IID iid = this.getIID(comInterfaceAnnotation);
            PointerByReference ppvObject = new PointerByReference();
            WinNT.HRESULT hr = this.getRawDispatch().QueryInterface(new Guid.REFIID(iid), ppvObject);
            if (WinNT.S_OK.equals((Object)hr)) {
                Dispatch dispatch = new Dispatch(ppvObject.getValue());
                t = this.factory.createProxy(comInterface, dispatch);
                dispatch.Release();
                return t;
            }
            String formatMessageFromHR = Kernel32Util.formatMessage((WinNT.HRESULT)((Object)t));
            throw new COMException("queryInterface: " + (String)var3_4, (WinNT.HRESULT)((Object)t));
        }
        catch (RuntimeException runtimeException) {
            void var2_3;
            void var1_1;
            RuntimeException e = runtimeException;
            if (runtimeException instanceof COMException) {
                throw e;
            }
            throw new COMException("Error occured when trying to query for interface " + var1_1.getName(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Guid.IID getIID(ComInterface annotation) {
        String iidStr = annotation.iid();
        if (iidStr != null && !iidStr.isEmpty()) {
            void var1_1;
            return new Guid.IID((String)var1_1);
        }
        throw new COMException("ComInterface must define a value for iid");
    }

    /*
     * WARNING - void declaration
     */
    private String getAccessorName(Method method, ComProperty prop) {
        void var2_2;
        if (prop.name().isEmpty()) {
            String methName = method.getName();
            if (methName.startsWith("get")) {
                void var1_1;
                return var1_1.replaceFirst("get", "");
            }
            throw new RuntimeException("Property Accessor name must start with 'get', or set the anotation 'name' value");
        }
        return var2_2.name();
    }

    /*
     * WARNING - void declaration
     */
    private String getMutatorName(Method method, ComProperty prop) {
        void var2_2;
        if (prop.name().isEmpty()) {
            String methName = method.getName();
            if (methName.startsWith("set")) {
                void var1_1;
                return var1_1.replaceFirst("set", "");
            }
            throw new RuntimeException("Property Mutator name must start with 'set', or set the anotation 'name' value");
        }
        return var2_2.name();
    }

    /*
     * WARNING - void declaration
     */
    private String getMethodName(Method method, ComMethod meth) {
        void var2_2;
        if (meth.name().isEmpty()) {
            String string;
            string = ((Method)((Object)string)).getName();
            return string;
        }
        return var2_2.name();
    }

    /*
     * WARNING - void declaration
     */
    protected OaIdl.DISPID resolveDispId(String name) {
        void var1_1;
        ProxyObject proxyObject = this;
        return proxyObject.resolveDispId(proxyObject.getRawDispatch(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, String name, Variant.VARIANT pArg) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (String)var3_3, new Variant.VARIANT[]{pArg});
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, OaIdl.DISPID dispId, Variant.VARIANT pArg) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (OaIdl.DISPID)var3_3, new Variant.VARIANT[]{pArg});
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, String name) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (String)var3_3, (Variant.VARIANT[])null);
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, OaIdl.DISPID dispId) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (OaIdl.DISPID)var3_3, (Variant.VARIANT[])null);
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, String name, Variant.VARIANT[] pArgs) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, this.resolveDispId((String)var3_3), pArgs);
    }

    /*
     * WARNING - void declaration
     */
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, OaIdl.DISPID dispId, Variant.VARIANT[] pArgs) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, this.getRawDispatch(), (OaIdl.DISPID)var3_3, pArgs);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected OaIdl.DISPID resolveDispId(IDispatch pDisp, String name) {
        void var3_3;
        void var2_2;
        WinNT.HRESULT hRESULT;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (pDisp == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        WString[] ptName = new WString[]{new WString(name)};
        OaIdl.DISPIDByReference pdispID = new OaIdl.DISPIDByReference();
        hRESULT = hRESULT.GetIDsOfNames(new Guid.REFIID(Guid.IID_NULL), (WString[])var2_2, 1, this.factory.getLCID(), pdispID);
        COMUtils.checkRC(hRESULT);
        return var3_3.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name, Variant.VARIANT pArg) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (IDispatch)var3_3, name, new Variant.VARIANT[]{pArg});
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, OaIdl.DISPID dispId, Variant.VARIANT pArg) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (IDispatch)var3_3, dispId, new Variant.VARIANT[]{pArg});
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (IDispatch)var3_3, name, (Variant.VARIANT[])null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, OaIdl.DISPID dispId) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, (IDispatch)var3_3, dispId, (Variant.VARIANT[])null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name, Variant.VARIANT[] pArgs) throws COMException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.oleMethod((int)var1_1, (Variant.VARIANT.ByReference)var2_2, pDisp, this.resolveDispId((IDispatch)var3_3, name), pArgs);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, OaIdl.DISPID dispId, Variant.VARIANT[] pArgs) throws COMException {
        void var2_2;
        void var3_3;
        void var1_1;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (pDisp == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        int _argsLen = 0;
        Variant.VARIANT[] _args = null;
        OleAuto.DISPPARAMS.ByReference dp = new OleAuto.DISPPARAMS.ByReference();
        OaIdl.EXCEPINFO.ByReference pExcepInfo = new OaIdl.EXCEPINFO.ByReference();
        IntByReference puArgErr = new IntByReference();
        if (pArgs != null && pArgs.length > 0) {
            _argsLen = pArgs.length;
            _args = new Variant.VARIANT[_argsLen];
            int revCount = _argsLen;
            for (int i = 0; i < _argsLen; ++i) {
                _args[i] = pArgs[--revCount];
            }
        }
        if (nType == 4) {
            dp.setRgdispidNamedArgs(new OaIdl.DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        int finalNType = nType == 1 || nType == 2 ? 3 : var1_1;
        if (_argsLen > 0) {
            dp.setArgs(_args);
            dp.write();
        }
        WinNT.HRESULT hr = var3_3.Invoke(dispId, new Guid.REFIID(Guid.IID_NULL), this.factory.getLCID(), new WinDef.WORD(finalNType), dp, (Variant.VARIANT.ByReference)var2_2, pExcepInfo, puArgErr);
        COMUtils.checkRC(hr, pExcepInfo, puArgErr);
        return hr;
    }
}

