/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;

public class W32Service
implements Closeable {
    Winsvc.SC_HANDLE _handle = null;

    /*
     * WARNING - void declaration
     */
    public W32Service(Winsvc.SC_HANDLE handle) {
        void var1_1;
        this._handle = var1_1;
    }

    @Override
    public void close() {
        if (this._handle != null) {
            if (!Advapi32.INSTANCE.CloseServiceHandle(this._handle)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._handle = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addShutdownPrivilegeToProcess() {
        void var1_1;
        void var3_3;
        void var2_2;
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        WinNT.LUID luid = new WinNT.LUID();
        Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 32, hToken);
        Advapi32.INSTANCE.LookupPrivilegeValue("", "SeShutdownPrivilege", luid);
        WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(1);
        tp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES((WinNT.LUID)var2_2, new WinDef.DWORD(2L));
        void v0 = var3_3;
        Advapi32.INSTANCE.AdjustTokenPrivileges(var1_1.getValue(), false, (WinNT.TOKEN_PRIVILEGES)v0, v0.size(), null, new IntByReference());
    }

    public void setFailureActions(List<Winsvc.SC_ACTION> actions, int resetPeriod, String rebootMsg, String command) {
        Iterator iterator;
        Winsvc.SERVICE_FAILURE_ACTIONS.ByReference actionStruct = new Winsvc.SERVICE_FAILURE_ACTIONS.ByReference();
        new Winsvc.SERVICE_FAILURE_ACTIONS.ByReference().dwResetPeriod = resetPeriod;
        actionStruct.lpRebootMsg = rebootMsg;
        actionStruct.lpCommand = command;
        actionStruct.cActions = actions.size();
        actionStruct.lpsaActions = new Winsvc.SC_ACTION.ByReference();
        Winsvc.SC_ACTION[] actionArray = (Winsvc.SC_ACTION[])actionStruct.lpsaActions.toArray(actions.size());
        boolean hasShutdownPrivilege = false;
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Winsvc.SC_ACTION action = (Winsvc.SC_ACTION)((Object)iterator.next());
            if (!hasShutdownPrivilege && action.type == 2) {
                this.addShutdownPrivilegeToProcess();
                hasShutdownPrivilege = true;
            }
            actionArray[i].type = action.type;
            actionArray[i].delay = action.delay;
            ++i;
        }
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 2, actionStruct)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pointer queryServiceConfig2(int type) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntByReference bufferSize = new IntByReference();
        Advapi32.INSTANCE.QueryServiceConfig2(this._handle, type, Pointer.NULL, 0, bufferSize);
        Memory buffer = new Memory((long)bufferSize.getValue());
        if (!Advapi32.INSTANCE.QueryServiceConfig2(this._handle, (int)var1_1, (Pointer)buffer, var2_2.getValue(), new IntByReference())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return var3_3;
    }

    public Winsvc.SERVICE_FAILURE_ACTIONS getFailureActions() {
        Winsvc.SERVICE_FAILURE_ACTIONS sERVICE_FAILURE_ACTIONS;
        Pointer buffer = this.queryServiceConfig2(2);
        sERVICE_FAILURE_ACTIONS = new Winsvc.SERVICE_FAILURE_ACTIONS((Pointer)sERVICE_FAILURE_ACTIONS);
        return sERVICE_FAILURE_ACTIONS;
    }

    /*
     * WARNING - void declaration
     */
    public void setFailureActionsFlag(boolean flagValue) {
        void var2_2;
        void var1_1;
        Winsvc.SERVICE_FAILURE_ACTIONS_FLAG flag = new Winsvc.SERVICE_FAILURE_ACTIONS_FLAG();
        int n = new Winsvc.SERVICE_FAILURE_ACTIONS_FLAG().fFailureActionsOnNonCrashFailures = var1_1 != false ? 1 : 0;
        if (!Advapi32.INSTANCE.ChangeServiceConfig2(this._handle, 4, (Winsvc.ChangeServiceConfig2Info)var2_2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public boolean getFailureActionsFlag() {
        Winsvc.SERVICE_FAILURE_ACTIONS_FLAG sERVICE_FAILURE_ACTIONS_FLAG;
        Pointer buffer = this.queryServiceConfig2(4);
        sERVICE_FAILURE_ACTIONS_FLAG = new Winsvc.SERVICE_FAILURE_ACTIONS_FLAG((Pointer)sERVICE_FAILURE_ACTIONS_FLAG);
        return sERVICE_FAILURE_ACTIONS_FLAG.fFailureActionsOnNonCrashFailures != 0;
    }

    /*
     * WARNING - void declaration
     */
    public Winsvc.SERVICE_STATUS_PROCESS queryStatus() {
        void var2_2;
        void var1_1;
        Winsvc.SERVICE_STATUS_PROCESS status;
        IntByReference size = new IntByReference();
        Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, null, 0, size);
        Winsvc.SERVICE_STATUS_PROCESS sERVICE_STATUS_PROCESS = status = new Winsvc.SERVICE_STATUS_PROCESS(size.getValue());
        if (!Advapi32.INSTANCE.QueryServiceStatusEx(this._handle, 0, sERVICE_STATUS_PROCESS, sERVICE_STATUS_PROCESS.size(), (IntByReference)var1_1)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return var2_2;
    }

    public void startService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.StartService(this._handle, 0, null)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to start the service");
        }
    }

    public void stopService() {
        this.stopService(30000L);
    }

    /*
     * WARNING - void declaration
     */
    public void stopService(long timeout) {
        long startTime = System.currentTimeMillis();
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 1) {
            return;
        }
        Winsvc.SERVICE_STATUS status = new Winsvc.SERVICE_STATUS();
        if (!Advapi32.INSTANCE.ControlService(this._handle, 1, status)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        while (status.dwCurrentState != 1) {
            long msRemainingBeforeTimeout = timeout - (System.currentTimeMillis() - startTime);
            if (msRemainingBeforeTimeout < 0L) {
                throw new RuntimeException(String.format("Service stop exceeded timeout time of %d ms", timeout));
            }
            long dwWaitTime = Math.min((long)this.sanitizeWaitTime(status.dwWaitHint), msRemainingBeforeTimeout);
            try {
                Thread.sleep(dwWaitTime);
            }
            catch (InterruptedException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            if (Advapi32.INSTANCE.QueryServiceStatus(this._handle, status)) continue;
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public void continueService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 4) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 3, new Winsvc.SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 4) {
            throw new RuntimeException("Unable to continue the service");
        }
    }

    public void pauseService() {
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState == 7) {
            return;
        }
        if (!Advapi32.INSTANCE.ControlService(this._handle, 2, new Winsvc.SERVICE_STATUS())) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        this.waitForNonPendingState();
        if (this.queryStatus().dwCurrentState != 7) {
            throw new RuntimeException("Unable to pause the service");
        }
    }

    /*
     * WARNING - void declaration
     */
    int sanitizeWaitTime(int dwWaitHint) {
        void var1_1;
        int dwWaitTime = dwWaitHint / 10;
        if (dwWaitTime < 1000) {
            dwWaitTime = 1000;
        } else if (dwWaitTime > 10000) {
            dwWaitTime = 10000;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void waitForNonPendingState() {
        Winsvc.SERVICE_STATUS_PROCESS status = this.queryStatus();
        int previousCheckPoint = status.dwCheckPoint;
        int checkpointStartTickCount = Kernel32.INSTANCE.GetTickCount();
        while (this.isPendingState(status.dwCurrentState)) {
            if (status.dwCheckPoint != previousCheckPoint) {
                previousCheckPoint = status.dwCheckPoint;
                checkpointStartTickCount = Kernel32.INSTANCE.GetTickCount();
            }
            if (Kernel32.INSTANCE.GetTickCount() - checkpointStartTickCount > status.dwWaitHint) {
                throw new RuntimeException("Timeout waiting for service to change to a non-pending state.");
            }
            int dwWaitTime = this.sanitizeWaitTime(status.dwWaitHint);
            try {
                Thread.sleep(dwWaitTime);
            }
            catch (InterruptedException e) {
                void var1_3;
                throw new RuntimeException((Throwable)var1_3);
            }
            Winsvc.SERVICE_STATUS_PROCESS sERVICE_STATUS_PROCESS = this.queryStatus();
        }
    }

    private boolean isPendingState(int state) {
        switch (state) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Winsvc.SC_HANDLE getHandle() {
        return this._handle;
    }

    /*
     * WARNING - void declaration
     */
    public Winsvc.ENUM_SERVICE_STATUS[] enumDependentServices(int dwServiceState) {
        void var3_4;
        void var1_2;
        void var2_3;
        Memory buffer;
        IntByReference pcbBytesNeeded = new IntByReference(0);
        IntByReference lpServicesReturned = new IntByReference(0);
        Advapi32.INSTANCE.EnumDependentServices(this._handle, dwServiceState, Pointer.NULL, 0, pcbBytesNeeded, lpServicesReturned);
        int lastError = Kernel32.INSTANCE.GetLastError();
        if (lastError != 234) {
            throw new Win32Exception(lastError);
        }
        Memory memory = buffer = new Memory((long)pcbBytesNeeded.getValue());
        boolean bl = Advapi32.INSTANCE.EnumDependentServices(this._handle, dwServiceState, (Pointer)memory, (int)memory.size(), (IntByReference)var2_3, lpServicesReturned);
        dwServiceState = bl ? 1 : 0;
        if (!bl) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (lpServicesReturned.getValue() == 0) {
            return new Winsvc.ENUM_SERVICE_STATUS[0];
        }
        Winsvc.ENUM_SERVICE_STATUS status = (Winsvc.ENUM_SERVICE_STATUS)Structure.newInstance(Winsvc.ENUM_SERVICE_STATUS.class, (Pointer)buffer);
        status.read();
        return (Winsvc.ENUM_SERVICE_STATUS[])var1_2.toArray(var3_4.getValue());
    }
}

