/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTimeUtils {
    private static MillisProvider SYSTEM_MILLIS_PROVIDER;
    private static volatile MillisProvider cMillisProvider;
    private static final AtomicReference<Map<String, DateTimeZone>> cZoneNames;

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final long getInstantMillis(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return readableInstant.getMillis();
    }

    public static final Chronology getInstantChronology(ReadableInstant object) {
        if (object == null) {
            return ISOChronology.getInstance();
        }
        if ((object = object.getChronology()) == null) {
            return ISOChronology.getInstance();
        }
        return object;
    }

    public static final Chronology getChronology(Chronology chronology) {
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final PeriodType getPeriodType(PeriodType periodType) {
        if (periodType == null) {
            return PeriodType.standard();
        }
        return periodType;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale locale) {
        try {
            Method method = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
            return (DateFormatSymbols)method.invoke(null, locale);
        }
        catch (Exception exception) {
            return new DateFormatSymbols(locale);
        }
    }

    public static final Map<String, DateTimeZone> getDefaultTimeZoneNames() {
        Map<String, DateTimeZone> map = cZoneNames.get();
        if (map == null) {
            map = new LinkedHashMap<String, DateTimeZone>();
            map.put("UT", DateTimeZone.UTC);
            map.put("UTC", DateTimeZone.UTC);
            map.put("GMT", DateTimeZone.UTC);
            DateTimeUtils.put(map, "EST", "America/New_York");
            DateTimeUtils.put(map, "EDT", "America/New_York");
            DateTimeUtils.put(map, "CST", "America/Chicago");
            DateTimeUtils.put(map, "CDT", "America/Chicago");
            DateTimeUtils.put(map, "MST", "America/Denver");
            DateTimeUtils.put(map, "MDT", "America/Denver");
            DateTimeUtils.put(map, "PST", "America/Los_Angeles");
            DateTimeUtils.put(map, "PDT", "America/Los_Angeles");
            map = Collections.unmodifiableMap(map);
            if (!cZoneNames.compareAndSet(null, map)) {
                map = cZoneNames.get();
            }
        }
        return map;
    }

    private static void put(Map<String, DateTimeZone> map, String string, String string2) {
        try {
            map.put(string, DateTimeZone.forID(string2));
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    static {
        cMillisProvider = SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
        cZoneNames = new AtomicReference();
    }

    static final class SystemMillisProvider
    implements MillisProvider {
        SystemMillisProvider() {
        }

        public final long getMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }
}

