/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.IllegalInstantException;
import org.joda.time.UTCDateTimeZone;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeZone
implements Serializable {
    public static final DateTimeZone UTC = UTCDateTimeZone.INSTANCE;
    private static final AtomicReference<Provider> cProvider = new AtomicReference();
    private static final AtomicReference<NameProvider> cNameProvider = new AtomicReference();
    private static final AtomicReference<DateTimeZone> cDefault = new AtomicReference();
    private final String iID;

    public static DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = cDefault.get();
        if (dateTimeZone == null) {
            try {
                Object object;
                try {
                    object = System.getProperty("org.joda.time.DateTimeZone.Timezone");
                    if (object != null) {
                        dateTimeZone = DateTimeZone.forID((String)object);
                    }
                }
                catch (RuntimeException runtimeException) {}
                if (dateTimeZone == null) {
                    DateTimeZone dateTimeZone2;
                    object = TimeZone.getDefault();
                    if (object == null) {
                        dateTimeZone2 = DateTimeZone.getDefault();
                    } else {
                        if ((object = ((TimeZone)object).getID()) == null) {
                            throw new IllegalArgumentException("The TimeZone id must not be null");
                        }
                        if (((String)object).equals("UTC")) {
                            dateTimeZone2 = UTC;
                        } else {
                            DateTimeZone dateTimeZone3 = null;
                            Object object2 = object;
                            object2 = LazyInit.CONVERSION_MAP.get(object2);
                            Provider provider = DateTimeZone.getProvider();
                            if (object2 != null) {
                                dateTimeZone3 = provider.getZone((String)object2);
                            }
                            if (dateTimeZone3 == null) {
                                dateTimeZone3 = provider.getZone((String)object);
                            }
                            if (dateTimeZone3 != null) {
                                dateTimeZone2 = dateTimeZone3;
                            } else if (object2 == null && (((String)(object2 = object)).startsWith("GMT+") || ((String)object2).startsWith("GMT-"))) {
                                int n;
                                char c;
                                if (((String)(object2 = ((String)object2).substring(3))).length() > 2 && (c = ((String)object2).charAt(1)) > '9' && Character.isDigit(c)) {
                                    object2 = DateTimeZone.convertToAsciiNumber((String)object2);
                                }
                                if ((long)(n = DateTimeZone.parseOffset((String)object2)) == 0L) {
                                    dateTimeZone2 = UTC;
                                } else {
                                    object2 = DateTimeZone.printOffset(n);
                                    dateTimeZone2 = DateTimeZone.fixedOffsetZone((String)object2, n);
                                }
                            } else {
                                throw new IllegalArgumentException("The datetime zone id '" + (String)object + "' is not recognised");
                            }
                        }
                    }
                    dateTimeZone = dateTimeZone2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (dateTimeZone == null) {
                dateTimeZone = UTC;
            }
            if (!cDefault.compareAndSet(null, dateTimeZone)) {
                dateTimeZone = cDefault.get();
            }
        }
        return dateTimeZone;
    }

    @FromString
    public static DateTimeZone forID(String string) {
        if (string == null) {
            return DateTimeZone.getDefault();
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = DateTimeZone.getProvider().getZone(string);
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            int n = DateTimeZone.parseOffset(string);
            if ((long)n == 0L) {
                return UTC;
            }
            string = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string, n);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    private static String convertToAsciiNumber(String charSequence) {
        charSequence = new StringBuilder((String)charSequence);
        for (int i = 0; i < ((StringBuilder)charSequence).length(); ++i) {
            int n = ((StringBuilder)charSequence).charAt(i);
            if ((n = Character.digit((char)n, 10)) < 0) continue;
            ((StringBuilder)charSequence).setCharAt(i, (char)(n + 48));
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static DateTimeZone fixedOffsetZone(String string, int n) {
        if (n == 0) {
            return UTC;
        }
        int n2 = n;
        return new FixedDateTimeZone(string, null, n2, n2);
    }

    public static Set<String> getAvailableIDs() {
        return DateTimeZone.getProvider().getAvailableIDs();
    }

    private static Provider getProvider() {
        Provider provider = cProvider.get();
        if (provider == null && !cProvider.compareAndSet(null, provider = DateTimeZone.getDefaultProvider())) {
            provider = cProvider.get();
        }
        return provider;
    }

    private static Provider validateProvider(Provider provider) {
        Set<String> set = provider.getAvailableIDs();
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        return provider;
    }

    private static Provider getDefaultProvider() {
        Object object;
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (object != null) {
                try {
                    object = Class.forName((String)object, false, DateTimeZone.class.getClassLoader());
                    if (!Provider.class.isAssignableFrom((Class<?>)object)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + Provider.class);
                    }
                    object = ((Class)object).asSubclass(Provider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    return DateTimeZone.validateProvider((Provider)object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {}
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Folder");
            if (object != null) {
                try {
                    object = new ZoneInfoProvider(new File((String)object));
                    return DateTimeZone.validateProvider((Provider)object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {}
        try {
            object = new ZoneInfoProvider("org/joda/time/tz/data");
            return DateTimeZone.validateProvider((Provider)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return new UTCProvider();
        }
    }

    private static NameProvider getNameProvider() {
        NameProvider nameProvider = cNameProvider.get();
        if (nameProvider == null && !cNameProvider.compareAndSet(null, nameProvider = DateTimeZone.getDefaultNameProvider())) {
            nameProvider = cNameProvider.get();
        }
        return nameProvider;
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider;
        block6: {
            nameProvider = null;
            try {
                Object object = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
                if (object == null) break block6;
                try {
                    object = Class.forName((String)object, false, DateTimeZone.class.getClassLoader());
                    if (!NameProvider.class.isAssignableFrom((Class<?>)object)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + NameProvider.class);
                    }
                    nameProvider = ((Class)object).asSubclass(NameProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (SecurityException securityException) {}
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static int parseOffset(String string) {
        return -((int)LazyInit.OFFSET_FORMATTER.parseMillis(string));
    }

    private static String printOffset(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n = -n;
        }
        int n2 = n / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        n -= n2 * 3600000;
        n2 = n / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        if ((n -= n2 * 60000) == 0) {
            return stringBuffer.toString();
        }
        n2 = n / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        if ((n -= n2 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, n, 3);
        return stringBuffer.toString();
    }

    protected DateTimeZone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long l, Locale object) {
        String string;
        if (object == null) {
            object = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        object = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getShortName((Locale)object, this.iID, string, this.isStandardOffset(l)) : nameProvider.getShortName((Locale)object, this.iID, string);
        if (object != null) {
            return object;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public final String getName(long l, Locale object) {
        String string;
        if (object == null) {
            object = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        object = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getName((Locale)object, this.iID, string, this.isStandardOffset(l)) : nameProvider.getName((Locale)object, this.iID, string);
        if (object != null) {
            return object;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public abstract int getOffset(long var1);

    public abstract int getStandardOffset(long var1);

    private boolean isStandardOffset(long l) {
        return this.getOffset(l) == this.getStandardOffset(l);
    }

    public int getOffsetFromLocal(long l) {
        int n;
        int n2;
        long l2;
        long l3;
        int n3;
        int n4 = this.getOffset(l);
        if (n4 != (n3 = this.getOffset(l3 = l - (long)n4))) {
            if (n4 - n3 < 0) {
                long l4;
                long l5 = this.nextTransition(l3);
                if (l5 == l - (long)n4) {
                    l5 = Long.MAX_VALUE;
                }
                if ((l4 = this.nextTransition(l - (long)n3)) == l - (long)n3) {
                    l4 = Long.MAX_VALUE;
                }
                if (l5 != l4) {
                    return n4;
                }
            }
        } else if (n4 >= 0 && (l2 = this.previousTransition(l3)) < l3 && l3 - l2 <= (long)(n2 = (n = this.getOffset(l2)) - n4)) {
            return n;
        }
        return n3;
    }

    public final long convertUTCToLocal(long l) {
        int n = this.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l2;
    }

    public final long convertLocalToUTC(long l, boolean n, long l2) {
        long l3;
        n = this.getOffset(l2);
        long l4 = l - (long)n;
        int n2 = this.getOffset(l4);
        if (n2 == n) {
            return l4;
        }
        boolean bl = false;
        DateTimeZone dateTimeZone = this;
        long l5 = l;
        n = dateTimeZone.getOffset(l5);
        if (n != (n2 = dateTimeZone.getOffset(l5 - (long)n)) && (bl || n < 0)) {
            long l6;
            l3 = dateTimeZone.nextTransition(l5 - (long)n);
            if (l3 == l5 - (long)n) {
                l3 = Long.MAX_VALUE;
            }
            if ((l6 = dateTimeZone.nextTransition(l5 - (long)n2)) == l5 - (long)n2) {
                l6 = Long.MAX_VALUE;
            }
            if (l3 != l6) {
                if (bl) {
                    throw new IllegalInstantException(l5, dateTimeZone.iID);
                }
                n2 = n;
            }
        }
        if ((l5 ^ (l3 = l5 - (long)n2)) < 0L && (l5 ^ (long)n2) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l3;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public abstract boolean equals(Object var1);

    public int hashCode() {
        DateTimeZone dateTimeZone = this;
        return 57 + dateTimeZone.iID.hashCode();
    }

    public String toString() {
        DateTimeZone dateTimeZone = this;
        return dateTimeZone.iID;
    }

    static final class LazyInit {
        static final Map<String, String> CONVERSION_MAP;
        static final DateTimeFormatter OFFSET_FORMATTER;

        static {
            Serializable serializable = new HashMap<String, String>();
            serializable.put("GMT", "UTC");
            serializable.put("WET", "WET");
            serializable.put("CET", "CET");
            serializable.put("MET", "CET");
            serializable.put("ECT", "CET");
            serializable.put("EET", "EET");
            serializable.put("MIT", "Pacific/Apia");
            serializable.put("HST", "Pacific/Honolulu");
            serializable.put("AST", "America/Anchorage");
            serializable.put("PST", "America/Los_Angeles");
            serializable.put("MST", "America/Denver");
            serializable.put("PNT", "America/Phoenix");
            serializable.put("CST", "America/Chicago");
            serializable.put("EST", "America/New_York");
            serializable.put("IET", "America/Indiana/Indianapolis");
            serializable.put("PRT", "America/Puerto_Rico");
            serializable.put("CNT", "America/St_Johns");
            serializable.put("AGT", "America/Argentina/Buenos_Aires");
            serializable.put("BET", "America/Sao_Paulo");
            serializable.put("ART", "Africa/Cairo");
            serializable.put("CAT", "Africa/Harare");
            serializable.put("EAT", "Africa/Addis_Ababa");
            serializable.put("NET", "Asia/Yerevan");
            serializable.put("PLT", "Asia/Karachi");
            serializable.put("IST", "Asia/Kolkata");
            serializable.put("BST", "Asia/Dhaka");
            serializable.put("VST", "Asia/Ho_Chi_Minh");
            serializable.put("CTT", "Asia/Shanghai");
            serializable.put("JST", "Asia/Tokyo");
            serializable.put("ACT", "Australia/Darwin");
            serializable.put("AET", "Australia/Sydney");
            serializable.put("SST", "Pacific/Guadalcanal");
            serializable.put("NST", "Pacific/Auckland");
            CONVERSION_MAP = Collections.unmodifiableMap(serializable);
            serializable = new BaseChronology(){

                public final DateTimeZone getZone() {
                    return null;
                }

                public final Chronology withUTC() {
                    return this;
                }

                public final Chronology withZone(DateTimeZone dateTimeZone) {
                    return this;
                }

                public final String toString() {
                    return this.getClass().getName();
                }
            };
            OFFSET_FORMATTER = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter().withChronology((Chronology)((Object)serializable));
        }
    }
}

