/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.base.BaseDateTime;
import org.joda.time.field.AbstractReadableInstantFieldProperty;

public final class MutableDateTime
extends BaseDateTime
implements Serializable,
Cloneable {
    public MutableDateTime() {
    }

    public MutableDateTime(long l, DateTimeZone dateTimeZone) {
        super(0L, dateTimeZone);
    }

    public final void setMillis(long l) {
        super.setMillis(l);
    }

    public final Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private MutableDateTime iInstant;
        private DateTimeField iField;

        Property(MutableDateTime mutableDateTime, DateTimeField dateTimeField) {
            this.iInstant = mutableDateTime;
            this.iField = dateTimeField;
        }

        public final DateTimeField getField() {
            return this.iField;
        }

        protected final long getMillis() {
            return this.iInstant.getMillis();
        }

        protected final Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public final MutableDateTime set(int n) {
            Property property = this;
            this.iInstant.setMillis(property.iField.set(this.iInstant.getMillis(), n));
            return this.iInstant;
        }
    }
}

