/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.joda.time.DurationFieldType;

public final class PeriodType
implements Serializable {
    private static PeriodType cStandard;
    private static PeriodType cTime;
    private final String iName;
    private final DurationFieldType[] iTypes;

    public static PeriodType standard() {
        PeriodType periodType = cStandard;
        if (periodType == null) {
            cStandard = periodType = new PeriodType("Standard", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return periodType;
    }

    public static PeriodType time() {
        PeriodType periodType = cTime;
        if (periodType == null) {
            cTime = periodType = new PeriodType("Time", new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return periodType;
    }

    private PeriodType(String string, DurationFieldType[] durationFieldTypeArray, int[] nArray) {
        this.iName = string;
        this.iTypes = durationFieldTypeArray;
    }

    public final int size() {
        return this.iTypes.length;
    }

    public final DurationFieldType getFieldType(int n) {
        return this.iTypes[n];
    }

    public final boolean isSupported(DurationFieldType durationFieldType) {
        return this.indexOf(durationFieldType) >= 0;
    }

    public final int indexOf(DurationFieldType durationFieldType) {
        PeriodType periodType = this;
        int n = periodType.iTypes.length;
        for (int i = 0; i < n; ++i) {
            if (!this.iTypes[i].equals(durationFieldType)) continue;
            return i;
        }
        return -1;
    }

    public final String toString() {
        PeriodType periodType = this;
        return "PeriodType[" + periodType.iName + "]";
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PeriodType)) {
            return false;
        }
        object = (PeriodType)object;
        return Arrays.equals(this.iTypes, ((PeriodType)object).iTypes);
    }

    public final int hashCode() {
        int n = 0;
        for (int i = 0; i < this.iTypes.length; ++i) {
            n += this.iTypes[i].hashCode();
        }
        return n;
    }

    static {
        new HashMap(32);
    }
}

