/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPeriod;
import org.joda.time.chrono.ISOChronology;

public abstract class BasePeriod
extends AbstractPeriod
implements Serializable {
    private static final ReadablePeriod DUMMY_PERIOD = new AbstractPeriod(){

        public final int getValue(int n) {
            return 0;
        }

        public final PeriodType getPeriodType() {
            return PeriodType.time();
        }
    };
    private final PeriodType iType;
    private final int[] iValues;

    protected BasePeriod(long l) {
        this.iType = PeriodType.standard();
        int[] nArray = ISOChronology.getInstanceUTC().get(DUMMY_PERIOD, l);
        this.iValues = new int[8];
        System.arraycopy(nArray, 0, this.iValues, 4, 4);
    }

    protected BasePeriod(long l, PeriodType periodType, Chronology chronology) {
        PeriodType periodType2 = periodType;
        periodType = DateTimeUtils.getPeriodType(periodType2);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iType = periodType;
        this.iValues = chronology.get(this, 0L);
    }

    public final PeriodType getPeriodType() {
        return this.iType;
    }

    public final int getValue(int n) {
        return this.iValues[n];
    }
}

