/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfMonth(), durationField);
        this.iChronology = basicChronology;
    }

    public final int get(long l) {
        return this.iChronology.getDayOfMonth(l);
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return 31;
    }

    public final int getMaximumValue(long l) {
        return this.iChronology.getDaysInMonthMax(l);
    }

    protected final int getMaximumValueForSet(long l, int n) {
        return this.iChronology.getDaysInMonthMaxForSet(l, n);
    }

    public final boolean isLeap(long l) {
        return this.iChronology.isLeapDay(l);
    }
}

