/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;

    BasicDayOfYearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfYear(), durationField);
        this.iChronology = basicChronology;
    }

    public final int get(long l) {
        return this.iChronology.getDayOfYear(l);
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return 366;
    }

    public final int getMaximumValue(long l) {
        BasicChronology basicChronology = this.iChronology;
        int n = this.iChronology.getYear(l);
        int n2 = n;
        if (basicChronology.isLeapYear(n2)) {
            return 366;
        }
        return 365;
    }

    protected final int getMaximumValueForSet(long l, int n) {
        if (n > 365 || n <= 0) {
            return this.getMaximumValue(l);
        }
        return 365;
    }

    public final boolean isLeap(long l) {
        return this.iChronology.isLeapDay(l);
    }
}

