/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.ImpreciseDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

class BasicMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private final BasicChronology iChronology;
    private final int iMax;
    private final int iLeapMonth;

    BasicMonthOfYearDateTimeField(BasicChronology basicChronology, int n) {
        super(DateTimeFieldType.monthOfYear(), 2629746000L);
        this.iChronology = basicChronology;
        this.iMax = 12;
        this.iLeapMonth = 2;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l) {
        return this.iChronology.getMonthOfYear(l);
    }

    public final long add(long l, int n) {
        if (n == 0) {
            return l;
        }
        long l2 = BasicChronology.getMillisOfDay(l);
        int n2 = this.iChronology.getYear(l);
        int n3 = this.iChronology.getMonthOfYear(l, n2);
        int n4 = n2;
        int n5 = n3 - 1 + n;
        if (n3 > 0 && n5 < 0) {
            if (Math.signum(n + this.iMax) == Math.signum(n)) {
                --n4;
                n += this.iMax;
            } else {
                ++n4;
                n -= this.iMax;
            }
            n5 = n3 - 1 + n;
        }
        if (n5 >= 0) {
            n4 += n5 / this.iMax;
            n5 = n5 % this.iMax + 1;
        } else {
            n4 = n4 + n5 / this.iMax - 1;
            n = (n5 = Math.abs(n5)) % this.iMax;
            if (n == 0) {
                n = this.iMax;
            }
            if ((n5 = this.iMax - n + 1) == 1) {
                ++n4;
            }
        }
        n = this.iChronology.getDayOfMonth(l, n2, n3);
        int n6 = this.iChronology.getDaysInYearMonth(n4, n5);
        if (n > n6) {
            n = n6;
        }
        long l3 = this.iChronology.getYearMonthDayMillis(n4, n5, n);
        return l3 + l2;
    }

    public final long add(long l, long l2) {
        int n;
        int n2;
        long l3;
        int n3 = (int)l2;
        if ((long)n3 == l2) {
            return this.add(l, n3);
        }
        long l4 = BasicChronology.getMillisOfDay(l);
        n3 = this.iChronology.getYear(l);
        int n4 = this.iChronology.getMonthOfYear(l, n3);
        long l5 = (long)(n4 - 1) + l2;
        if (l5 >= 0L) {
            l3 = (long)n3 + l5 / (long)this.iMax;
            l5 = l5 % (long)this.iMax + 1L;
        } else {
            l3 = (long)n3 + l5 / (long)this.iMax - 1L;
            n2 = (int)((l5 = Math.abs(l5)) % (long)this.iMax);
            if (n2 == 0) {
                n2 = this.iMax;
            }
            if ((l5 = (long)(this.iMax - n2 + 1)) == 1L) {
                ++l3;
            }
        }
        if (l3 < -292275054L || l3 > 292278993L) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + l2);
        }
        n2 = (int)l3;
        int n5 = (int)l5;
        int n6 = this.iChronology.getDayOfMonth(l, n3, n4);
        if (n6 > (n = this.iChronology.getDaysInYearMonth(n2, n5))) {
            n6 = n;
        }
        long l6 = this.iChronology.getYearMonthDayMillis(n2, n5, n6);
        return l6 + l4;
    }

    public final long getDifferenceAsLong(long l, long l2) {
        long l3;
        long l4;
        int n;
        if (l < l2) {
            return -this.getDifference(l2, l);
        }
        int n2 = this.iChronology.getYear(l);
        int n3 = this.iChronology.getMonthOfYear(l, n2);
        int n4 = this.iChronology.getYear(l2);
        int n5 = this.iChronology.getMonthOfYear(l2, n4);
        long l5 = (long)(n2 - n4) * (long)this.iMax + (long)n3 - (long)n5;
        int n6 = this.iChronology.getDayOfMonth(l, n2, n3);
        if (n6 == this.iChronology.getDaysInYearMonth(n2, n3) && (n = this.iChronology.getDayOfMonth(l2, n4, n5)) > n6) {
            l2 = this.iChronology.dayOfMonth().set(l2, n6);
        }
        if ((l4 = l - this.iChronology.getYearMonthMillis(n2, n3)) < (l3 = l2 - this.iChronology.getYearMonthMillis(n4, n5))) {
            --l5;
        }
        return l5;
    }

    public final long set(long l, int n) {
        int n2;
        ISODateTimeFormat.verifyValueBounds(this, n, 1, this.iMax);
        int n3 = n2 = this.iChronology.getYear(l);
        long l2 = l;
        BasicChronology basicChronology = this.iChronology;
        int n4 = basicChronology.getMonthOfYear(l2, n3);
        int n5 = basicChronology.getDayOfMonth(l2, n3, n4);
        n3 = this.iChronology.getDaysInYearMonth(n2, n);
        if (n5 > n3) {
            n5 = n3;
        }
        return this.iChronology.getYearMonthDayMillis(n2, n, n5) + (long)BasicChronology.getMillisOfDay(l);
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public final boolean isLeap(long l) {
        int n = this.iChronology.getYear(l);
        if (this.iChronology.isLeapYear(n)) {
            return this.iChronology.getMonthOfYear(l, n) == this.iLeapMonth;
        }
        return false;
    }

    public final DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return this.iMax;
    }

    public final long roundFloor(long l) {
        int n = this.iChronology.getYear(l);
        int n2 = this.iChronology.getMonthOfYear(l, n);
        return this.iChronology.getYearMonthMillis(n, n2);
    }

    public final long remainder(long l) {
        return l - this.roundFloor(l);
    }
}

