/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.ImpreciseDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private final BasicChronology iChronology;

    BasicWeekyearDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.weekyear(), 31556952000L);
        this.iChronology = basicChronology;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l) {
        return this.iChronology.getWeekyear(l);
    }

    public final long add(long l, int n) {
        if (n == 0) {
            return l;
        }
        return this.set(l, this.get(l) + n);
    }

    public final long add(long l, long l2) {
        return this.add(l, ISODateTimeFormat.safeToInt(l2));
    }

    public final long getDifferenceAsLong(long l, long l2) {
        if (l < l2) {
            return -this.getDifference(l2, l);
        }
        int n = this.get(l);
        int n2 = this.get(l2);
        long l3 = l;
        BasicWeekyearDateTimeField basicWeekyearDateTimeField = this;
        long l4 = l3 - basicWeekyearDateTimeField.roundFloor(l3);
        l3 = l2;
        basicWeekyearDateTimeField = this;
        long l5 = l3 - basicWeekyearDateTimeField.roundFloor(l3);
        if (l5 >= 31449600000L && this.iChronology.getWeeksInYear(n) <= 52) {
            l5 -= 604800000L;
        }
        int n3 = n - n2;
        if (l4 < l5) {
            --n3;
        }
        return n3;
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, Math.abs(n), -292275054, 292278993);
        int n2 = this.get(l);
        if (n2 == n) {
            return l;
        }
        int n3 = BasicChronology.getDayOfWeek(l);
        n2 = this.iChronology.getWeeksInYear(n2);
        int n4 = this.iChronology.getWeeksInYear(n);
        n2 = n4 < n2 ? n4 : n2;
        n4 = this.iChronology.getWeekOfWeekyear(l);
        if (n4 > n2) {
            n4 = n2;
        }
        long l2 = l;
        int n5 = this.get(l2 = this.iChronology.setYear(l2, n));
        if (n5 < n) {
            l2 += 604800000L;
        } else if (n5 > n) {
            l2 -= 604800000L;
        }
        n5 = this.iChronology.getWeekOfWeekyear(l2);
        l2 += (long)(n4 - n5) * 604800000L;
        l2 = this.iChronology.dayOfWeek().set(l2, n3);
        return l2;
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final boolean isLeap(long l) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(l)) > 52;
    }

    public final DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    public final int getMinimumValue() {
        return -292275054;
    }

    public final int getMaximumValue() {
        return 292278993;
    }

    public final long roundFloor(long l) {
        l = this.iChronology.weekOfWeekyear().roundFloor(l);
        int n = this.iChronology.getWeekOfWeekyear(l);
        if (n > 1) {
            l -= 604800000L * (long)(n - 1);
        }
        return l;
    }

    public final long remainder(long l) {
        return l - this.roundFloor(l);
    }
}

