/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.ImpreciseDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

final class BasicYearDateTimeField
extends ImpreciseDateTimeField {
    private BasicChronology iChronology;

    BasicYearDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.year(), 31556952000L);
        this.iChronology = basicChronology;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l) {
        return this.iChronology.getYear(l);
    }

    public final long add(long l, int n) {
        if (n == 0) {
            return l;
        }
        int n2 = this.get(l);
        n = n2;
        int n3 = n2 + (n2 = n);
        if ((n ^ n3) < 0 && (n ^ n2) >= 0) {
            throw new ArithmeticException("The calculation caused an overflow: " + n + " + " + n2);
        }
        n = n3;
        return this.set(l, n);
    }

    public final long add(long l, long l2) {
        return this.add(l, ISODateTimeFormat.safeToInt(l2));
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, -292275054, 292278993);
        return this.iChronology.setYear(l, n);
    }

    public final long setExtended(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, -292275055, 292278994);
        return this.iChronology.setYear(l, n);
    }

    public final long getDifferenceAsLong(long l, long l2) {
        if (l < l2) {
            return -this.iChronology.getYearDifference(l2, l);
        }
        return this.iChronology.getYearDifference(l, l2);
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final boolean isLeap(long l) {
        return this.iChronology.isLeapYear(this.get(l));
    }

    public final DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public final int getMinimumValue() {
        return -292275054;
    }

    public final int getMaximumValue() {
        return 292278993;
    }

    public final long roundFloor(long l) {
        return this.iChronology.getYearMillis(this.get(l));
    }

    public final long remainder(long l) {
        return l - this.roundFloor(l);
    }
}

