/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.PreciseDurationDateTimeField;

final class GJDayOfWeekDateTimeField
extends PreciseDurationDateTimeField {
    private final BasicChronology iChronology;

    GJDayOfWeekDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfWeek(), durationField);
        this.iChronology = basicChronology;
    }

    public final int get(long l) {
        return BasicChronology.getDayOfWeek(l);
    }

    public final String getAsText(int n, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekValueToText(n);
    }

    public final String getAsShortText(int n, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekValueToShortText(n);
    }

    protected final int convertText(String string, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).dayOfWeekTextToValue(string);
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.weeks();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return 7;
    }

    public final int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getDayOfWeekMaxTextLength();
    }
}

