/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.UnsupportedDurationField;
import org.joda.time.format.ISODateTimeFormat;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private final BasicChronology iChronology;

    GJEraDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.era());
        this.iChronology = basicChronology;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l) {
        if (this.iChronology.getYear(l) <= 0) {
            return 0;
        }
        return 1;
    }

    public final String getAsText(int n, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).eraValueToText(n);
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, 0, 1);
        int n2 = this.get(l);
        if (n2 != n) {
            n = this.iChronology.getYear(l);
            return this.iChronology.setYear(l, -n);
        }
        return l;
    }

    public final long set(long l, String string, Locale locale) {
        return this.set(l, GJLocaleSymbols.forLocale(locale).eraTextToValue(string));
    }

    public final long roundFloor(long l) {
        if (this.get(l) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }

    public final DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final int getMinimumValue() {
        return 0;
    }

    public final int getMaximumValue() {
        return 1;
    }

    public final int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getEraMaxTextLength();
    }
}

