/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GJLocaleSymbols {
    private static ConcurrentMap<Locale, GJLocaleSymbols> cCache = new ConcurrentHashMap<Locale, GJLocaleSymbols>();
    private final String[] iEras;
    private final String[] iDaysOfWeek;
    private final String[] iShortDaysOfWeek;
    private final String[] iMonths;
    private final String[] iShortMonths;
    private final String[] iHalfday;
    private final TreeMap<String, Integer> iParseEras;
    private final TreeMap<String, Integer> iParseDaysOfWeek;
    private final TreeMap<String, Integer> iParseMonths;
    private final int iMaxEraLength;
    private final int iMaxDayOfWeekLength;
    private final int iMaxMonthLength;
    private final int iMaxHalfdayLength;

    static GJLocaleSymbols forLocale(Locale object) {
        Object object2;
        if (object == null) {
            object = Locale.getDefault();
        }
        if ((object2 = (GJLocaleSymbols)cCache.get(object)) == null && (object = cCache.putIfAbsent((Locale)object, (GJLocaleSymbols)(object2 = new GJLocaleSymbols((Locale)object)))) != null) {
            object2 = object;
        }
        return object2;
    }

    private static String[] realignMonths(String[] stringArray) {
        String[] stringArray2 = new String[13];
        for (int i = 1; i < 13; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        return stringArray2;
    }

    private static String[] realignDaysOfWeek(String[] stringArray) {
        String[] stringArray2 = new String[8];
        for (int i = 1; i < 8; ++i) {
            stringArray2[i] = stringArray[i < 7 ? i + 1 : 1];
        }
        return stringArray2;
    }

    private static void addSymbols(TreeMap<String, Integer> treeMap, String[] stringArray, Integer[] integerArray) {
        int n = stringArray.length;
        while (--n >= 0) {
            String string = stringArray[n];
            if (string == null) continue;
            treeMap.put(string, integerArray[n]);
        }
    }

    private static void addNumerals(TreeMap<String, Integer> treeMap, int n, int n2, Integer[] integerArray) {
        for (n = 1; n <= n2; ++n) {
            treeMap.put(String.valueOf(n).intern(), integerArray[n]);
        }
    }

    private static int maxLength(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            int n3;
            String string = stringArray[n2];
            if (string == null || (n3 = string.length()) <= n) continue;
            n = n3;
        }
        return n;
    }

    private GJLocaleSymbols(Locale locale) {
        Integer[] integerArray = DateTimeUtils.getDateFormatSymbols(locale);
        this.iEras = integerArray.getEras();
        this.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(integerArray.getWeekdays());
        this.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(integerArray.getShortWeekdays());
        this.iMonths = GJLocaleSymbols.realignMonths(integerArray.getMonths());
        this.iShortMonths = GJLocaleSymbols.realignMonths(integerArray.getShortMonths());
        this.iHalfday = integerArray.getAmPmStrings();
        integerArray = new Integer[13];
        int n = 0;
        while (n < 13) {
            int n2 = n++;
            integerArray[n2] = n2;
        }
        this.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseEras, this.iEras, integerArray);
        if ("en".equals(locale.getLanguage())) {
            this.iParseEras.put("BCE", integerArray[0]);
            this.iParseEras.put("CE", integerArray[1]);
        }
        this.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iDaysOfWeek, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iShortDaysOfWeek, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseDaysOfWeek, 1, 7, integerArray);
        this.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iMonths, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iShortMonths, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseMonths, 1, 12, integerArray);
        this.iMaxEraLength = GJLocaleSymbols.maxLength(this.iEras);
        this.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(this.iDaysOfWeek);
        GJLocaleSymbols.maxLength(this.iShortDaysOfWeek);
        this.iMaxMonthLength = GJLocaleSymbols.maxLength(this.iMonths);
        GJLocaleSymbols.maxLength(this.iShortMonths);
        this.iMaxHalfdayLength = GJLocaleSymbols.maxLength(this.iHalfday);
    }

    public final String eraValueToText(int n) {
        return this.iEras[n];
    }

    public final int eraTextToValue(String string) {
        Integer n = this.iParseEras.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), string);
    }

    public final int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public final String monthOfYearValueToText(int n) {
        return this.iMonths[n];
    }

    public final String monthOfYearValueToShortText(int n) {
        return this.iShortMonths[n];
    }

    public final int monthOfYearTextToValue(String string) {
        Integer n = this.iParseMonths.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), string);
    }

    public final int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }

    public final String dayOfWeekValueToText(int n) {
        return this.iDaysOfWeek[n];
    }

    public final String dayOfWeekValueToShortText(int n) {
        return this.iShortDaysOfWeek[n];
    }

    public final int dayOfWeekTextToValue(String string) {
        Integer n = this.iParseDaysOfWeek.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), string);
    }

    public final int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public final String halfdayValueToText(int n) {
        return this.iHalfday[n];
    }

    public final int halfdayTextToValue(String string) {
        String[] stringArray = this.iHalfday;
        int n = this.iHalfday.length;
        while (--n >= 0) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), string);
    }

    public final int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }
}

