/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

final class GJYearOfEraDateTimeField
extends DecoratedDateTimeField {
    private final BasicChronology iChronology;

    GJYearOfEraDateTimeField(DateTimeField dateTimeField, BasicChronology basicChronology) {
        super(dateTimeField, DateTimeFieldType.yearOfEra());
        this.iChronology = basicChronology;
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.eras();
    }

    public final int get(long l) {
        int n = this.getWrappedField().get(l);
        if (n <= 0) {
            n = 1 - n;
        }
        return n;
    }

    public final long add(long l, int n) {
        return this.getWrappedField().add(l, n);
    }

    public final long add(long l, long l2) {
        return this.getWrappedField().add(l, l2);
    }

    public final int getDifference(long l, long l2) {
        return this.getWrappedField().getDifference(l, l2);
    }

    public final long getDifferenceAsLong(long l, long l2) {
        return this.getWrappedField().getDifferenceAsLong(l, l2);
    }

    public final long set(long l, int n) {
        GJYearOfEraDateTimeField gJYearOfEraDateTimeField = this;
        ISODateTimeFormat.verifyValueBounds(this, n, 1, gJYearOfEraDateTimeField.getWrappedField().getMaximumValue());
        if (this.iChronology.getYear(l) <= 0) {
            n = 1 - n;
        }
        return super.set(l, n);
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return this.getWrappedField().getMaximumValue();
    }

    public final long roundFloor(long l) {
        return this.getWrappedField().roundFloor(l);
    }

    public final long remainder(long l) {
        return this.getWrappedField().remainder(l);
    }
}

