/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;

public final class GregorianChronology
extends BasicGJChronology {
    private static final GregorianChronology INSTANCE_UTC;
    private static final ConcurrentHashMap<DateTimeZone, GregorianChronology[]> cCache;

    public static GregorianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GregorianChronology getInstance(DateTimeZone dateTimeZone, int n) {
        GregorianChronology gregorianChronology;
        GregorianChronology[] gregorianChronologyArray;
        GregorianChronology[] gregorianChronologyArray2;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((gregorianChronologyArray2 = cCache.get(dateTimeZone)) == null && (gregorianChronologyArray = cCache.putIfAbsent(dateTimeZone, gregorianChronologyArray2 = new GregorianChronology[7])) != null) {
            gregorianChronologyArray2 = gregorianChronologyArray;
        }
        try {
            gregorianChronology = gregorianChronologyArray2[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid min days in first week: " + n);
        }
        if (gregorianChronology != null) return gregorianChronology;
        gregorianChronologyArray = gregorianChronologyArray2;
        synchronized (gregorianChronologyArray2) {
            gregorianChronology = gregorianChronologyArray2[n - 1];
            if (gregorianChronology != null) return gregorianChronology;
            if (dateTimeZone == DateTimeZone.UTC) {
                gregorianChronology = new GregorianChronology(null, null, n);
            } else {
                gregorianChronology = GregorianChronology.getInstance(DateTimeZone.UTC, n);
                gregorianChronology = new GregorianChronology(ZonedChronology.getInstance(gregorianChronology, dateTimeZone), null, n);
            }
            gregorianChronologyArray2[n - 1] = gregorianChronology;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return gregorianChronology;
        }
    }

    private GregorianChronology(Chronology chronology, Object object, int n) {
        super(chronology, object, n);
    }

    public final Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public final Chronology withZone(DateTimeZone dateTimeZone) {
        Serializable serializable;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == super.getZone()) {
            return this;
        }
        serializable = dateTimeZone;
        return GregorianChronology.getInstance((DateTimeZone)serializable, 4);
    }

    protected final void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
        }
    }

    final boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    final long calculateFirstDayOfYearMillis(int n) {
        int n2 = n / 100;
        if (n < 0) {
            n2 = (n + 3 >> 2) - n2 + (n2 + 3 >> 2) - 1;
        } else {
            n2 = (n >> 2) - n2 + (n2 >> 2);
            if (this.isLeapYear(n)) {
                --n2;
            }
        }
        return ((long)n * 365L + (long)(n2 - 719527)) * 86400000L;
    }

    static {
        cCache = new ConcurrentHashMap();
        DateTimeZone dateTimeZone = DateTimeZone.UTC;
        INSTANCE_UTC = GregorianChronology.getInstance(dateTimeZone, 4);
    }
}

