/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZonedChronology
extends AssembledChronology {
    public static ZonedChronology getInstance(Chronology chronology, DateTimeZone dateTimeZone) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        if ((chronology = chronology.withUTC()) == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(chronology, dateTimeZone);
    }

    static boolean useTimeArithmetic(DurationField durationField) {
        return durationField != null && durationField.getUnitMillis() < 43200000L;
    }

    private ZonedChronology(Chronology chronology, DateTimeZone dateTimeZone) {
        super(chronology, dateTimeZone);
    }

    @Override
    public final DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    @Override
    public final Chronology withUTC() {
        return this.getBase();
    }

    @Override
    public final Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getParam()) {
            return this;
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), dateTimeZone);
    }

    @Override
    protected final void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, hashMap);
        fields.centuries = this.convertField(fields.centuries, hashMap);
        fields.years = this.convertField(fields.years, hashMap);
        fields.months = this.convertField(fields.months, hashMap);
        fields.weekyears = this.convertField(fields.weekyears, hashMap);
        fields.weeks = this.convertField(fields.weeks, hashMap);
        fields.days = this.convertField(fields.days, hashMap);
        fields.halfdays = this.convertField(fields.halfdays, hashMap);
        fields.hours = this.convertField(fields.hours, hashMap);
        fields.minutes = this.convertField(fields.minutes, hashMap);
        fields.seconds = this.convertField(fields.seconds, hashMap);
        fields.millis = this.convertField(fields.millis, hashMap);
        fields.year = this.convertField(fields.year, hashMap);
        fields.yearOfEra = this.convertField(fields.yearOfEra, hashMap);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, hashMap);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, hashMap);
        fields.era = this.convertField(fields.era, hashMap);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, hashMap);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, hashMap);
        fields.dayOfYear = this.convertField(fields.dayOfYear, hashMap);
        fields.monthOfYear = this.convertField(fields.monthOfYear, hashMap);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, hashMap);
        fields.weekyear = this.convertField(fields.weekyear, hashMap);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, hashMap);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, hashMap);
        fields.millisOfDay = this.convertField(fields.millisOfDay, hashMap);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, hashMap);
        fields.secondOfDay = this.convertField(fields.secondOfDay, hashMap);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, hashMap);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, hashMap);
        fields.hourOfDay = this.convertField(fields.hourOfDay, hashMap);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, hashMap);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, hashMap);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, hashMap);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, hashMap);
    }

    private DurationField convertField(DurationField durationField, HashMap<Object, Object> hashMap) {
        if (durationField == null || !durationField.isSupported()) {
            return durationField;
        }
        if (hashMap.containsKey(durationField)) {
            return (DurationField)hashMap.get(durationField);
        }
        Serializable serializable = this;
        serializable = new ZonedDurationField(durationField, (DateTimeZone)serializable.getParam());
        hashMap.put(durationField, serializable);
        return serializable;
    }

    private DateTimeField convertField(DateTimeField dateTimeField, HashMap<Object, Object> hashMap) {
        if (dateTimeField == null || !dateTimeField.isSupported()) {
            return dateTimeField;
        }
        if (hashMap.containsKey(dateTimeField)) {
            return (DateTimeField)hashMap.get(dateTimeField);
        }
        Object object = this;
        object = new ZonedDateTimeField(dateTimeField, (DateTimeZone)((AssembledChronology)object).getParam(), this.convertField(dateTimeField.getDurationField(), hashMap), this.convertField(dateTimeField.getRangeDurationField(), hashMap), this.convertField(dateTimeField.getLeapDurationField(), hashMap));
        hashMap.put(dateTimeField, object);
        return object;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZonedChronology)) {
            return false;
        }
        object = (ZonedChronology)object;
        if (this.getBase().equals(((AssembledChronology)object).getBase())) {
            ZonedChronology zonedChronology;
            Object object2 = this;
            object2 = object;
            if (((DateTimeZone)zonedChronology.getParam()).equals((DateTimeZone)((AssembledChronology)object2).getParam())) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        ZonedChronology zonedChronology = this;
        return 326565 + ((DateTimeZone)zonedChronology.getParam()).hashCode() * 11 + this.getBase().hashCode() * 7;
    }

    public final String toString() {
        ZonedChronology zonedChronology = this;
        return "ZonedChronology[" + this.getBase() + ", " + ((DateTimeZone)zonedChronology.getParam()).getID() + ']';
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        private DateTimeField iField;
        private DateTimeZone iZone;
        private DurationField iDurationField;
        private boolean iTimeField;
        private DurationField iRangeDurationField;
        private DurationField iLeapDurationField;

        ZonedDateTimeField(DateTimeField dateTimeField, DateTimeZone dateTimeZone, DurationField durationField, DurationField durationField2, DurationField durationField3) {
            super(dateTimeField.getType());
            if (!dateTimeField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = dateTimeField;
            this.iZone = dateTimeZone;
            this.iDurationField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iRangeDurationField = durationField2;
            this.iLeapDurationField = durationField3;
        }

        public final boolean isLenient() {
            return this.iField.isLenient();
        }

        public final int get(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.get(l2);
        }

        public final String getAsText(long l, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getAsText(l2, locale);
        }

        public final String getAsShortText(long l, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getAsShortText(l2, locale);
        }

        public final String getAsText(int n, Locale locale) {
            return this.iField.getAsText(n, locale);
        }

        public final String getAsShortText(int n, Locale locale) {
            return this.iField.getAsShortText(n, locale);
        }

        public final long add(long l, int n) {
            if (this.iTimeField) {
                int n2 = this.getOffsetToAdd(l);
                long l2 = this.iField.add(l + (long)n2, n);
                return l2 - (long)n2;
            }
            long l3 = this.iZone.convertUTCToLocal(l);
            l3 = this.iField.add(l3, n);
            return this.iZone.convertLocalToUTC(l3, false, l);
        }

        public final long add(long l, long l2) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(l);
                long l3 = this.iField.add(l + (long)n, l2);
                return l3 - (long)n;
            }
            long l4 = this.iZone.convertUTCToLocal(l);
            l4 = this.iField.add(l4, l2);
            return this.iZone.convertLocalToUTC(l4, false, l);
        }

        public final long set(long l, int n) {
            long l2 = this.iZone.convertUTCToLocal(l);
            long l3 = this.iZone.convertLocalToUTC(l2 = this.iField.set(l2, n), false, l);
            if (this.get(l3) != n) {
                IllegalInstantException illegalInstantException = new IllegalInstantException(l2, this.iZone.getID());
                IllegalFieldValueException illegalFieldValueException = new IllegalFieldValueException(this.iField.getType(), n, illegalInstantException.getMessage());
                illegalFieldValueException.initCause(illegalInstantException);
                throw illegalFieldValueException;
            }
            return l3;
        }

        public final long set(long l, String string, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            l2 = this.iField.set(l2, string, locale);
            return this.iZone.convertLocalToUTC(l2, false, l);
        }

        public final int getDifference(long l, long l2) {
            int n = this.getOffsetToAdd(l2);
            return this.iField.getDifference(l + (long)(this.iTimeField ? n : this.getOffsetToAdd(l)), l2 + (long)n);
        }

        public final long getDifferenceAsLong(long l, long l2) {
            int n = this.getOffsetToAdd(l2);
            return this.iField.getDifferenceAsLong(l + (long)(this.iTimeField ? n : this.getOffsetToAdd(l)), l2 + (long)n);
        }

        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public final boolean isLeap(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.isLeap(l2);
        }

        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        public final long roundFloor(long l) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(l);
                l = this.iField.roundFloor(l + (long)n);
                return l - (long)n;
            }
            long l2 = this.iZone.convertUTCToLocal(l);
            l2 = this.iField.roundFloor(l2);
            return this.iZone.convertLocalToUTC(l2, false, l);
        }

        public final long remainder(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.remainder(l2);
        }

        public final int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        public final int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        public final int getMaximumValue(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getMaximumValue(l2);
        }

        public final int getMaximumTextLength(Locale locale) {
            return this.iField.getMaximumTextLength(locale);
        }

        private int getOffsetToAdd(long l) {
            int n = this.iZone.getOffset(l);
            long l2 = l + (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ZonedDateTimeField) {
                object = (ZonedDateTimeField)object;
                return this.iField.equals(((ZonedDateTimeField)object).iField) && this.iZone.equals(((ZonedDateTimeField)object).iZone) && this.iDurationField.equals(((ZonedDateTimeField)object).iDurationField) && this.iRangeDurationField.equals(((ZonedDateTimeField)object).iRangeDurationField);
            }
            return false;
        }

        public final int hashCode() {
            return this.iField.hashCode() ^ this.iZone.hashCode();
        }
    }

    static final class ZonedDurationField
    extends BaseDurationField {
        private DurationField iField;
        private boolean iTimeField;
        private DateTimeZone iZone;

        ZonedDurationField(DurationField durationField, DateTimeZone dateTimeZone) {
            super(durationField.getType());
            if (!durationField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iZone = dateTimeZone;
        }

        public final boolean isPrecise() {
            if (this.iTimeField) {
                return this.iField.isPrecise();
            }
            return this.iField.isPrecise() && this.iZone.isFixed();
        }

        public final long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        public final long add(long l, int n) {
            int n2 = this.getOffsetToAdd(l);
            l = this.iField.add(l + (long)n2, n);
            return l - (long)(this.iTimeField ? n2 : this.getOffsetFromLocalToSubtract(l));
        }

        public final long add(long l, long l2) {
            int n = this.getOffsetToAdd(l);
            l = this.iField.add(l + (long)n, l2);
            return l - (long)(this.iTimeField ? n : this.getOffsetFromLocalToSubtract(l));
        }

        public final int getDifference(long l, long l2) {
            int n = this.getOffsetToAdd(l2);
            return this.iField.getDifference(l + (long)(this.iTimeField ? n : this.getOffsetToAdd(l)), l2 + (long)n);
        }

        public final long getDifferenceAsLong(long l, long l2) {
            int n = this.getOffsetToAdd(l2);
            return this.iField.getDifferenceAsLong(l + (long)(this.iTimeField ? n : this.getOffsetToAdd(l)), l2 + (long)n);
        }

        private int getOffsetToAdd(long l) {
            int n = this.iZone.getOffset(l);
            long l2 = l + (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }

        private int getOffsetFromLocalToSubtract(long l) {
            int n = this.iZone.getOffsetFromLocal(l);
            long l2 = l - (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) < 0L) {
                throw new ArithmeticException("Subtracting time zone offset caused overflow");
            }
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ZonedDurationField) {
                object = (ZonedDurationField)object;
                return this.iField.equals(((ZonedDurationField)object).iField) && this.iZone.equals(((ZonedDurationField)object).iZone);
            }
            return false;
        }

        public final int hashCode() {
            return this.iField.hashCode() ^ this.iZone.hashCode();
        }
    }
}

