/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = dateTimeFieldType;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return true;
    }

    public abstract int get(long var1);

    public String getAsText(long l, Locale locale) {
        BaseDateTimeField baseDateTimeField = this;
        return baseDateTimeField.getAsText(baseDateTimeField.get(l), locale);
    }

    public String getAsText(int n, Locale locale) {
        return Integer.toString(n);
    }

    public String getAsShortText(long l, Locale locale) {
        BaseDateTimeField baseDateTimeField = this;
        return baseDateTimeField.getAsShortText(baseDateTimeField.get(l), locale);
    }

    public String getAsShortText(int n, Locale locale) {
        return this.getAsText(n, locale);
    }

    public long add(long l, int n) {
        return this.getDurationField().add(l, n);
    }

    public long add(long l, long l2) {
        return this.getDurationField().add(l, l2);
    }

    public int getDifference(long l, long l2) {
        return this.getDurationField().getDifference(l, l2);
    }

    public long getDifferenceAsLong(long l, long l2) {
        return this.getDurationField().getDifferenceAsLong(l, l2);
    }

    public abstract long set(long var1, int var3);

    public long set(long l, String string, Locale locale) {
        int n = this.convertText(string, locale);
        return this.set(l, n);
    }

    protected int convertText(String string, Locale object) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            object = this;
            throw new IllegalFieldValueException(((BaseDateTimeField)object).iType, string);
        }
    }

    public abstract DurationField getDurationField();

    public boolean isLeap(long l) {
        return false;
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public abstract int getMaximumValue();

    public int getMaximumValue(long l) {
        return this.getMaximumValue();
    }

    public int getMaximumTextLength(Locale locale) {
        int n = this.getMaximumValue();
        if (n >= 0) {
            if (n < 10) {
                return 1;
            }
            if (n < 100) {
                return 2;
            }
            if (n < 1000) {
                return 3;
            }
        }
        return Integer.toString(n).length();
    }

    public abstract long roundFloor(long var1);

    public long remainder(long l) {
        return l - this.roundFloor(l);
    }

    public String toString() {
        BaseDateTimeField baseDateTimeField = this;
        return "DateTimeField[" + baseDateTimeField.iType.getName() + ']';
    }
}

