/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.format.ISODateTimeFormat;

public abstract class BaseDurationField
extends DurationField
implements Serializable {
    private final DurationFieldType iType;

    protected BaseDurationField(DurationFieldType durationFieldType) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = durationFieldType;
    }

    public final DurationFieldType getType() {
        return this.iType;
    }

    public final boolean isSupported() {
        return true;
    }

    public int getDifference(long l, long l2) {
        return ISODateTimeFormat.safeToInt(this.getDifferenceAsLong(l, l2));
    }

    public String toString() {
        BaseDurationField baseDurationField = this;
        return "DurationField[" + baseDurationField.iType.getName() + ']';
    }
}

