/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.ScaledDurationField;
import org.joda.time.format.ISODateTimeFormat;

public final class DividedDateTimeField
extends DecoratedDateTimeField {
    final int iDivisor;
    final DurationField iDurationField;
    private DurationField iRangeDurationField;
    private final int iMin;
    private final int iMax;

    public DividedDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n) {
        DateTimeField dateTimeField2 = dateTimeField;
        this(dateTimeField2, dateTimeField2.getRangeDurationField(), dateTimeFieldType, 100);
    }

    private DividedDateTimeField(DateTimeField dateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType, int n) {
        super(dateTimeField, dateTimeFieldType);
        if (n < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField2 = dateTimeField.getDurationField();
        this.iDurationField = durationField2 == null ? null : new ScaledDurationField(durationField2, dateTimeFieldType.getDurationType(), n);
        this.iRangeDurationField = durationField;
        this.iDivisor = n;
        int n2 = dateTimeField.getMinimumValue();
        n2 = n2 >= 0 ? n2 / n : (n2 + 1) / n - 1;
        int n3 = dateTimeField.getMaximumValue();
        n3 = n3 >= 0 ? n3 / n : (n3 + 1) / n - 1;
        this.iMin = n2;
        this.iMax = n3;
    }

    public final DurationField getRangeDurationField() {
        if (this.iRangeDurationField != null) {
            return this.iRangeDurationField;
        }
        return super.getRangeDurationField();
    }

    public final int get(long l) {
        int n = this.getWrappedField().get(l);
        if (n >= 0) {
            return n / this.iDivisor;
        }
        return (n + 1) / this.iDivisor - 1;
    }

    public final long add(long l, int n) {
        return this.getWrappedField().add(l, n * this.iDivisor);
    }

    public final long add(long l, long l2) {
        return this.getWrappedField().add(l, l2 * (long)this.iDivisor);
    }

    public final int getDifference(long l, long l2) {
        return this.getWrappedField().getDifference(l, l2) / this.iDivisor;
    }

    public final long getDifferenceAsLong(long l, long l2) {
        return this.getWrappedField().getDifferenceAsLong(l, l2) / (long)this.iDivisor;
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, this.iMin, this.iMax);
        DividedDateTimeField dividedDateTimeField = this;
        int n2 = dividedDateTimeField.getWrappedField().get(l);
        DividedDateTimeField dividedDateTimeField2 = dividedDateTimeField;
        int n3 = n2 >= 0 ? n2 % dividedDateTimeField2.iDivisor : dividedDateTimeField2.iDivisor - 1 + (n2 + 1) % dividedDateTimeField2.iDivisor;
        return this.getWrappedField().set(l, n * this.iDivisor + n3);
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public final int getMinimumValue() {
        return this.iMin;
    }

    public final int getMaximumValue() {
        return this.iMax;
    }

    public final long roundFloor(long l) {
        DateTimeField dateTimeField = this.getWrappedField();
        return dateTimeField.roundFloor(dateTimeField.set(l, this.get(l) * this.iDivisor));
    }

    public final long remainder(long l) {
        DividedDateTimeField dividedDateTimeField = this;
        return this.set(l, dividedDateTimeField.get(dividedDateTimeField.getWrappedField().remainder(l)));
    }
}

