/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;
import org.joda.time.format.ISODateTimeFormat;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    final long iUnitMillis;
    private final DurationField iDurationField;

    public ImpreciseDateTimeField(DateTimeFieldType dateTimeFieldType, long l) {
        super(dateTimeFieldType);
        this.iUnitMillis = l;
        this.iDurationField = new LinkedDurationField(this, dateTimeFieldType.getDurationType());
    }

    public abstract long add(long var1, int var3);

    public abstract long add(long var1, long var3);

    public final int getDifference(long l, long l2) {
        return ISODateTimeFormat.safeToInt(this.getDifferenceAsLong(l, l2));
    }

    public long getDifferenceAsLong(long l, long l2) {
        if (l < l2) {
            return -this.getDifferenceAsLong(l2, l);
        }
        long l3 = (l - l2) / this.iUnitMillis;
        if (this.add(l2, l3) < l) {
            while (this.add(l2, ++l3) <= l) {
            }
            --l3;
        } else if (this.add(l2, l3) > l) {
            while (this.add(l2, --l3) > l) {
            }
        }
        return l3;
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    final class LinkedDurationField
    extends BaseDurationField {
        private /* synthetic */ ImpreciseDateTimeField this$0;

        LinkedDurationField(ImpreciseDateTimeField impreciseDateTimeField, DurationFieldType durationFieldType) {
            this.this$0 = impreciseDateTimeField;
            super(durationFieldType);
        }

        public final boolean isPrecise() {
            return false;
        }

        public final long getUnitMillis() {
            return this.this$0.iUnitMillis;
        }

        public final long add(long l, int n) {
            return this.this$0.add(l, n);
        }

        public final long add(long l, long l2) {
            return this.this$0.add(l, l2);
        }

        public final int getDifference(long l, long l2) {
            return this.this$0.getDifference(l, l2);
        }

        public final long getDifferenceAsLong(long l, long l2) {
            return this.this$0.getDifferenceAsLong(l, l2);
        }
    }
}

