/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.format.ISODateTimeFormat;

public final class MillisDurationField
extends DurationField
implements Serializable {
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    public final DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    public final boolean isSupported() {
        return true;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return 1L;
    }

    public final long add(long l, int n) {
        return ISODateTimeFormat.safeAdd(l, n);
    }

    public final long add(long l, long l2) {
        return ISODateTimeFormat.safeAdd(l, l2);
    }

    public final int getDifference(long l, long l2) {
        return ISODateTimeFormat.safeToInt(ISODateTimeFormat.safeSubtract(l, l2));
    }

    public final long getDifferenceAsLong(long l, long l2) {
        return ISODateTimeFormat.safeSubtract(l, l2);
    }

    public final boolean equals(Object object) {
        if (object instanceof MillisDurationField) {
            MillisDurationField millisDurationField = this;
            millisDurationField = (MillisDurationField)object;
            return 1L == 1L;
        }
        return false;
    }

    public final int hashCode() {
        MillisDurationField millisDurationField = this;
        return (int)1L;
    }

    public final String toString() {
        return "DurationField[millis]";
    }
}

