/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

public final class OffsetDateTimeField
extends DecoratedDateTimeField {
    private final int iOffset;
    private final int iMin;
    private final int iMax;

    public OffsetDateTimeField(DateTimeField dateTimeField, int n) {
        DateTimeField dateTimeField2 = dateTimeField;
        this(dateTimeField2, dateTimeField2 == null ? null : dateTimeField.getType(), 99, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n) {
        this(dateTimeField, dateTimeFieldType, 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n, int n2, int n3) {
        super(dateTimeField, dateTimeFieldType);
        if (n == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = n;
        this.iMin = Integer.MIN_VALUE < dateTimeField.getMinimumValue() + n ? dateTimeField.getMinimumValue() + n : Integer.MIN_VALUE;
        if (Integer.MAX_VALUE > dateTimeField.getMaximumValue() + n) {
            this.iMax = dateTimeField.getMaximumValue() + n;
            return;
        }
        this.iMax = Integer.MAX_VALUE;
    }

    public final int get(long l) {
        return super.get(l) + this.iOffset;
    }

    public final long add(long l, int n) {
        l = super.add(l, n);
        OffsetDateTimeField offsetDateTimeField = this;
        ISODateTimeFormat.verifyValueBounds(offsetDateTimeField, offsetDateTimeField.get(l), this.iMin, this.iMax);
        return l;
    }

    public final long add(long l, long l2) {
        l = super.add(l, l2);
        OffsetDateTimeField offsetDateTimeField = this;
        ISODateTimeFormat.verifyValueBounds(offsetDateTimeField, offsetDateTimeField.get(l), this.iMin, this.iMax);
        return l;
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, this.iMin, this.iMax);
        return super.set(l, n - this.iOffset);
    }

    public final boolean isLeap(long l) {
        return this.getWrappedField().isLeap(l);
    }

    public final DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public final int getMinimumValue() {
        return this.iMin;
    }

    public final int getMaximumValue() {
        return this.iMax;
    }

    public final long roundFloor(long l) {
        return this.getWrappedField().roundFloor(l);
    }

    public final long remainder(long l) {
        return this.getWrappedField().remainder(l);
    }
}

