/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.PreciseDurationDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

public class PreciseDateTimeField
extends PreciseDurationDateTimeField {
    private final int iRange;
    private final DurationField iRangeField;

    public PreciseDateTimeField(DateTimeFieldType object, DurationField durationField, DurationField durationField2) {
        super((DateTimeFieldType)object, durationField);
        if (!durationField2.isPrecise()) {
            throw new IllegalArgumentException("Range duration field must be precise");
        }
        long l = durationField2.getUnitMillis();
        object = this;
        this.iRange = (int)(l / ((PreciseDurationDateTimeField)object).iUnitMillis);
        if (this.iRange < 2) {
            throw new IllegalArgumentException("The effective range must be at least 2");
        }
        this.iRangeField = durationField2;
    }

    public final int get(long l) {
        if (l >= 0L) {
            PreciseDateTimeField preciseDateTimeField = this;
            return (int)(l / preciseDateTimeField.iUnitMillis % (long)this.iRange);
        }
        PreciseDateTimeField preciseDateTimeField = this;
        return this.iRange - 1 + (int)((l + 1L) / preciseDateTimeField.iUnitMillis % (long)this.iRange);
    }

    public final long set(long l, int n) {
        PreciseDateTimeField preciseDateTimeField = this;
        ISODateTimeFormat.verifyValueBounds(this, n, this.getMinimumValue(), preciseDateTimeField.iRange - 1);
        return l + (long)(n - this.get(l)) * this.iUnitMillis;
    }

    public final DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    public final int getMaximumValue() {
        return this.iRange - 1;
    }
}

