/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

public abstract class PreciseDurationDateTimeField
extends BaseDateTimeField {
    final long iUnitMillis;
    private final DurationField iUnitField;

    public PreciseDurationDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        super(dateTimeFieldType);
        if (!durationField.isPrecise()) {
            throw new IllegalArgumentException("Unit duration field must be precise");
        }
        this.iUnitMillis = durationField.getUnitMillis();
        if (this.iUnitMillis < 1L) {
            throw new IllegalArgumentException("The unit milliseconds must be at least 1");
        }
        this.iUnitField = durationField;
    }

    public final boolean isLenient() {
        return false;
    }

    public long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, this.getMinimumValue(), this.getMaximumValueForSet(l, n));
        return l + (long)(n - this.get(l)) * this.iUnitMillis;
    }

    public long roundFloor(long l) {
        if (l >= 0L) {
            long l2 = l;
            return l2 - l2 % this.iUnitMillis;
        }
        return ++l - l % this.iUnitMillis - this.iUnitMillis;
    }

    public long remainder(long l) {
        if (l >= 0L) {
            return l % this.iUnitMillis;
        }
        return (l + 1L) % this.iUnitMillis + this.iUnitMillis - 1L;
    }

    public final DurationField getDurationField() {
        return this.iUnitField;
    }

    public int getMinimumValue() {
        return 0;
    }

    protected int getMaximumValueForSet(long l, int n) {
        return this.getMaximumValue(l);
    }
}

