/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.format.ISODateTimeFormat;

public final class PreciseDurationField
extends BaseDurationField {
    private final long iUnitMillis;

    public PreciseDurationField(DurationFieldType durationFieldType, long l) {
        super(durationFieldType);
        this.iUnitMillis = l;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    public final long add(long l, int n) {
        long l2 = (long)n * this.iUnitMillis;
        return ISODateTimeFormat.safeAdd(l, l2);
    }

    public final long add(long l, long l2) {
        long l3;
        long l4 = this.iUnitMillis;
        long l5 = l2;
        if (l4 == 1L) {
            l3 = l5;
        } else if (l5 == 1L) {
            l3 = l4;
        } else if (l5 == 0L || l4 == 0L) {
            l3 = 0L;
        } else {
            long l6 = l5 * l4;
            if (l6 / l4 != l5 || l5 == Long.MIN_VALUE && l4 == -1L || l4 == Long.MIN_VALUE && l5 == -1L) {
                throw new ArithmeticException("Multiplication overflows a long: " + l5 + " * " + l4);
            }
            l3 = l6;
        }
        long l7 = l3;
        return ISODateTimeFormat.safeAdd(l, l7);
    }

    public final long getDifferenceAsLong(long l, long l2) {
        long l3 = ISODateTimeFormat.safeSubtract(l, l2);
        return l3 / this.iUnitMillis;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PreciseDurationField) {
            object = (PreciseDurationField)object;
            return this.getType() == ((BaseDurationField)object).getType() && this.iUnitMillis == ((PreciseDurationField)object).iUnitMillis;
        }
        return false;
    }

    public final int hashCode() {
        long l = this.iUnitMillis;
        int n = (int)(l ^ l >>> 32);
        return n += this.getType().hashCode();
    }
}

