/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

public final class RemainderDateTimeField
extends DecoratedDateTimeField {
    private int iDivisor;
    private DurationField iDurationField;
    private DurationField iRangeField;

    public RemainderDateTimeField(DateTimeField dateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType, int n) {
        super(dateTimeField, dateTimeFieldType);
        this.iRangeField = durationField;
        this.iDurationField = dateTimeField.getDurationField();
        this.iDivisor = 100;
    }

    public RemainderDateTimeField(DividedDateTimeField dividedDateTimeField) {
        DividedDateTimeField dividedDateTimeField2 = dividedDateTimeField;
        this(dividedDateTimeField2, dividedDateTimeField2.getType());
    }

    public RemainderDateTimeField(DividedDateTimeField dividedDateTimeField, DateTimeFieldType dateTimeFieldType) {
        DividedDateTimeField dividedDateTimeField2 = dividedDateTimeField;
        this(dividedDateTimeField2, dividedDateTimeField2.getWrappedField().getDurationField(), dateTimeFieldType);
    }

    public RemainderDateTimeField(DividedDateTimeField dividedDateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType) {
        super(dividedDateTimeField.getWrappedField(), dateTimeFieldType);
        this.iDivisor = dividedDateTimeField.iDivisor;
        this.iDurationField = durationField;
        this.iRangeField = dividedDateTimeField.iDurationField;
    }

    public final int get(long l) {
        int n = this.getWrappedField().get(l);
        if (n >= 0) {
            return n % this.iDivisor;
        }
        return this.iDivisor - 1 + (n + 1) % this.iDivisor;
    }

    public final long set(long l, int n) {
        ISODateTimeFormat.verifyValueBounds(this, n, 0, this.iDivisor - 1);
        RemainderDateTimeField remainderDateTimeField = this;
        int n2 = remainderDateTimeField.getWrappedField().get(l);
        RemainderDateTimeField remainderDateTimeField2 = remainderDateTimeField;
        int n3 = n2 >= 0 ? n2 / remainderDateTimeField2.iDivisor : (n2 + 1) / remainderDateTimeField2.iDivisor - 1;
        return this.getWrappedField().set(l, n3 * this.iDivisor + n);
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public final DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    public final int getMinimumValue() {
        return 0;
    }

    public final int getMaximumValue() {
        return this.iDivisor - 1;
    }

    public final long roundFloor(long l) {
        return this.getWrappedField().roundFloor(l);
    }

    public final long remainder(long l) {
        return this.getWrappedField().remainder(l);
    }
}

