/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.DecoratedDurationField;

public final class ScaledDurationField
extends DecoratedDurationField {
    private final int iScalar;

    public ScaledDurationField(DurationField durationField, DurationFieldType durationFieldType, int n) {
        super(durationField, durationFieldType);
        if (n == 0 || n == 1) {
            throw new IllegalArgumentException("The scalar must not be 0 or 1");
        }
        this.iScalar = n;
    }

    public final long add(long l, int n) {
        long l2 = (long)n * (long)this.iScalar;
        return this.getWrappedField().add(l, l2);
    }

    public final long add(long l, long l2) {
        long l3;
        int n = this.iScalar;
        long l4 = l2;
        switch (n) {
            case -1: {
                if (l4 == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + l4 + " * " + n);
                }
                l3 = -l4;
                break;
            }
            case 0: {
                l3 = 0L;
                break;
            }
            case 1: {
                l3 = l4;
                break;
            }
            default: {
                long l5 = l4 * (long)n;
                if (l5 / (long)n != l4) {
                    throw new ArithmeticException("Multiplication overflows a long: " + l4 + " * " + n);
                }
                l3 = l5;
            }
        }
        long l6 = l3;
        return this.getWrappedField().add(l, l6);
    }

    public final int getDifference(long l, long l2) {
        return this.getWrappedField().getDifference(l, l2) / this.iScalar;
    }

    public final long getDifferenceAsLong(long l, long l2) {
        return this.getWrappedField().getDifferenceAsLong(l, l2) / (long)this.iScalar;
    }

    public final long getUnitMillis() {
        return this.getWrappedField().getUnitMillis() * (long)this.iScalar;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ScaledDurationField) {
            object = (ScaledDurationField)object;
            return this.getWrappedField().equals(((DecoratedDurationField)object).getWrappedField()) && this.getType() == ((BaseDurationField)object).getType() && this.iScalar == ((ScaledDurationField)object).iScalar;
        }
        return false;
    }

    public final int hashCode() {
        long l = this.iScalar;
        int n = (int)(l ^ l >>> 32);
        n += this.getType().hashCode();
        return n += this.getWrappedField().hashCode();
    }
}

